/*
 * Decompiled with CFR 0.152.
 */
package com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph;

import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.ClusteredGraph;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.GraphModificationEvent;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.IGraphModificationListener;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Node;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Tree;

public class ClusterNodesAdditionListener
implements IGraphModificationListener {
    private ClusteredGraph myGraph;
    private Node myCurrentCluster;

    public ClusterNodesAdditionListener(ClusteredGraph graph) {
        this.myGraph = graph;
        this.myCurrentCluster = graph.getRoot();
        graph.addListener(this);
    }

    @Override
    public void process(GraphModificationEvent event) {
        if (event.getType() == GraphModificationEvent.Type.NODE_CREATED) {
            Tree tree = this.myGraph.getInclusionTree();
            Node newCluster = tree.createNode();
            this.myGraph.setNodeInCluster(newCluster, event.getNode());
            tree.connect(this.myCurrentCluster, newCluster);
        }
    }

    public void setCurrentCluster(Node cluster) {
        this.myCurrentCluster = cluster;
    }
}

