/*
 * Decompiled with CFR 0.152.
 */
package com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph;

import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Edge;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Graph;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.IClusteredGraph;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.INode;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Node;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Tree;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.IListSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ISelector;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ISetSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ListSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.MapSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.SetSequence;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ClusteredGraph
extends Graph
implements IClusteredGraph {
    private Tree myInclusionTree = new Tree();
    private Map<Node, Node> myLeafClusters = MapSequence.fromMap(new HashMap());
    private Node myRoot;

    public Set<Node> getNodesInCluster(INode cluster) {
        ISetSequence<Node> nodes = SetSequence.fromSet(new LinkedHashSet());
        this.getNodesInCluster((Node)cluster, nodes);
        return nodes;
    }

    public List<Node> getSubclusters(final Node cluster) {
        return ListSequence.fromList(cluster.getOutEdges()).select(new ISelector<Edge, Node>(this){

            @Override
            public Node select(Edge edge) {
                return edge.getOpposite(cluster);
            }
        }).toListSequence();
    }

    public void setNodeInCluster(Node cluster, Node node) {
        MapSequence.fromMap(this.myLeafClusters).put(cluster, node);
    }

    private void getNodesInCluster(Node cluster, Set<Node> nodes) {
        IListSequence<Node> subclusters = ListSequence.fromList(cluster.getOutEdges()).select(new ISelector<Edge, Node>(this){

            @Override
            public Node select(Edge it) {
                return it.getTarget();
            }
        }).toListSequence();
        for (Node subcluster : ListSequence.fromList(subclusters)) {
            this.getNodesInCluster(subcluster, nodes);
        }
        Node node = (Node)MapSequence.fromMap(this.myLeafClusters).get(cluster);
        if (node != null) {
            SetSequence.fromSet(nodes).addElement(node);
        }
    }

    public void setRoot(Node root) {
        this.myRoot = root;
    }

    @Override
    public Node getRoot() {
        return this.myRoot;
    }

    @Override
    public Graph getUnderlyingGraph() {
        return this;
    }

    @Override
    public Graph createNew() {
        return new ClusteredGraph();
    }

    @Override
    public Tree getInclusionTree() {
        return this.myInclusionTree;
    }

    public List<Node> getClusters() {
        return this.getInclusionTree().getNodes();
    }

    void setInclusionTree(Tree tree, Node root) {
        this.myInclusionTree = tree;
        this.setRoot(root);
    }

    public boolean isLeafCluster(Node cluster) {
        return ListSequence.fromList(cluster.getOutEdges()).count() == 0;
    }
}

