/*
 * Decompiled with CFR 0.152.
 */
package com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph;

import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Edge;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Graph;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.GraphModificationEvent;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.IGraphModificationListener;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Node;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ListSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.MapSequence;
import java.util.HashMap;
import java.util.Map;

public class CreationStageManager
implements IGraphModificationListener {
    private int myStage = 0;
    private Map<Object, Integer> myCreationStage = MapSequence.fromMap(new HashMap());

    public CreationStageManager(Graph graph) {
        for (Node node : ListSequence.fromList(graph.getNodes())) {
            this.putStage(node);
        }
        for (Edge edge : ListSequence.fromList(graph.getEdges())) {
            this.putStage(edge);
        }
        this.nextStage();
        graph.addListener(this);
    }

    @Override
    public void process(GraphModificationEvent event) {
        switch (event.getType()) {
            case EDGE_ADDED: {
                this.putStage(event.getEdge());
                break;
            }
            case NODE_CREATED: {
                this.putStage(event.getNode());
                break;
            }
        }
    }

    private void putStage(Object object) {
        MapSequence.fromMap(this.myCreationStage).put(object, this.myStage);
    }

    public void nextStage() {
        ++this.myStage;
    }

    public int getStage(Object object) {
        return (Integer)MapSequence.fromMap(this.myCreationStage).get(object);
    }
}

