/*
 * Decompiled with CFR 0.152.
 */
package com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph;

import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.IEdge;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.INode;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Node;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ListSequence;
import java.util.ArrayList;
import java.util.List;

public class Edge
implements IEdge {
    private Node mySource;
    private Node myTarget;

    public Edge(Node source, Node target) {
        this.mySource = source;
        this.myTarget = target;
    }

    @Override
    public Node getSource() {
        return this.mySource;
    }

    public Node getSource(Direction dir) {
        if (dir == Direction.FRONT) {
            return this.getSource();
        }
        return this.getTarget();
    }

    public Node getTarget(Direction dir) {
        if (dir == Direction.FRONT) {
            return this.getTarget();
        }
        return this.getSource();
    }

    @Override
    public Node getTarget() {
        return this.myTarget;
    }

    @Override
    public Node getOpposite(INode node) {
        if (node == this.mySource) {
            return this.myTarget;
        }
        if (node == this.myTarget) {
            return this.mySource;
        }
        throw new RuntimeException("node " + String.valueOf(node) + " is't adjacent to edge " + String.valueOf(this));
    }

    public List<Node> getAdjacentNodes() {
        return ListSequence.fromListAndArray(new ArrayList(), this.getSource(), this.getTarget());
    }

    void removeFromGraph() {
        ListSequence.fromList(this.mySource.getOutEdges()).removeElement(this);
        ListSequence.fromList(this.myTarget.getInEdges()).removeElement(this);
    }

    void addToGraph() {
        this.mySource.addOutEdge(this);
        this.myTarget.addInEdge(this);
    }

    public String toString() {
        return "[" + this.getSource().getIndex() + " -> " + this.getTarget().getIndex() + "]";
    }

    void revert() {
        this.removeFromGraph();
        Node temp = this.mySource;
        this.mySource = this.myTarget;
        this.myTarget = temp;
        this.addToGraph();
    }

    public static enum Direction {
        FRONT,
        BACK,
        BOTH;

    }
}

