/*
 * Decompiled with CFR 0.152.
 */
package com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph;

import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Edge;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Graph;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.GraphModificationEvent;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.IGraphModificationListener;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Node;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.IListSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ListSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.MapSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.backports.LinkedList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EdgesHistoryManager
implements IGraphModificationListener {
    private Map<Edge, List<Edge>> myHistory = MapSequence.fromMap(new HashMap());

    public EdgesHistoryManager(Graph graph) {
        graph.addListener(this);
    }

    @Override
    public void process(GraphModificationEvent event) {
        switch (event.getType()) {
            case EDGE_SPLITTED: {
                Edge edge = event.getEdge();
                List<Edge> history = event.getSplit();
                if (!this.checkConnection(edge.getSource(), (Edge)ListSequence.fromList(history).first())) {
                    history = ListSequence.fromList(history).reversedList();
                }
                MapSequence.fromMap(this.myHistory).put(event.getEdge(), history);
                break;
            }
            case EDGE_REVERTED: {
                List history = (List)MapSequence.fromMap(this.myHistory).get(event.getEdge());
                if (history == null) break;
                MapSequence.fromMap(this.myHistory).put(event.getEdge(), ListSequence.fromList(history).reversedList());
                break;
            }
        }
    }

    public Map<Edge, List<Edge>> getEntireHistory() {
        return this.myHistory;
    }

    public List<Edge> getHistory(Edge edge) {
        IListSequence<Edge> fullHistory = ListSequence.fromList(new LinkedList());
        List history = (List)MapSequence.fromMap(this.myHistory).get(edge);
        if (history == null) {
            ListSequence.fromList(fullHistory).addElement(edge);
        } else {
            Node cur = edge.getSource();
            for (Edge newEdge : history) {
                if (!this.checkConnection(cur, newEdge)) {
                    throw new RuntimeException("history is broken: edge " + String.valueOf(edge) + " history: " + String.valueOf(history));
                }
                List<Edge> newHistory = this.getHistory(newEdge);
                if (!this.checkConnection(cur, (Edge)ListSequence.fromList(newHistory).first())) {
                    newHistory = ListSequence.fromList(newHistory).reversedList();
                }
                ListSequence.fromList(fullHistory).addSequence(ListSequence.fromList(newHistory));
                cur = newEdge.getOpposite(cur);
            }
        }
        return fullHistory;
    }

    protected boolean checkConnection(Node node, Edge edge) {
        return ListSequence.fromList(edge.getAdjacentNodes()).contains(node);
    }
}

