/*
 * Decompiled with CFR 0.152.
 */
package com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph;

import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Edge;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.GraphModificationEvent;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.GraphModificationProcessor;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.IGraph;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.IGraphModificationListener;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.INode;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Node;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.IListSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ISequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ListSequence;
import java.util.ArrayList;
import java.util.List;

public class Graph
implements IGraph {
    private static int showInfo = 0;
    private GraphModificationProcessor myProcessor = new GraphModificationProcessor();
    private List<Node> myNodes = ListSequence.fromList(new ArrayList());
    private int myNextNum = 0;

    public List<Node> getNodes() {
        return this.myNodes;
    }

    public List<Edge> getEdges() {
        IListSequence<Edge> allEdges = ListSequence.fromList(new ArrayList());
        for (Node node : ListSequence.fromList(this.getNodes())) {
            ListSequence.fromList(allEdges).addSequence((ISequence)ListSequence.fromList(node.getOutEdges()));
        }
        return allEdges;
    }

    protected Node createNode(boolean isDummy) {
        Node node = new Node(this, this.myNextNum++, isDummy);
        ListSequence.fromList(this.myNodes).addElement(node);
        this.myProcessor.fire(new GraphModificationEvent(GraphModificationEvent.Type.NODE_CREATED, node));
        return node;
    }

    @Override
    public Node createNode() {
        return this.createNode(false);
    }

    public Node createDummyNode() {
        return this.createNode(true);
    }

    @Override
    public Edge connect(INode source, INode target) {
        Node sourceNode = (Node)source;
        Node targetNode = (Node)target;
        if (sourceNode.getGraph() != this || targetNode.getGraph() != this) {
            throw new RuntimeException("try to connect nodes of other graph");
        }
        Edge edge = sourceNode.addEdgeTo(targetNode);
        if (showInfo > 0) {
            System.out.println("graph: " + this.hashCode() + "added edge: " + String.valueOf(edge));
        }
        this.myProcessor.fire(new GraphModificationEvent(GraphModificationEvent.Type.EDGE_ADDED, edge));
        return edge;
    }

    public void addEdge(Edge edge) {
        edge.addToGraph();
        if (showInfo > 0) {
            System.out.println("graph: " + this.hashCode() + "restore edge: " + String.valueOf(edge));
        }
        this.myProcessor.fire(new GraphModificationEvent(GraphModificationEvent.Type.EDGE_ADDED, edge));
    }

    public Node getNode(int index) {
        return ListSequence.fromList(this.myNodes).getElement(index);
    }

    public int getNumNodes() {
        return ListSequence.fromList(this.myNodes).count();
    }

    public Edge addEdgeByIndex(int sourceIndex, int targetIndex) {
        return this.connect(this.getNode(sourceIndex), this.getNode(targetIndex));
    }

    public void deleteNode(Node node) {
        for (Edge edge : ListSequence.fromList(node.getEdges())) {
            edge.removeFromGraph();
            this.myProcessor.fire(new GraphModificationEvent(GraphModificationEvent.Type.EDGE_REMOVED, edge));
        }
        ListSequence.fromList(this.myNodes).removeElement(node);
        this.myProcessor.fire(new GraphModificationEvent(GraphModificationEvent.Type.NODE_DETETED, node));
    }

    public void removeEdge(Edge edge) {
        edge.removeFromGraph();
        this.myProcessor.fire(new GraphModificationEvent(GraphModificationEvent.Type.EDGE_REMOVED, edge));
    }

    public void revertEdge(Edge edge) {
        edge.revert();
        this.myProcessor.fire(new GraphModificationEvent(GraphModificationEvent.Type.EDGE_REVERTED, edge));
    }

    public List<Edge> splitEdge(Edge edge) {
        this.removeEdge(edge);
        IListSequence<Edge> newEdges = ListSequence.fromList(new ArrayList(2));
        Node middleNode = this.createDummyNode();
        ListSequence.fromList(newEdges).addElement(this.connect(edge.getSource(), middleNode));
        ListSequence.fromList(newEdges).addElement(this.connect(middleNode, edge.getTarget()));
        this.myProcessor.fire(new GraphModificationEvent(GraphModificationEvent.Type.EDGE_SPLITTED, edge, newEdges));
        return newEdges;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("Graph " + super.toString() + " with " + this.getNumNodes() + " nodes:\n");
        for (Node node : ListSequence.fromList(this.getNodes())) {
            result.append("node " + String.valueOf(node) + ": \n");
            result.append("  out edges:\n");
            for (Edge edge : ListSequence.fromList(node.getOutEdges())) {
                result.append(String.valueOf(edge) + ", ");
            }
            result.append("\n");
            result.append("  in edges:\n");
            for (Edge edge : ListSequence.fromList(node.getInEdges())) {
                result.append(String.valueOf(edge) + ", ");
            }
            result.append("\n");
        }
        result.append("end " + super.toString());
        return result.toString();
    }

    public void addListener(IGraphModificationListener listener) {
        this.myProcessor.addListener(listener);
    }

    public void removeListener(IGraphModificationListener listener) {
        this.myProcessor.removeListener(listener);
    }

    public GraphModificationProcessor getModificationProcessor() {
        return this.myProcessor;
    }

    public Graph createNew() {
        return new Graph();
    }
}

