/*
 * Decompiled with CFR 0.152.
 */
package com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph;

import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Edge;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Graph;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.IEdge;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.IGraph;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.INode;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Node;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graphLayout.GraphLayout;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graphLayout.GraphLayoutFactory;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.intGeom2D.Point;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.intGeom2D.Rectangle;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.util.DefaultFilter;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.util.Filter;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.MapSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.Sequence;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GraphCopier {
    private IGraph myGraph;
    private Graph myCopy;
    private Map<INode, Node> myNodeMap;
    private Map<IEdge, Edge> myEdgeMap;

    public GraphCopier(IGraph graph) {
        this.myGraph = graph;
        this.myCopy = graph instanceof Graph ? ((Graph)graph).createNew() : new Graph();
        this.myNodeMap = MapSequence.fromMap(new HashMap());
        this.myEdgeMap = MapSequence.fromMap(new HashMap());
    }

    public Node copyNode(INode node) {
        Node copyNode = this.myCopy.createNode();
        MapSequence.fromMap(this.myNodeMap).put(node, copyNode);
        return copyNode;
    }

    public Edge copyEdge(IEdge edge) {
        Node copySource = (Node)MapSequence.fromMap(this.myNodeMap).get(edge.getSource());
        Node copyTarget = (Node)MapSequence.fromMap(this.myNodeMap).get(edge.getTarget());
        Edge copyEdge = this.myCopy.connect(copySource, copyTarget);
        MapSequence.fromMap(this.myEdgeMap).put(edge, copyEdge);
        return copyEdge;
    }

    public Graph copy() {
        return this.copySubgraph(new DefaultFilter<INode>());
    }

    public Graph copySubgraph(Filter<INode> nodeFilter) {
        for (INode iNode : this.myGraph.getNodes()) {
            if (!nodeFilter.accept(iNode)) continue;
            this.copyNode(iNode);
        }
        for (IEdge iEdge : this.myGraph.getEdges()) {
            if (!this.acceptEdge(nodeFilter, iEdge)) continue;
            this.copyEdge(iEdge);
        }
        return this.myCopy;
    }

    private boolean acceptEdge(Filter<INode> nodeFilter, IEdge edge) {
        return nodeFilter.accept(edge.getSource()) && nodeFilter.accept(edge.getTarget());
    }

    public Graph getCopy() {
        return this.myCopy;
    }

    public Node getNodeCopy(INode node) {
        return (Node)MapSequence.fromMap(this.myNodeMap).get(node);
    }

    public Edge getEdgeCopy(IEdge edge) {
        return (Edge)MapSequence.fromMap(this.myEdgeMap).get(edge);
    }

    public Set<INode> getCopiedNodes() {
        return MapSequence.fromMap(this.myNodeMap).keySet();
    }

    public Set<IEdge> getCopiedEdges() {
        return MapSequence.fromMap(this.myEdgeMap).keySet();
    }

    public IGraph getCopiedGraph() {
        return this.myGraph;
    }

    public GraphLayout restoreLayout(GraphLayout copyLayout) {
        GraphLayout layout = GraphLayoutFactory.createGraphLayout(this.myGraph);
        for (INode iNode : Sequence.fromIterable(this.myGraph.getNodes())) {
            Rectangle rectangle = copyLayout.getNodeLayout(this.getNodeCopy(iNode));
            if (rectangle == null) continue;
            layout.setLayoutFor(iNode, rectangle);
        }
        for (IEdge iEdge : Sequence.fromIterable(this.myGraph.getEdges())) {
            Rectangle rect;
            Edge edgeCopy = this.getEdgeCopy(iEdge);
            Iterable route = copyLayout.getEdgeLayout(edgeCopy);
            if (route != null) {
                layout.setLayoutFor(iEdge, (List<Point>)route);
            }
            if ((rect = copyLayout.getLabelLayout(edgeCopy)) == null) continue;
            layout.setLabelLayout(iEdge, rect);
        }
        return layout;
    }
}

