/*
 * Decompiled with CFR 0.152.
 */
package com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph;

import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.GraphModificationEvent;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.IGraphModificationListener;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.SetSequence;
import java.util.HashSet;
import java.util.Set;

public class GraphModificationProcessor {
    private boolean myIsSuspended = false;
    private Set<IGraphModificationListener> myListeners = SetSequence.fromSet(new HashSet());

    public void fire(GraphModificationEvent event) {
        if (this.myIsSuspended) {
            return;
        }
        for (IGraphModificationListener listener : SetSequence.fromSet(this.myListeners)) {
            listener.process(event);
        }
    }

    public void suspend() {
        this.myIsSuspended = true;
    }

    public void resume() {
        this.myIsSuspended = false;
    }

    public void addListener(IGraphModificationListener listener) {
        SetSequence.fromSet(this.myListeners).addElement(listener);
    }

    public void removeListener(IGraphModificationListener listener) {
        if (!SetSequence.fromSet(this.myListeners).contains(listener)) {
            throw new RuntimeException("removing listener from wrong place");
        }
        SetSequence.fromSet(this.myListeners).removeElement(listener);
    }
}

