/*
 * Decompiled with CFR 0.152.
 */
package com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph;

import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Edge;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Graph;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.GraphModificationEvent;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.IGraphModificationListener;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Node;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.IListSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ListSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.MapSequence;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GroupedGraphModificationSynchronizer
implements IGraphModificationListener {
    private static int showInfo = 0;
    private Map<Edge, Edge> myEdgeMap;
    private Map<Node, Node> myNodeMap;
    private Graph myGroupedGraph;
    private Graph mySynchronizedGraph;

    public GroupedGraphModificationSynchronizer(Graph groupedGraph, Graph synchronizedGraph, Map<Edge, Edge> edgeMap) {
        this.myGroupedGraph = groupedGraph;
        this.mySynchronizedGraph = synchronizedGraph;
        groupedGraph.addListener(this);
        this.myEdgeMap = edgeMap;
        this.myNodeMap = MapSequence.fromMap(new HashMap());
    }

    @Override
    public void process(GraphModificationEvent event) {
        switch (event.getType()) {
            case NODE_CREATED: {
                Node addedNode = event.getNode();
                Node syncNode = addedNode.isDummy() ? this.mySynchronizedGraph.createDummyNode() : this.mySynchronizedGraph.createNode();
                MapSequence.fromMap(this.myNodeMap).put(addedNode, syncNode);
                break;
            }
            case NODE_DETETED: {
                Node deletedNode = event.getNode();
                if (!MapSequence.fromMap(this.myNodeMap).containsKey(deletedNode)) break;
                this.mySynchronizedGraph.deleteNode((Node)MapSequence.fromMap(this.myNodeMap).get(deletedNode));
                break;
            }
            case EDGE_ADDED: {
                Edge addedEdge = event.getEdge();
                Node source = addedEdge.getSource();
                Node target = addedEdge.getTarget();
                if (MapSequence.fromMap(this.myEdgeMap).containsKey(addedEdge)) {
                    this.mySynchronizedGraph.addEdge((Edge)MapSequence.fromMap(this.myEdgeMap).get(addedEdge));
                    break;
                }
                if (!MapSequence.fromMap(this.myNodeMap).containsKey(source) || !MapSequence.fromMap(this.myNodeMap).containsKey(target)) break;
                Node syncSource = (Node)MapSequence.fromMap(this.myNodeMap).get(source);
                Node syncTarget = (Node)MapSequence.fromMap(this.myNodeMap).get(target);
                Edge edge = this.mySynchronizedGraph.connect(syncSource, syncTarget);
                MapSequence.fromMap(this.myEdgeMap).put(addedEdge, edge);
                if (showInfo <= 0) break;
                System.out.println("added " + String.valueOf(addedEdge) + " sync = " + String.valueOf(edge));
                break;
            }
            case EDGE_REMOVED: {
                Edge removedEdge = event.getEdge();
                if (showInfo > 0) {
                    System.out.println("removed " + String.valueOf(removedEdge) + " sync = ");
                }
                if (!MapSequence.fromMap(this.myEdgeMap).containsKey(removedEdge)) break;
                this.mySynchronizedGraph.removeEdge((Edge)MapSequence.fromMap(this.myEdgeMap).get(removedEdge));
                if (showInfo <= 0) break;
                System.out.println(MapSequence.fromMap(this.myEdgeMap).get(removedEdge));
                break;
            }
            case EDGE_REVERTED: {
                Edge revertedEdge = event.getEdge();
                if (!MapSequence.fromMap(this.myEdgeMap).containsKey(revertedEdge)) break;
                this.mySynchronizedGraph.revertEdge((Edge)MapSequence.fromMap(this.myEdgeMap).get(revertedEdge));
                break;
            }
            case EDGE_SPLITTED: {
                this.processSplitEvent(event);
                break;
            }
        }
    }

    private void processSplitEvent(GraphModificationEvent event) {
        Edge splittedEdge = event.getEdge();
        if (MapSequence.fromMap(this.myEdgeMap).containsKey(splittedEdge)) {
            Edge syncEdge = (Edge)MapSequence.fromMap(this.myEdgeMap).get(splittedEdge);
            List<Edge> split = event.getSplit();
            IListSequence<Edge> syncSplit = ListSequence.fromList(new ArrayList(ListSequence.fromList(split).count()));
            for (Edge splitEdge : ListSequence.fromList(split)) {
                if (MapSequence.fromMap(this.myEdgeMap).containsKey(splitEdge)) {
                    ListSequence.fromList(syncSplit).addElement((Edge)MapSequence.fromMap(this.myEdgeMap).get(splitEdge));
                    continue;
                }
                Node source = splitEdge.getSource();
                Node syncSource = MapSequence.fromMap(this.myNodeMap).containsKey(source) ? (Node)MapSequence.fromMap(this.myNodeMap).get(source) : syncEdge.getSource();
                Node target = splitEdge.getTarget();
                Node syncTarget = MapSequence.fromMap(this.myNodeMap).containsKey(target) ? (Node)MapSequence.fromMap(this.myNodeMap).get(target) : syncEdge.getTarget();
                Edge syncSplitEdge = this.mySynchronizedGraph.connect(syncSource, syncTarget);
                MapSequence.fromMap(this.myEdgeMap).put(splitEdge, syncSplitEdge);
                ListSequence.fromList(syncSplit).addElement(syncSplitEdge);
            }
            if (showInfo > 0) {
                System.out.println("splitted " + String.valueOf(splittedEdge) + " sync = " + String.valueOf(syncEdge));
            }
            this.mySynchronizedGraph.getModificationProcessor().fire(new GraphModificationEvent(GraphModificationEvent.Type.EDGE_SPLITTED, syncEdge, syncSplit));
        }
    }

    public void disconnect() {
        this.myGroupedGraph.removeListener(this);
    }
}

