/*
 * Decompiled with CFR 0.152.
 */
package com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph;

import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Edge;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Graph;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.INode;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ListSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.backports.LinkedList;
import java.util.List;

public class Node
implements INode {
    private List<Edge> myOutEdges;
    private List<Edge> myInEdges;
    private boolean myIsDummy;
    private int myIndex;
    private Graph myGraph;

    Node(Graph graph, int index, boolean isDummy) {
        this.myGraph = graph;
        this.myOutEdges = ListSequence.fromList(new LinkedList());
        this.myInEdges = ListSequence.fromList(new LinkedList());
        this.myIndex = index;
        this.myIsDummy = isDummy;
    }

    Edge addEdgeTo(Node target) {
        Edge edge = new Edge(this, target);
        this.addOutEdge(edge);
        if (target != this) {
            target.addInEdge(edge);
        }
        return edge;
    }

    public List<Edge> getOutEdges() {
        return this.myOutEdges;
    }

    public List<Edge> getInEdges() {
        return this.myInEdges;
    }

    public List<Edge> getEdges() {
        return this.getEdges(Edge.Direction.BOTH);
    }

    public List<Edge> getEdges(Edge.Direction dir) {
        if (dir == Edge.Direction.FRONT) {
            return this.getOutEdges();
        }
        if (dir == Edge.Direction.BOTH) {
            return ListSequence.fromList(this.getOutEdges()).concat(ListSequence.fromList(this.getInEdges())).toListSequence();
        }
        return this.getInEdges();
    }

    void addOutEdge(Edge edge) {
        ListSequence.fromList(this.myOutEdges).addElement(edge);
    }

    void addInEdge(Edge edge) {
        ListSequence.fromList(this.myInEdges).addElement(edge);
    }

    public int getIndex() {
        return this.myIndex;
    }

    public boolean isDummy() {
        return this.myIsDummy;
    }

    public Graph getGraph() {
        return this.myGraph;
    }

    public String toString() {
        return Integer.toString(this.myIndex);
    }
}

