/*
 * Decompiled with CFR 0.152.
 */
package com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graphLayout;

import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.algorithms.ConnectivityComponents;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Graph;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.IEdge;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.INode;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Node;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graphLayout.GraphLayout;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graphLayout.GraphLayoutFactory;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graphLayout.ILayoutInfo;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graphLayout.ILayouter;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graphLayout.LayoutInfo;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graphLayout.LayoutInfoCopier;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.intGeom2D.Dimension;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.intGeom2D.Point;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.intGeom2D.Rectangle;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.util.Filter;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.IListSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ListSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.MapSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.SetSequence;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class BasicLayouter
implements ILayouter {
    private static final int DEFAULT_UNIT_LENGTH = 30;
    private int myUnitLength = 30;

    @Override
    public GraphLayout doLayout(ILayoutInfo layoutInfo) {
        LayoutInfoCopier patchCopier = new LayoutInfoCopier(layoutInfo);
        LayoutInfo patchInfo = patchCopier.copy();
        GraphLayout graphLayout = this.doLayoutCopy(patchInfo);
        GraphLayout initialLayout = patchCopier.restoreLayout(graphLayout);
        return initialLayout;
    }

    protected GraphLayout doLayoutCopy(LayoutInfo patchInfo) {
        Graph graph = patchInfo.getGraph();
        final Map<Node, Integer> components = ConnectivityComponents.getComponents(graph);
        int numComponents = 0;
        for (Node node : ListSequence.fromList(graph.getNodes())) {
            numComponents = Math.max(numComponents, (Integer)MapSequence.fromMap(components).get(node));
        }
        IListSequence copiers = ListSequence.fromList(new ArrayList(++numComponents));
        IListSequence subgraphLayouts = ListSequence.fromList(new ArrayList(numComponents));
        int num = 0;
        while (num < numComponents) {
            LayoutInfoCopier copier = new LayoutInfoCopier(patchInfo);
            ListSequence.fromList(copiers).addElement(copier);
            final int curComponent = num++;
            copier.copySubgraph(new Filter<INode>(){

                @Override
                public boolean accept(INode node) {
                    Node myNode = (Node)node;
                    return (Integer)MapSequence.fromMap(components).get(myNode) == curComponent;
                }
            });
            LayoutInfo subgraphInfo = copier.getLayoutInfoCopy();
            ListSequence.fromList(subgraphLayouts).addElement(this.doLayoutConnectedGraph(subgraphInfo));
        }
        IListSequence<Rectangle> subgraphLayoutRects = ListSequence.fromList(new ArrayList(numComponents));
        for (GraphLayout layout : ListSequence.fromList(subgraphLayouts)) {
            ListSequence.fromList(subgraphLayoutRects).addElement(layout.getContainingRectangle());
        }
        List<Dimension> subgraphLayoutShifts = this.getSubgraphLayoutShifts(subgraphLayoutRects);
        GraphLayout graphLayout = GraphLayoutFactory.createGraphLayout(graph);
        for (int num2 = 0; num2 < numComponents; ++num2) {
            LayoutInfoCopier copier = (LayoutInfoCopier)ListSequence.fromList(copiers).getElement(num2);
            GraphLayout layout = (GraphLayout)ListSequence.fromList(subgraphLayouts).getElement(num2);
            Dimension shift = ListSequence.fromList(subgraphLayoutShifts).getElement(num2);
            for (INode node : SetSequence.fromSet(copier.getCopiedNodes())) {
                Rectangle rect = layout.getNodeLayout(copier.getNodeCopy(node));
                rect.translate(shift.width, shift.height);
                graphLayout.setLayoutFor(node, rect);
            }
            for (IEdge edge : SetSequence.fromSet(copier.getCopiedEdges())) {
                Iterable path = layout.getEdgeLayout(copier.getEdgeCopy(edge));
                for (Point point : ListSequence.fromList(path)) {
                    point.translate(shift.width, shift.height);
                }
                graphLayout.setLayoutFor(edge, (List<Point>)path);
                if (!SetSequence.fromSet(patchInfo.getLabeledEdges()).contains(edge)) continue;
                Rectangle rect = layout.getLabelLayout(copier.getEdgeCopy(edge));
                rect.translate(shift.width, shift.height);
                graphLayout.setLabelLayout(edge, rect);
            }
        }
        return graphLayout;
    }

    public abstract GraphLayout doLayoutConnectedGraph(LayoutInfo var1);

    protected List<Dimension> getSubgraphLayoutShifts(List<Rectangle> subgraphLayoutRects) {
        IListSequence<Dimension> subgraphLayoutShifts = ListSequence.fromList(new ArrayList(ListSequence.fromList(subgraphLayoutRects).count()));
        int shiftX = 0;
        for (Rectangle layoutRect : ListSequence.fromList(subgraphLayoutRects)) {
            ListSequence.fromList(subgraphLayoutShifts).addElement(new Dimension(shiftX, 0));
            shiftX += layoutRect.width + this.getUnitLength();
        }
        return subgraphLayoutShifts;
    }

    public int getUnitLength() {
        return this.myUnitLength;
    }

    public void setUnitLength(int unitLength) {
        this.myUnitLength = unitLength;
    }
}

