/*
 * Decompiled with CFR 0.152.
 */
package com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graphLayout;

import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.ClusteredGraph;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Node;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graphLayout.GraphLayout;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.intGeom2D.GeomUtil;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.intGeom2D.Point;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.intGeom2D.Rectangle;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ListSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.MapSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.SetSequence;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ClusteredGraphLayout
extends GraphLayout {
    private Map<Node, List<Point>> myClusterLayout = MapSequence.fromMap(new HashMap());

    public ClusteredGraphLayout(ClusteredGraph graph) {
        super(graph);
    }

    public void setClusterLayout(Node cluster, List<Point> borderLayout) {
        MapSequence.fromMap(this.myClusterLayout).put(cluster, borderLayout);
    }

    public List<Point> getClusterLayout(Node cluster) {
        return (List)MapSequence.fromMap(this.myClusterLayout).get(cluster);
    }

    public Set<Node> getLayoutedClusters() {
        return MapSequence.fromMap(this.myClusterLayout).keySet();
    }

    @Override
    public ClusteredGraphLayout shift(int xShift, int yShift) {
        ClusteredGraphLayout graphLayout = (ClusteredGraphLayout)super.shift(xShift, yShift);
        for (Node cluster : SetSequence.fromSet(this.getLayoutedClusters())) {
            List<Point> clusterLayout = this.getClusterLayout(cluster);
            graphLayout.setClusterLayout(cluster, GeomUtil.shiftPolyline(clusterLayout, xShift, yShift));
        }
        return graphLayout;
    }

    @Override
    public Rectangle getContainingRectangle() {
        Rectangle rect = super.getContainingRectangle();
        int minX = rect.x;
        int minY = rect.y;
        int maxX = rect.maxX();
        int maxY = rect.maxY();
        for (Node cluster : SetSequence.fromSet(this.getLayoutedClusters())) {
            for (Point p : ListSequence.fromList(this.getClusterLayout(cluster))) {
                minX = Math.min(minX, p.x);
                maxX = Math.max(maxX, p.x);
                minY = Math.min(minY, p.y);
                maxY = Math.max(maxY, p.y);
            }
        }
        return new Rectangle(minX, minY, maxX - minX, maxY - minY);
    }
}

