/*
 * Decompiled with CFR 0.152.
 */
package com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graphLayout;

import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.IEdge;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.IGraph;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.INode;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graphLayout.GraphLayoutFactory;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graphLayout.IGraphLayout;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.intGeom2D.GeomUtil;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.intGeom2D.OrthogonalUtil;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.intGeom2D.Point;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.intGeom2D.Rectangle;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ListSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.MapSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.Sequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.SetSequence;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GraphLayout
implements IGraphLayout {
    private IGraph myGraph;
    private Map<INode, Rectangle> myNodeLayout;
    private Map<IEdge, List<Point>> myEdgeLayout;
    private Map<IEdge, Rectangle> myLabelLayout;

    public GraphLayout(IGraph graph) {
        this.myGraph = graph;
        this.myNodeLayout = MapSequence.fromMap(new HashMap());
        this.myEdgeLayout = MapSequence.fromMap(new HashMap());
        this.myLabelLayout = MapSequence.fromMap(new HashMap());
    }

    public Map<INode, Rectangle> getNodeLayout() {
        return this.myNodeLayout;
    }

    @Override
    public Set<? extends INode> getLayoutedNodes() {
        return MapSequence.fromMap(this.myNodeLayout).keySet();
    }

    @Override
    public Set<? extends IEdge> getLayoutedEdges() {
        return MapSequence.fromMap(this.myEdgeLayout).keySet();
    }

    @Override
    public Set<? extends IEdge> getLayoutedLabels() {
        return MapSequence.fromMap(this.myLabelLayout).keySet();
    }

    public void setNodeLayout(Map<INode, Rectangle> nodeLayout) {
        this.myNodeLayout = nodeLayout;
    }

    public Map<IEdge, List<Point>> getEdgeLayout() {
        return this.myEdgeLayout;
    }

    public void setEdgeLayout(Map<IEdge, List<Point>> edgeLayout) {
        this.myEdgeLayout = edgeLayout;
    }

    public void setLayoutFor(INode node, Rectangle rect) {
        MapSequence.fromMap(this.myNodeLayout).put(node, rect);
    }

    @Override
    public Rectangle getNodeLayout(INode node) {
        return (Rectangle)MapSequence.fromMap(this.myNodeLayout).get(node);
    }

    public void setLayoutFor(IEdge edge, List<Point> points) {
        MapSequence.fromMap(this.myEdgeLayout).put(edge, points);
    }

    public List<Point> getEdgeLayout(IEdge edge) {
        return (List)MapSequence.fromMap(this.myEdgeLayout).get(edge);
    }

    public void setLabelLayout(IEdge edge, Rectangle rectangle) {
        MapSequence.fromMap(this.myLabelLayout).put(edge, rectangle);
    }

    @Override
    public Rectangle getLabelLayout(IEdge edge) {
        return (Rectangle)MapSequence.fromMap(this.myLabelLayout).get(edge);
    }

    public Map<IEdge, Rectangle> getLabelLayout() {
        return this.myLabelLayout;
    }

    @Override
    public IGraph getGraph() {
        return this.myGraph;
    }

    public void refineEdgeLayout() {
        for (IEdge edge : SetSequence.fromSet(MapSequence.fromMap(this.myEdgeLayout).keySet())) {
            this.shiftEdgeLayoutAlongEndsBorder(edge);
        }
        for (IEdge edge : SetSequence.fromSet(MapSequence.fromMap(this.myEdgeLayout).keySet())) {
            this.removeStraightBends(edge);
        }
    }

    public void removeStraightBends(IEdge edge) {
        List path = (List)MapSequence.fromMap(this.myEdgeLayout).get(edge);
        boolean ver = ((Point)ListSequence.fromList(path).getElement((int)0)).x == ((Point)ListSequence.fromList(path).getElement((int)1)).x;
        int i = 2;
        while (i < ListSequence.fromList(path).count()) {
            boolean curVer;
            boolean bl = curVer = ((Point)ListSequence.fromList(path).getElement((int)(i - 1))).x == ((Point)ListSequence.fromList(path).getElement((int)i)).x;
            if (curVer == ver) {
                ListSequence.fromList(path).removeElementAt(i - 1);
                continue;
            }
            ++i;
            ver = curVer;
        }
    }

    public void shiftEdgeLayoutAlongEndsBorder(IEdge edge) {
        List path;
        Rectangle rect = (Rectangle)MapSequence.fromMap(this.myNodeLayout).get(edge.getSource());
        Point p = OrthogonalUtil.moveToBorder(rect, (Point)ListSequence.fromList(path = (List)MapSequence.fromMap(this.myEdgeLayout).get(edge)).getElement(0), (Point)ListSequence.fromList(path).getElement(1));
        if (p != null) {
            ListSequence.fromList(path).setElement(0, p);
        }
        if ((p = OrthogonalUtil.moveToBorder(rect = (Rectangle)MapSequence.fromMap(this.myNodeLayout).get(edge.getTarget()), (Point)ListSequence.fromList(path).getElement(ListSequence.fromList(path).count() - 1), (Point)ListSequence.fromList(path).getElement(ListSequence.fromList(path).count() - 2))) != null) {
            ListSequence.fromList(path).setElement(ListSequence.fromList(path).count() - 1, p);
        }
    }

    @Override
    public Rectangle getContainingRectangle() {
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        for (Rectangle rect : Sequence.fromIterable(MapSequence.fromMap(this.myNodeLayout).values()).concat(Sequence.fromIterable(MapSequence.fromMap(this.myLabelLayout).values()))) {
            minX = Math.min(minX, rect.x);
            minY = Math.min(minY, rect.y);
            maxX = Math.max(maxX, rect.x + rect.width);
            maxY = Math.max(maxY, rect.x + rect.height);
        }
        for (List path : Sequence.fromIterable(MapSequence.fromMap(this.myEdgeLayout).values())) {
            for (Point p : ListSequence.fromList(path)) {
                minX = Math.min(minX, p.x);
                minY = Math.min(minY, p.y);
                maxX = Math.max(maxX, p.x);
                maxY = Math.max(maxY, p.y);
            }
        }
        return new Rectangle(minX, minY, maxX - minX, maxY - minY);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Layout: \n");
        for (INode node : SetSequence.fromSet(MapSequence.fromMap(this.myNodeLayout).keySet())) {
            builder.append("  for node: " + String.valueOf(node) + ": " + String.valueOf(MapSequence.fromMap(this.myNodeLayout).get(node)) + "\n");
        }
        for (IEdge edge : SetSequence.fromSet(MapSequence.fromMap(this.myEdgeLayout).keySet())) {
            builder.append("  for edge: " + String.valueOf(edge) + ": " + String.valueOf(MapSequence.fromMap(this.myEdgeLayout).get(edge)) + "\n");
        }
        return builder.toString();
    }

    public GraphLayout shift(int xShift, int yShift) {
        int newY;
        Rectangle rect;
        GraphLayout newLayout = GraphLayoutFactory.createGraphLayout(this.getGraph());
        for (INode iNode : SetSequence.fromSet(this.getLayoutedNodes())) {
            rect = this.getNodeLayout(iNode);
            int newX = rect.x + xShift;
            newY = rect.y + yShift;
            newLayout.setLayoutFor(iNode, new Rectangle(newX, newY, rect.width, rect.height));
        }
        for (IEdge iEdge : SetSequence.fromSet(this.getLayoutedEdges())) {
            Iterable edgeLayout = this.getEdgeLayout(iEdge);
            List<Point> newList = GeomUtil.shiftPolyline((List<Point>)edgeLayout, xShift, yShift);
            newLayout.setLayoutFor(iEdge, newList);
        }
        for (IEdge iEdge : SetSequence.fromSet(this.getLayoutedLabels())) {
            rect = this.getLabelLayout(iEdge);
            int newX = rect.x + xShift;
            newY = rect.y + yShift;
            newLayout.setLabelLayout(iEdge, new Rectangle(newX, newY, rect.width, rect.height));
        }
        return newLayout;
    }
}

