/*
 * Decompiled with CFR 0.152.
 */
package com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graphLayout;

import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.ClusteredGraph;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Edge;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.HyperGraph;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.IEdge;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.IGraph;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.INode;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Node;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Tree;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graphLayout.BasicLayouter;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graphLayout.ClusteredGraphLayout;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graphLayout.GraphLayout;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graphLayout.IGraphLayout;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graphLayout.ILayoutInfo;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graphLayout.ILayouter;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graphLayout.LayoutInfo;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.intGeom2D.Dimension;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.intGeom2D.GeomUtil;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.intGeom2D.OrthogonalUtil;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.intGeom2D.Point;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.intGeom2D.Rectangle;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.IListSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ListSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.MapSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.SetSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.backports.LinkedList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HyperGraphLayouter
extends BasicLayouter {
    private ILayouter myClusterLayouter;
    private Map<Node, Node> myClusterMap;
    private Map<Node, Node> myNodeMap;
    private Map<Edge, Edge> myEdgeMap;
    private ClusteredGraph myClusteredGraph;
    private Tree myInclusionTree;
    private HyperGraph myGraph;

    public HyperGraphLayouter(ILayouter clusterLayouter) {
        this.myClusterLayouter = clusterLayouter;
        this.myClusterMap = MapSequence.fromMap(new HashMap());
        this.myNodeMap = MapSequence.fromMap(new HashMap());
        this.myEdgeMap = MapSequence.fromMap(new HashMap());
    }

    @Override
    public GraphLayout doLayout(ILayoutInfo layoutInfo) {
        IGraph graph = layoutInfo.getGraph();
        if (!(graph instanceof HyperGraph)) {
            throw new RuntimeException("can layout only hyper graphs");
        }
        this.myGraph = (HyperGraph)graph;
        this.myClusteredGraph = new ClusteredGraph();
        this.myInclusionTree = this.myClusteredGraph.getInclusionTree();
        Node root = this.myGraph.getRoot();
        this.makeClusterGraph(root);
        this.myClusteredGraph.setRoot((Node)MapSequence.fromMap(this.myClusterMap).get(root));
        this.copyEdges();
        LayoutInfo clusterInfo = this.createClusterInfo(layoutInfo);
        IGraphLayout ilayout = this.myClusterLayouter.doLayout(clusterInfo);
        if (!(ilayout instanceof ClusteredGraphLayout)) {
            throw new RuntimeException("internal layout must be able to process clustered graphs");
        }
        ClusteredGraphLayout layout = (ClusteredGraphLayout)ilayout;
        return this.restoreLayout(layout);
    }

    @Override
    public GraphLayout doLayoutConnectedGraph(LayoutInfo layoutInfo) {
        return null;
    }

    private GraphLayout restoreLayout(ClusteredGraphLayout layout) {
        GraphLayout graphLayout = new GraphLayout(this.myGraph);
        for (Node node : ListSequence.fromList(this.myGraph.getNodes())) {
            Node leafNode = (Node)MapSequence.fromMap(this.myNodeMap).get(node);
            if (leafNode != null) {
                graphLayout.setLayoutFor(node, layout.getNodeLayout(leafNode));
                continue;
            }
            Node cluster = (Node)MapSequence.fromMap(this.myClusterMap).get(node);
            List<Point> clusterLayout = layout.getClusterLayout(cluster);
            graphLayout.setLayoutFor(node, GeomUtil.getContainingRectangle(clusterLayout));
        }
        for (Edge edge : ListSequence.fromList(this.myGraph.getEdges())) {
            List<Point> route = layout.getEdgeLayout((IEdge)MapSequence.fromMap(this.myEdgeMap).get(edge));
            Node source = edge.getSource();
            if (!MapSequence.fromMap(this.myNodeMap).containsKey(source)) {
                Rectangle rect = graphLayout.getNodeLayout(source);
                route = this.cutRouteToBorder(route, rect);
            }
            Node target = edge.getTarget();
            if (!MapSequence.fromMap(this.myNodeMap).containsKey(target)) {
                Rectangle rect = graphLayout.getNodeLayout(target);
                route = ListSequence.fromList(this.cutRouteToBorder(ListSequence.fromList(route).reversedList(), rect)).reversedList();
            }
            graphLayout.setLayoutFor(edge, route);
            Rectangle labelRect = layout.getLabelLayout((IEdge)MapSequence.fromMap(this.myEdgeMap).get(edge));
            if (labelRect == null) continue;
            graphLayout.setLabelLayout(edge, labelRect);
        }
        return graphLayout;
    }

    private List<Point> cutRouteToBorder(List<Point> route, Rectangle border) {
        Point[] cornerPoints = border.getCornerPoints();
        boolean foundOnBorder = false;
        Point p = null;
        IListSequence<Point> newRoute = ListSequence.fromList(new LinkedList());
        for (Point q : ListSequence.fromList(route)) {
            if (foundOnBorder) {
                ListSequence.fromList(newRoute).addElement(q);
                continue;
            }
            if (p == null || p.equals(q)) {
                p = q;
                continue;
            }
            Point bp = cornerPoints[3];
            for (Point bq : cornerPoints) {
                Point res = OrthogonalUtil.intersects(p, q, bp, bq);
                if (res != null) {
                    ListSequence.fromList(newRoute).addElement(res);
                    if (!res.equals(q)) {
                        ListSequence.fromList(newRoute).addElement(q);
                    }
                    foundOnBorder = true;
                    break;
                }
                bp = bq;
            }
            p = q;
        }
        return newRoute;
    }

    private LayoutInfo createClusterInfo(ILayoutInfo layoutInfo) {
        Dimension size;
        LayoutInfo clusterInfo = new LayoutInfo(this.myClusteredGraph);
        for (Node node : ListSequence.fromList(this.myGraph.getNodes())) {
            Node leafNode = (Node)MapSequence.fromMap(this.myNodeMap).get(node);
            size = layoutInfo.getNodeSize(node);
            if (leafNode == null || size == null) continue;
            clusterInfo.setNodeSize(leafNode, new Dimension(size));
        }
        for (Edge edge : ListSequence.fromList(this.myGraph.getEdges())) {
            Edge clusterEdge = (Edge)MapSequence.fromMap(this.myEdgeMap).get(edge);
            size = layoutInfo.getLabelSize(edge);
            if (size == null) continue;
            clusterInfo.setLabelSize(clusterEdge, new Dimension(size));
        }
        return clusterInfo;
    }

    private void copyEdges() {
        for (Edge edge : ListSequence.fromList(this.myGraph.getEdges())) {
            Node source = (Node)SetSequence.fromSet(this.myClusteredGraph.getNodesInCluster((INode)MapSequence.fromMap(this.myClusterMap).get(edge.getSource()))).first();
            Node target = (Node)SetSequence.fromSet(this.myClusteredGraph.getNodesInCluster((INode)MapSequence.fromMap(this.myClusterMap).get(edge.getTarget()))).first();
            MapSequence.fromMap(this.myEdgeMap).put(edge, this.myClusteredGraph.connect(source, target));
        }
    }

    private void makeClusterGraph(Node node) {
        Node cluster = this.myInclusionTree.createNode();
        MapSequence.fromMap(this.myClusterMap).put(node, cluster);
        List<Node> children = this.myGraph.getChildren(node);
        for (Node child : ListSequence.fromList(children)) {
            this.makeClusterGraph(child);
            this.myInclusionTree.connect(cluster, (INode)MapSequence.fromMap(this.myClusterMap).get(child));
        }
        if (ListSequence.fromList(children).count() == 0) {
            Node leafNode = this.myClusteredGraph.createNode();
            MapSequence.fromMap(this.myNodeMap).put(node, leafNode);
            this.myClusteredGraph.setNodeInCluster(cluster, leafNode);
        }
    }
}

