/*
 * Decompiled with CFR 0.152.
 */
package com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graphLayout;

import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Edge;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Graph;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.IEdge;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.INode;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Node;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graphLayout.ILayoutInfo;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.intGeom2D.Dimension;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.MapSequence;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class LayoutInfo
implements ILayoutInfo {
    private Graph myGraph;
    private Map<Node, Dimension> myNodeSizes;
    private Map<Edge, Dimension> myLabelSizes;

    public LayoutInfo(Graph graph) {
        this.myGraph = graph;
        this.myNodeSizes = MapSequence.fromMap(new LinkedHashMap(16, 0.75f, false));
        this.myLabelSizes = MapSequence.fromMap(new LinkedHashMap(16, 0.75f, false));
    }

    @Override
    public void setNodeSize(INode node, Dimension size) {
        Node myNode = (Node)node;
        MapSequence.fromMap(this.myNodeSizes).put(myNode, size);
    }

    @Override
    public void setLabelSize(IEdge labeledEdge, Dimension size) {
        Edge myLabeledEdge = (Edge)labeledEdge;
        MapSequence.fromMap(this.myLabelSizes).put(myLabeledEdge, size);
    }

    @Override
    public Dimension getNodeSize(INode node) {
        Node myNode = (Node)node;
        return (Dimension)MapSequence.fromMap(this.myNodeSizes).get(myNode);
    }

    @Override
    public Dimension getLabelSize(IEdge edge) {
        Edge myEdge = (Edge)edge;
        return (Dimension)MapSequence.fromMap(this.myLabelSizes).get(myEdge);
    }

    @Override
    public Graph getGraph() {
        return this.myGraph;
    }

    public Set<Edge> getLabeledEdges() {
        return MapSequence.fromMap(this.myLabelSizes).keySet();
    }

    public Set<Node> getNodesWithSize() {
        return MapSequence.fromMap(this.myNodeSizes).keySet();
    }
}

