/*
 * Decompiled with CFR 0.152.
 */
package com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graphLayout;

import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Edge;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Graph;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.GraphCopier;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.GraphCopierFactory;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.IEdge;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.INode;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Node;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graphLayout.GraphLayout;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graphLayout.ILayoutInfo;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graphLayout.LayoutInfo;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.intGeom2D.Dimension;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.util.DefaultFilter;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.util.Filter;
import java.util.Set;

public class LayoutInfoCopier {
    private ILayoutInfo myLayoutInfo;
    private LayoutInfo myInfoCopy;
    private GraphCopier myCopier;

    public LayoutInfoCopier(ILayoutInfo layoutInfo) {
        this.myCopier = GraphCopierFactory.getCopier(layoutInfo.getGraph());
        this.myLayoutInfo = layoutInfo;
        this.myInfoCopy = new LayoutInfo(this.myCopier.getCopy());
    }

    public LayoutInfo copy() {
        return this.copySubgraph(new DefaultFilter<INode>());
    }

    public LayoutInfo copySubgraph(Filter<INode> nodeFilter) {
        this.myCopier.copySubgraph(nodeFilter);
        for (INode iNode : this.myLayoutInfo.getNodesWithSize()) {
            if (!nodeFilter.accept(iNode)) continue;
            Node copyNode = this.myCopier.getNodeCopy(iNode);
            this.myInfoCopy.setNodeSize(copyNode, this.myLayoutInfo.getNodeSize(iNode));
        }
        for (IEdge iEdge : this.myLayoutInfo.getLabeledEdges()) {
            Edge copyEdge = this.myCopier.getEdgeCopy(iEdge);
            Dimension edgeSize = this.myLayoutInfo.getLabelSize(iEdge);
            if (copyEdge == null || edgeSize == null) continue;
            this.myInfoCopy.setLabelSize(copyEdge, edgeSize);
        }
        return this.myInfoCopy;
    }

    public LayoutInfo getLayoutInfoCopy() {
        return this.myInfoCopy;
    }

    public Graph getGraphCopy() {
        return this.myInfoCopy.getGraph();
    }

    public Node getNodeCopy(INode node) {
        return this.myCopier.getNodeCopy(node);
    }

    public Edge getEdgeCopy(IEdge edge) {
        return this.myCopier.getEdgeCopy(edge);
    }

    public Set<INode> getCopiedNodes() {
        return this.myCopier.getCopiedNodes();
    }

    public Set<IEdge> getCopiedEdges() {
        return this.myCopier.getCopiedEdges();
    }

    public GraphCopier getGraphCopier() {
        return this.myCopier;
    }

    public GraphLayout restoreLayout(GraphLayout copyLayout) {
        return this.myCopier.restoreLayout(copyLayout);
    }
}

