/*
 * Decompiled with CFR 0.152.
 */
package com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.intGeom2D;

public enum Direction2D {
    RIGHT(1, 0),
    DOWN(0, -1),
    LEFT(-1, 0),
    UP(0, 1);

    private int myDx;
    private int myDy;

    private Direction2D(int dx, int dy) {
        this.myDx = dx;
        this.myDy = dy;
    }

    public Direction2D turnClockwise(int angle) {
        int dir = this.ordinal() + angle;
        if (dir > 3) {
            dir -= 4;
        }
        return Direction2D.get(dir);
    }

    public Direction2D opposite() {
        return this.turnClockwise(2);
    }

    public int getTurn(Direction2D dir) {
        int turn = dir.ordinal() - this.ordinal();
        if (turn == 2) {
            return -2;
        }
        if (turn == 3) {
            return -1;
        }
        if (turn == -3) {
            return 1;
        }
        return turn;
    }

    public int getClockwiseTurn(Direction2D dir) {
        int turn = dir.ordinal() - this.ordinal();
        if (turn < 0) {
            turn += 4;
        }
        return turn;
    }

    public boolean isHorizontal() {
        return this.myDx != 0;
    }

    public boolean isVertical() {
        return this.myDy != 0;
    }

    public int dx() {
        return this.myDx;
    }

    public int dy() {
        return this.myDy;
    }

    public static Direction2D get(int intDirection) {
        return Direction2D.values()[intDirection];
    }

    public static Direction2D getByShifts(int dx, int dy) {
        for (Direction2D dir : Direction2D.values()) {
            if (dir.dx() != dx || dir.dy() != dy) continue;
            return dir;
        }
        return null;
    }
}

