/*
 * Decompiled with CFR 0.152.
 */
package com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.intGeom2D;

import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.intGeom2D.Direction2D;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.intGeom2D.Point;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.intGeom2D.Rectangle;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.intGeom2D.Util1D;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.IListSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ListSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.backports.LinkedList;
import java.util.ArrayList;
import java.util.List;

public class OrthogonalUtil {
    public static List<Point> refinePolyline(List<Point> polyline) {
        IListSequence<Point> refined = ListSequence.fromList(new LinkedList());
        Point prev = (Point)ListSequence.fromList(polyline).first();
        boolean prevVer = false;
        boolean firstSeg = true;
        ListSequence.fromList(refined).addElement(prev);
        for (Point next : ListSequence.fromList(polyline)) {
            boolean nextVer;
            if (next.equals(prev)) continue;
            boolean bl = nextVer = prev.x == next.x;
            if (!firstSeg && nextVer != prevVer) {
                ListSequence.fromList(refined).addElement(prev);
            }
            firstSeg = false;
            prevVer = nextVer;
            prev = next;
        }
        ListSequence.fromList(refined).addElement(prev);
        return refined;
    }

    public static Point findOnBorder(Rectangle rect, Point p1, Point p2) {
        if (p1.x == p2.x) {
            if (Util1D.insideClosedSegment(p1.y, p2.y, rect.y)) {
                return new Point(p1.x, rect.y);
            }
            if (Util1D.insideClosedSegment(p1.y, p2.y, rect.maxY())) {
                return new Point(p1.x, rect.maxY());
            }
        }
        if (p1.y == p2.y) {
            if (Util1D.insideClosedSegment(p1.x, p2.x, rect.x)) {
                return new Point(rect.x, p1.y);
            }
            if (Util1D.insideClosedSegment(p1.x, p2.x, rect.maxX())) {
                return new Point(rect.maxX(), p1.y);
            }
        }
        return null;
    }

    public static Point moveToBorder(Rectangle rect, Point b, Point e) {
        IListSequence rectPoints = ListSequence.fromList(new ArrayList());
        boolean ver = b.x == e.x;
        ListSequence.fromList(rectPoints).addElement(new Point(rect.x, rect.y));
        ListSequence.fromList(rectPoints).addElement(new Point(rect.x, rect.y + rect.height));
        ListSequence.fromList(rectPoints).addElement(new Point(rect.x + rect.width, rect.y));
        ListSequence.fromList(rectPoints).addElement(new Point(rect.x + rect.width, rect.y + rect.height));
        for (Point p : ListSequence.fromList(rectPoints)) {
            if (!(ver ? p.x == b.x && (p.y - b.y) * (p.y - e.y) < 0 : p.y == b.y && (p.x - b.x) * (p.x - e.x) < 0)) continue;
            return p;
        }
        return null;
    }

    public static Direction2D getDirection(Point begin, Point end) {
        int dx = Util1D.getDirection(begin.x, end.x);
        int dy = Util1D.getDirection(begin.y, end.y);
        return Direction2D.getByShifts(dx, dy);
    }

    public static Point intersects(Point p1, Point q1, Point p2, Point q2) {
        boolean ver2;
        boolean ver1 = p1.x == q1.x;
        boolean bl = ver2 = p2.x == q2.x;
        if (ver1 == ver2) {
            if (OrthogonalUtil.inside(p1, q1, p2)) {
                return p2;
            }
            if (OrthogonalUtil.inside(p1, q1, q2)) {
                return q2;
            }
            if (OrthogonalUtil.inside(p2, q2, p1)) {
                return p1;
            }
            if (OrthogonalUtil.inside(p2, q2, q1)) {
                return q1;
            }
            return null;
        }
        Point res = new Point();
        res.x = ver1 ? p1.x : p2.x;
        res.y = ver2 ? p1.y : p2.y;
        if (!OrthogonalUtil.inside(p1, q1, res)) {
            return null;
        }
        if (!OrthogonalUtil.inside(p2, q2, res)) {
            return null;
        }
        return res;
    }

    public static boolean inside(Point b, Point e, Point mid) {
        if (b.x == e.x && mid.x == e.x) {
            return Util1D.insideClosedSegment(b.y, e.y, mid.y);
        }
        if (b.y == e.y && mid.y == e.y) {
            return Util1D.insideClosedSegment(b.x, e.x, mid.x);
        }
        return false;
    }
}

