/*
 * Decompiled with CFR 0.152.
 */
package com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.intGeom2D;

import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.intGeom2D.Direction2D;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.intGeom2D.GeomUtil;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.intGeom2D.Point;

public class Rectangle {
    public int x;
    public int y;
    public int width;
    public int height;

    public Rectangle(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public Rectangle(Rectangle rect) {
        this.x = rect.x;
        this.y = rect.y;
        this.width = rect.width;
        this.height = rect.height;
    }

    public boolean intersectsSegment(Point p1, Point p2) {
        if (this.contains(p1) || this.contains(p2)) {
            return true;
        }
        Point[] points = this.getCornerPoints();
        boolean intersects = false;
        for (int i = 0; i < points.length; ++i) {
            int next = i + 1;
            if (next == points.length) {
                next = 0;
            }
            intersects |= GeomUtil.intersects(points[i], points[next], p1, p2);
        }
        return intersects;
    }

    public void translate(int shiftX, int shiftY) {
        this.x += shiftX;
        this.y += shiftY;
    }

    public void setLocation(int newX, int newY) {
        this.x = newX;
        this.y = newY;
    }

    public Point[] getCornerPoints() {
        Point[] points = new Point[]{new Point(this.x, this.y), new Point(this.x, this.maxY()), new Point(this.maxX(), this.maxY()), new Point(this.maxX(), this.y)};
        return points;
    }

    public boolean contains(Point p) {
        return p.x >= this.x && p.x <= this.maxX() && p.y >= this.y && p.y <= this.maxY();
    }

    public boolean intersects(Rectangle rect) {
        return GeomUtil.intersects(this.x, this.maxX(), rect.x, rect.maxX()) && GeomUtil.intersects(this.y, this.maxY(), rect.y, rect.maxY());
    }

    public int maxX() {
        return this.x + this.width;
    }

    public int maxY() {
        return this.y + this.height;
    }

    public int size(Direction2D dir) {
        if (dir.isHorizontal()) {
            return this.width;
        }
        return this.height;
    }

    public String toString() {
        return "[min: " + String.valueOf(new Point(this.x, this.y)) + " max: " + String.valueOf(new Point(this.maxX(), this.maxY())) + "]";
    }
}

