/*
 * Decompiled with CFR 0.152.
 */
package com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.internal.flowOrthogonalLayout;

import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.algorithms.MinCostCirculation;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Edge;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Graph;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Node;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.intGeom2D.Direction2D;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarGraph.Dart;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarGraph.EmbeddedGraph;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarGraph.Face;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.IMapSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ListSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.MapSequence;
import java.util.HashMap;
import java.util.Map;

public class EdgeLengthComputer {
    private static int SHOW_INFO = 0;
    private static int UNIT_LENGTH = 3;
    private int myUnitLength = UNIT_LENGTH;

    public void setUnitLength(int length) {
        this.myUnitLength = length;
    }

    public Map<Edge, Integer> compute(EmbeddedGraph embeddedGraph, Map<Dart, Direction2D> directions) {
        return this.compute(embeddedGraph, directions, MapSequence.fromMap(new HashMap()));
    }

    public Map<Edge, Integer> compute(EmbeddedGraph embeddedGraph, Map<Dart, Direction2D> directions, Map<Edge, Integer> predefinedLengths) {
        Map<Edge, Integer> horEdgeLengths = this.computeEdgeLengths(embeddedGraph, directions, Direction2D.RIGHT, predefinedLengths);
        Map<Edge, Integer> verEdgeLenghts = this.computeEdgeLengths(embeddedGraph, directions, Direction2D.DOWN, predefinedLengths);
        IMapSequence<Edge, Integer> lengths = MapSequence.fromMap(new HashMap());
        for (Edge edge : ListSequence.fromList(embeddedGraph.getGraph().getEdges())) {
            int length = MapSequence.fromMap(horEdgeLengths).containsKey(edge) ? ((Integer)MapSequence.fromMap(horEdgeLengths).get(edge)).intValue() : ((Integer)MapSequence.fromMap(verEdgeLenghts).get(edge)).intValue();
            MapSequence.fromMap(lengths).put(edge, length);
        }
        if (SHOW_INFO > 0) {
            for (Edge edge : ListSequence.fromList(embeddedGraph.getGraph().getEdges())) {
                System.out.println("edge: " + String.valueOf(edge) + " length = " + String.valueOf(MapSequence.fromMap(lengths).get(edge)));
            }
        }
        return lengths;
    }

    private Map<Edge, Integer> computeEdgeLengths(EmbeddedGraph embeddedGraph, Map<Dart, Direction2D> directions, Direction2D direction, Map<Edge, Integer> predefinedLengths) {
        Graph graph = embeddedGraph.getGraph();
        Graph network = new Graph();
        IMapSequence edgeMap = MapSequence.fromMap(new HashMap());
        IMapSequence faceMap = MapSequence.fromMap(new HashMap());
        Node source = network.createNode();
        Node target = network.createNode();
        for (Face face : ListSequence.fromList(embeddedGraph.getFaces())) {
            if (embeddedGraph.isOuterFace(face)) continue;
            MapSequence.fromMap(faceMap).put(face, network.createDummyNode());
        }
        IMapSequence<Edge, Integer> low = MapSequence.fromMap(new HashMap());
        IMapSequence<Edge, Integer> capacity = MapSequence.fromMap(new HashMap());
        IMapSequence<Edge, Integer> cost = MapSequence.fromMap(new HashMap());
        Edge backEdge = network.connect(target, source);
        MapSequence.fromMap(low).put(backEdge, 0);
        MapSequence.fromMap(capacity).put(backEdge, 0x3FFFFFFF);
        MapSequence.fromMap(cost).put(backEdge, 0);
        for (Edge edge : ListSequence.fromList(graph.getEdges())) {
            Dart dart = ListSequence.fromList(embeddedGraph.getDarts(edge)).findFirst(_dart -> MapSequence.fromMap(directions).get(_dart) == direction);
            if (dart == null) continue;
            Face targetFace = embeddedGraph.getFace(dart);
            Face sourceFace = embeddedGraph.getFace(embeddedGraph.getOpposite(dart));
            Node sourceNode = embeddedGraph.isOuterFace(sourceFace) ? source : (Node)MapSequence.fromMap(faceMap).get(sourceFace);
            Node targetNode = embeddedGraph.isOuterFace(targetFace) ? target : (Node)MapSequence.fromMap(faceMap).get(targetFace);
            Edge newEdge = network.connect(sourceNode, targetNode);
            MapSequence.fromMap(edgeMap).put(edge, newEdge);
            if (MapSequence.fromMap(predefinedLengths).containsKey(edge)) {
                MapSequence.fromMap(low).put(newEdge, (Integer)MapSequence.fromMap(predefinedLengths).get(edge));
            } else {
                MapSequence.fromMap(low).put(newEdge, this.myUnitLength);
            }
            MapSequence.fromMap(capacity).put(newEdge, 0x3FFFFFFF);
            MapSequence.fromMap(cost).put(newEdge, 1);
        }
        Map<Edge, Integer> circulation = MinCostCirculation.getCirculation(network, low, capacity, cost);
        IMapSequence<Edge, Integer> edgeLength = MapSequence.fromMap(new HashMap());
        for (Edge edge : ListSequence.fromList(graph.getEdges())) {
            if (!MapSequence.fromMap(edgeMap).containsKey(edge)) continue;
            MapSequence.fromMap(edgeLength).put(edge, (Integer)MapSequence.fromMap(circulation).get(MapSequence.fromMap(edgeMap).get(edge)));
        }
        return edgeLength;
    }
}

