/*
 * Decompiled with CFR 0.152.
 */
package com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.internal.flowOrthogonalLayout;

import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.flowOrthogonalLayout.EmbeddedGraphModifier;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.flowOrthogonalLayout.OrthogonalRepresentation;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Edge;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.EdgesHistoryManager;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Graph;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.INode;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Node;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graphLayout.GraphPointLayout;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graphLayout.IPointLayouter;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.intGeom2D.Direction2D;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.intGeom2D.Point;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.internal.flowOrthogonalLayout.CoordinatePlacer;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.internal.flowOrthogonalLayout.EdgeLengthComputer;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.internal.flowOrthogonalLayout.OrthogonalRepresentationWithNodesProcessing;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarGraph.Dart;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarGraph.EmbeddedGraph;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarGraph.Face;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarization.PQPlanarizationFinder;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarization.ShortestPathEmbeddingFinder;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.IListSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.IMapSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ISequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ListSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.MapSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.Sequence;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FlowLayoutWithNodeProcessing
implements IPointLayouter {
    private static int SHOW_lOG = 0;

    public void getLayout(EmbeddedGraph embeddedGraph) {
        Graph graph = embeddedGraph.getGraph();
        IListSequence initialEdges = ListSequence.fromList(new ArrayList());
        IListSequence initialNodes = ListSequence.fromList(new ArrayList());
        ListSequence.fromList(initialEdges).addSequence((ISequence)ListSequence.fromList(graph.getEdges()));
        ListSequence.fromList(initialNodes).addSequence((ISequence)ListSequence.fromList(graph.getNodes()));
        EmbeddedGraphModifier modifier = new EmbeddedGraphModifier(embeddedGraph);
        IMapSequence<Edge, Edge> replacedEdges = MapSequence.fromMap(new HashMap());
        modifier.reduceNodesDegree(MapSequence.fromMap(new HashMap()), replacedEdges, true);
        IMapSequence<Dart, Integer> bends = MapSequence.fromMap(new HashMap());
        IMapSequence<Dart, Integer> angles = MapSequence.fromMap(new HashMap());
        OrthogonalRepresentationWithNodesProcessing.getRepresentation(embeddedGraph, MapSequence.fromMap(modifier.getNodeFaces()).values(), bends, angles);
        OrthogonalRepresentationWithNodesProcessing.replaceBendsByNodes(embeddedGraph, bends, angles);
        Map<Dart, Direction2D> directions = OrthogonalRepresentation.getDirections(embeddedGraph, angles);
    }

    @Override
    public GraphPointLayout doLayout(Graph graph) {
        Graph copy = new Graph();
        IMapSequence nodeMap = MapSequence.fromMap(new HashMap());
        IMapSequence edgeMap = MapSequence.fromMap(new HashMap());
        for (Node node : ListSequence.fromList(graph.getNodes())) {
            MapSequence.fromMap(nodeMap).put(node, copy.createNode());
        }
        for (Edge edge : ListSequence.fromList(graph.getEdges())) {
            MapSequence.fromMap(edgeMap).put(edge, copy.connect((INode)MapSequence.fromMap(nodeMap).get(edge.getSource()), (INode)MapSequence.fromMap(nodeMap).get(edge.getTarget())));
        }
        EdgesHistoryManager historyManager = new EdgesHistoryManager(copy);
        EmbeddedGraph embeddedGraph = new ShortestPathEmbeddingFinder(new PQPlanarizationFinder()).find(copy);
        IMapSequence<Edge, List<Edge>> history = MapSequence.fromMap(new HashMap());
        for (Edge edge : ListSequence.fromList(graph.getEdges())) {
            Edge copyEdge = (Edge)MapSequence.fromMap(edgeMap).get(edge);
            MapSequence.fromMap(history).put(edge, historyManager.getHistory(copyEdge));
            if (copyEdge.getSource() == MapSequence.fromMap(nodeMap).get(edge.getSource())) continue;
            MapSequence.fromMap(history).put(edge, ListSequence.fromList((List)MapSequence.fromMap(history).get(edge)).reversedList());
        }
        IMapSequence<Node, List<Node>> newNodes = MapSequence.fromMap(new HashMap());
        IMapSequence<Edge, Edge> replacedEdges = MapSequence.fromMap(new HashMap());
        EmbeddedGraphModifier modifier = new EmbeddedGraphModifier(embeddedGraph);
        modifier.reduceNodesDegree(newNodes, replacedEdges, true);
        this.updateHistory(replacedEdges, history);
        IMapSequence<Dart, Integer> bends = MapSequence.fromMap(new HashMap());
        IMapSequence<Dart, Integer> angles = MapSequence.fromMap(new HashMap());
        OrthogonalRepresentationWithNodesProcessing.getRepresentation(embeddedGraph, MapSequence.fromMap(modifier.getNodeFaces()).values(), bends, angles);
        OrthogonalRepresentationWithNodesProcessing.replaceBendsByNodes(embeddedGraph, bends, angles);
        Map<Dart, Direction2D> directions = OrthogonalRepresentation.getDirections(embeddedGraph, angles);
        return null;
    }

    private void updateHistory(Map<Edge, Edge> replacedEdges, Map<Edge, List<Edge>> history) {
        for (List list : Sequence.fromIterable(MapSequence.fromMap(history).values())) {
            Edge first = (Edge)ListSequence.fromList(list).first();
            if (MapSequence.fromMap(replacedEdges).containsKey(first)) {
                ListSequence.fromList(list).setElement(0, (Edge)MapSequence.fromMap(replacedEdges).get(first));
            }
            if (ListSequence.fromList(list).count() <= 1) continue;
            Edge last = (Edge)ListSequence.fromList(list).last();
            if (!MapSequence.fromMap(replacedEdges).containsKey(last)) continue;
            ListSequence.fromList(list).setElement(ListSequence.fromList(list).count() - 1, (Edge)MapSequence.fromMap(replacedEdges).get(last));
        }
    }

    public GraphPointLayout getFlowLayout(EmbeddedGraph embeddedGraph, EmbeddedGraphModifier modifier, EdgesHistoryManager historyManager) {
        IListSequence<Point> edgeLayout;
        Graph graph = embeddedGraph.getGraph();
        IListSequence oldEdges = ListSequence.fromList(new ArrayList());
        ListSequence.fromList(oldEdges).addSequence((ISequence)ListSequence.fromList(graph.getEdges()));
        IListSequence oldNodes = ListSequence.fromList(new ArrayList());
        ListSequence.fromList(oldNodes).addSequence((ISequence)ListSequence.fromList(graph.getNodes()));
        IMapSequence<Dart, Integer> bends = MapSequence.fromMap(new HashMap());
        IMapSequence<Dart, Integer> angles = MapSequence.fromMap(new HashMap());
        OrthogonalRepresentationWithNodesProcessing.getRepresentation(embeddedGraph, MapSequence.fromMap(modifier.getNodeFaces()).values(), bends, angles);
        OrthogonalRepresentationWithNodesProcessing.replaceBendsByNodes(embeddedGraph, bends, angles);
        Map<Dart, Direction2D> directions = OrthogonalRepresentation.getDirections(embeddedGraph, angles);
        modifier.setDartDirections(directions);
        modifier.makeRectangularFaces();
        if (SHOW_lOG > 0) {
            System.out.println("after making faces rectangular: ");
            this.printEmbeddedGraphWithDirections(embeddedGraph, directions);
        }
        EdgeLengthComputer lengthComputer = new EdgeLengthComputer();
        lengthComputer.setUnitLength(2);
        Map<Edge, Integer> lengths = lengthComputer.compute(embeddedGraph, directions);
        CoordinatePlacer placer = new CoordinatePlacer(embeddedGraph, lengths, directions);
        Map<Node, Point> coordinates = placer.getCoordinates();
        GraphPointLayout graphLayout = new GraphPointLayout(graph);
        for (Node node : ListSequence.fromList(oldNodes)) {
            graphLayout.setLayoutFor(node, (Point)MapSequence.fromMap(coordinates).get(node));
        }
        for (Edge edge : ListSequence.fromList(oldEdges)) {
            List<Edge> history = historyManager.getHistory(edge);
            edgeLayout = ListSequence.fromList(new ArrayList());
            Node cur = edge.getSource();
            ListSequence.fromList(edgeLayout).addElement((Point)MapSequence.fromMap(coordinates).get(cur));
            for (Edge historyEdge : ListSequence.fromList(history)) {
                Node next = historyEdge.getOpposite(cur);
                ListSequence.fromList(edgeLayout).addElement((Point)MapSequence.fromMap(coordinates).get(next));
                cur = next;
            }
            graphLayout.setLayoutFor(edge, edgeLayout);
        }
        GraphPointLayout copyLayout = new GraphPointLayout(graph);
        for (Node node : ListSequence.fromList(graph.getNodes())) {
            copyLayout.setLayoutFor(node, (Point)MapSequence.fromMap(coordinates).get(node));
        }
        for (Edge edge : ListSequence.fromList(graph.getEdges())) {
            edgeLayout = ListSequence.fromList(new ArrayList());
            ListSequence.fromList(edgeLayout).addElement(new Point((Point)MapSequence.fromMap(coordinates).get(edge.getSource())));
            ListSequence.fromList(edgeLayout).addElement(new Point((Point)MapSequence.fromMap(coordinates).get(edge.getTarget())));
            copyLayout.setLayoutFor(edge, edgeLayout);
        }
        return graphLayout;
    }

    private void printEmbeddedGraphWithDirections(EmbeddedGraph embeddedGraph, Map<Dart, Direction2D> directions) {
        for (Face face : ListSequence.fromList(embeddedGraph.getFaces())) {
            System.out.println("face: ");
            if (embeddedGraph.isOuterFace(face)) {
                System.out.println("outer!");
            }
            for (Dart dart : ListSequence.fromList(face.getDarts())) {
                System.out.print(String.valueOf(dart) + " dir = " + String.valueOf(MapSequence.fromMap(directions).get(dart)) + "; ");
            }
            System.out.println();
        }
    }
}

