/*
 * Decompiled with CFR 0.152.
 */
package com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.internal.flowOrthogonalLayout;

import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.algorithms.BiconnectAugmentation;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.flowOrthogonalLayout.OrthogonalRepresentation;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.flowOrthogonalLayout.QuasiOrthogonalRepresentation;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.flowOrthogonalLayout.QuasiRepresentationModifier;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Edge;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.EdgesHistoryManager;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Graph;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.INode;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Node;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graphLayout.GraphLayout;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graphLayout.GraphLayoutFactory;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.intGeom2D.Dimension;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.intGeom2D.Direction2D;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.intGeom2D.OrthogonalUtil;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.intGeom2D.Point;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.intGeom2D.Rectangle;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.internal.flowOrthogonalLayout.ConstraintsGraphProcessor;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarGraph.Dart;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarGraph.EmbeddedGraph;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarization.PQPlanarizationFinder;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarization.ShortestPathEmbeddingFinder;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.IListSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.IMapSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ISequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ISetSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ListSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.MapSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.SetSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.backports.LinkedList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class OrthogonalFlowLayouterConstraints {
    private static int DEFAULT_UNIT_LENGTH = 20;
    private static int SHOW_LOG = 0;
    private int myUnitLength = DEFAULT_UNIT_LENGTH;

    public GraphLayout doLayout(Graph graph, Map<Node, Dimension> nodeSizes) {
        Graph copy = new Graph();
        IMapSequence nodeMap = MapSequence.fromMap(new HashMap());
        IMapSequence edgeMap = MapSequence.fromMap(new HashMap());
        IMapSequence<Node, Dimension> copySizes = MapSequence.fromMap(new LinkedHashMap(16, 0.75f, false));
        for (Node node : ListSequence.fromList(graph.getNodes())) {
            Iterator copyNode = copy.createNode();
            MapSequence.fromMap(nodeMap).put(node, (Node)((Object)copyNode));
            MapSequence.fromMap(copySizes).put(copyNode, (Dimension)MapSequence.fromMap(nodeSizes).get(node));
        }
        for (Edge edge : ListSequence.fromList(graph.getEdges())) {
            MapSequence.fromMap(edgeMap).put(edge, copy.connect((INode)MapSequence.fromMap(nodeMap).get(edge.getSource()), (INode)MapSequence.fromMap(nodeMap).get(edge.getTarget())));
        }
        GraphLayout copyLayout = this.getLayoutCorruptGraph(copy, copySizes);
        GraphLayout layout = GraphLayoutFactory.createGraphLayout(graph);
        for (Node node : ListSequence.fromList(graph.getNodes())) {
            layout.setLayoutFor(node, copyLayout.getNodeLayout((INode)MapSequence.fromMap(nodeMap).get(node)));
        }
        for (Edge edge : ListSequence.fromList(graph.getEdges())) {
            Edge copyEdge = (Edge)MapSequence.fromMap(edgeMap).get(edge);
            IListSequence<Point> copyEdgeLayout = copyLayout.getEdgeLayout(copyEdge);
            if (copyEdge.getSource() != MapSequence.fromMap(nodeMap).get(edge.getSource())) {
                copyEdgeLayout = ListSequence.fromList(copyEdgeLayout).reversedList();
            }
            layout.setLayoutFor(edge, copyEdgeLayout);
        }
        Rectangle rect = layout.getContainingRectangle();
        layout = layout.shift(20 - rect.x, 20 - rect.y);
        return layout;
    }

    private GraphLayout getLayoutCorruptGraph(Graph graph, Map<Node, Dimension> nodeSizes) {
        ISetSequence initialNodes = SetSequence.fromSet(new HashSet());
        SetSequence.fromSet(initialNodes).addSequence((ISequence)ListSequence.fromList(graph.getNodes()));
        ISetSequence initialEdges = SetSequence.fromSet(new HashSet());
        SetSequence.fromSet(initialEdges).addSequence((ISequence)ListSequence.fromList(graph.getEdges()));
        EdgesHistoryManager historyManager = new EdgesHistoryManager(graph);
        BiconnectAugmentation.smartMakeBiconnected(graph);
        EmbeddedGraph embeddedGraph = new ShortestPathEmbeddingFinder(new PQPlanarizationFinder()).find(graph);
        IMapSequence history = MapSequence.fromMap(new HashMap());
        for (Edge edge : SetSequence.fromSet(initialEdges)) {
            MapSequence.fromMap(history).put(edge, historyManager.getHistory(edge));
        }
        GraphLayout layout = this.getLayoutFromEmbeddedGraph(embeddedGraph, nodeSizes, historyManager);
        GraphLayout initialLayout = GraphLayoutFactory.createGraphLayout(graph);
        for (Node node : SetSequence.fromSet(initialNodes)) {
            initialLayout.setLayoutFor(node, layout.getNodeLayout(node));
        }
        for (Edge edge : SetSequence.fromSet(initialEdges)) {
            IListSequence<Point> edgeLayout = ListSequence.fromList(new ArrayList());
            Node cur = edge.getSource();
            for (Edge historyEdge : ListSequence.fromList((List)MapSequence.fromMap(history).get(edge))) {
                IListSequence historyLayout = layout.getEdgeLayout(historyEdge);
                if (historyEdge.getSource() != cur) {
                    historyLayout = ListSequence.fromList(historyLayout).reversedList();
                }
                ListSequence.fromList(edgeLayout).addSequence((ISequence)ListSequence.fromList(historyLayout));
                cur = historyEdge.getOpposite(cur);
            }
            initialLayout.setLayoutFor(edge, edgeLayout);
        }
        return initialLayout;
    }

    private GraphLayout getLayoutFromEmbeddedGraph(EmbeddedGraph embeddedGraph, Map<Node, Dimension> nodeSizes, EdgesHistoryManager historyManager) {
        if (SHOW_LOG > 0) {
            System.out.println("initial graph: " + String.valueOf(embeddedGraph));
        }
        Graph graph = embeddedGraph.getGraph();
        IListSequence oldEdges = ListSequence.fromList(new ArrayList());
        ListSequence.fromList(oldEdges).addSequence((ISequence)ListSequence.fromList(graph.getEdges()));
        IListSequence<Node> oldNodes = ListSequence.fromList(new ArrayList());
        ListSequence.fromList(oldNodes).addSequence((ISequence)SetSequence.fromSet(MapSequence.fromMap(nodeSizes).keySet()));
        IMapSequence<Dart, Integer> bends = MapSequence.fromMap(new HashMap());
        IMapSequence<Dart, Integer> angles = MapSequence.fromMap(new HashMap());
        QuasiOrthogonalRepresentation.getRepresentation(embeddedGraph, bends, angles);
        QuasiRepresentationModifier quasiModifier = new QuasiRepresentationModifier(embeddedGraph, bends, angles);
        quasiModifier.reduceToOrthogonalRepresentation();
        if (SHOW_LOG > 0) {
            System.out.println("modifications: ");
            for (QuasiRepresentationModifier.Modification modification : ListSequence.fromList(quasiModifier.getModifications())) {
                System.out.println(modification);
            }
        }
        OrthogonalRepresentation.replaceBendsByNodes(embeddedGraph, bends, angles);
        Map<Dart, Direction2D> directions = OrthogonalRepresentation.getDirections(embeddedGraph, angles);
        if (SHOW_LOG > 0) {
            System.out.println("modified graph: " + String.valueOf(embeddedGraph));
        }
        Map<Node, Map<Direction2D, Integer>> nodeDirectionSizes = this.getNodeDirectionSizes(oldNodes, nodeSizes);
        Map<Edge, Integer> edgesShifts = this.getEdgesShifts(quasiModifier.getModifications(), directions, nodeSizes);
        ConstraintsGraphProcessor processor = new ConstraintsGraphProcessor(embeddedGraph, directions);
        processor.setUnitLength(this.myUnitLength);
        processor.modifyEmbeddedGraph(oldNodes, nodeSizes);
        processor.constructGraph();
        Map<Node, Point> coordinates = processor.getCoordinatesInModifiedGraph(edgesShifts, nodeDirectionSizes, historyManager);
        GraphLayout graphLayout = GraphLayoutFactory.createGraphLayout(graph);
        for (Node node : ListSequence.fromList(oldNodes)) {
            Point center = (Point)MapSequence.fromMap(coordinates).get(node);
            Map sizes = (Map)MapSequence.fromMap(nodeDirectionSizes).get(node);
            Dimension nodeSize = (Dimension)MapSequence.fromMap(nodeSizes).get(node);
            Rectangle rect = new Rectangle(center.x - (Integer)MapSequence.fromMap(sizes).get((Object)Direction2D.LEFT), center.y - (Integer)MapSequence.fromMap(sizes).get((Object)Direction2D.DOWN), nodeSize.width, nodeSize.height);
            graphLayout.setLayoutFor(node, rect);
        }
        for (Edge edge : ListSequence.fromList(oldEdges)) {
            Direction2D dir;
            Node source = edge.getSource();
            Node target = edge.getTarget();
            List<Edge> history = historyManager.getHistory(edge);
            IListSequence<Point> edgeLayout = ListSequence.fromList(new LinkedList());
            Node cur = source;
            ListSequence.fromList(edgeLayout).addElement(new Point((Point)MapSequence.fromMap(coordinates).get(cur)));
            for (Edge historyEdge : ListSequence.fromList(history)) {
                Node next = historyEdge.getOpposite(cur);
                ListSequence.fromList(edgeLayout).addElement(new Point((Point)MapSequence.fromMap(coordinates).get(next)));
                cur = next;
            }
            if (ListSequence.fromList(oldNodes).contains(source)) {
                dir = (Direction2D)((Object)MapSequence.fromMap(directions).get(embeddedGraph.getSourceDart((Edge)ListSequence.fromList(history).first(), source)));
                int size = (Integer)MapSequence.fromMap((Map)MapSequence.fromMap(nodeDirectionSizes).get(source)).get((Object)dir);
                Point first = ListSequence.fromList(edgeLayout).removeElementAt(0);
                first.translate(size * dir.dx(), size * dir.dy());
                ListSequence.fromList(edgeLayout).removeElementAt(0);
                ListSequence.fromList(edgeLayout).insertElement(0, first);
            }
            if (ListSequence.fromList(oldNodes).contains(edge.getTarget())) {
                dir = (Direction2D)((Object)MapSequence.fromMap(directions).get(embeddedGraph.getSourceDart((Edge)ListSequence.fromList(history).last(), target)));
                int size = (Integer)MapSequence.fromMap((Map)MapSequence.fromMap(nodeDirectionSizes).get(target)).get((Object)dir);
                Point last = ListSequence.fromList(edgeLayout).removeLastElement();
                last.translate(size * dir.dx(), size * dir.dy());
                ListSequence.fromList(edgeLayout).removeLastElement();
                ListSequence.fromList(edgeLayout).addElement(last);
            }
            graphLayout.setLayoutFor(edge, edgeLayout);
        }
        for (QuasiRepresentationModifier.Modification modification : ListSequence.fromList(quasiModifier.getModifications())) {
            this.splitEdges(graphLayout, modification, edgesShifts);
        }
        return graphLayout;
    }

    private Map<Node, Map<Direction2D, Integer>> getNodeDirectionSizes(List<Node> oldNodes, Map<Node, Dimension> nodeSizes) {
        IMapSequence<Node, Map<Direction2D, Integer>> nodeDirectionSizes = MapSequence.fromMap(new HashMap());
        for (Node node : ListSequence.fromList(oldNodes)) {
            IMapSequence directionSizes = MapSequence.fromMap(new HashMap());
            Dimension size = (Dimension)MapSequence.fromMap(nodeSizes).get(node);
            int horSize = size.height;
            MapSequence.fromMap(directionSizes).put(Direction2D.UP, horSize / 2);
            MapSequence.fromMap(directionSizes).put(Direction2D.DOWN, horSize - (Integer)MapSequence.fromMap(directionSizes).get((Object)Direction2D.UP));
            int verSize = size.width;
            MapSequence.fromMap(directionSizes).put(Direction2D.LEFT, verSize / 2);
            MapSequence.fromMap(directionSizes).put(Direction2D.RIGHT, verSize - (Integer)MapSequence.fromMap(directionSizes).get((Object)Direction2D.LEFT));
            MapSequence.fromMap(nodeDirectionSizes).put(node, directionSizes);
        }
        return nodeDirectionSizes;
    }

    private Map<Edge, Integer> getEdgesShifts(List<QuasiRepresentationModifier.Modification> modifications, Map<Dart, Direction2D> directions, Map<Node, Dimension> nodeSizes) {
        IMapSequence<Edge, Integer> edgeShifts = MapSequence.fromMap(new HashMap());
        for (QuasiRepresentationModifier.Modification modification : ListSequence.fromList(modifications)) {
            List<Edge> edges = modification.getNewEdges();
            Node node = modification.getSource();
            Direction2D dir = (Direction2D)((Object)MapSequence.fromMap(directions).get(modification.getSourceDart()));
            int nodeLength = dir.isVertical() ? ((Dimension)MapSequence.fromMap(nodeSizes).get((Object)node)).width / 2 : ((Dimension)MapSequence.fromMap(nodeSizes).get((Object)node)).height / 2;
            nodeLength = Math.min(nodeLength, this.myUnitLength);
            int unitShift = nodeLength / ListSequence.fromList(edges).count();
            int curShift = 0;
            for (Edge edge : ListSequence.fromList(edges)) {
                MapSequence.fromMap(edgeShifts).put(edge, curShift);
                curShift += unitShift;
            }
        }
        return edgeShifts;
    }

    private void splitEdges(GraphLayout layout, QuasiRepresentationModifier.Modification modification, Map<Edge, Integer> edgeShifts) {
        Direction2D dartsDir;
        List<Edge> edges = modification.getModifiedEdges();
        Edge firstEdge = (Edge)ListSequence.fromList(edges).first();
        Iterable path = layout.getEdgeLayout(firstEdge);
        Node node = modification.getSource();
        if (firstEdge.getSource() == node) {
            dartsDir = OrthogonalUtil.getDirection((Point)ListSequence.fromList(path).getElement(0), (Point)ListSequence.fromList(path).getElement(1));
        } else {
            int last = ListSequence.fromList(path).count() - 1;
            dartsDir = OrthogonalUtil.getDirection((Point)ListSequence.fromList(path).getElement(last), (Point)ListSequence.fromList(path).getElement(last - 1));
        }
        Direction2D shiftDir = dartsDir.turnClockwise(3);
        int dx = shiftDir.dx();
        int dy = shiftDir.dy();
        Iterator newEdgeItr = ListSequence.fromList(modification.getNewEdges()).iterator();
        for (Edge edge : ListSequence.fromList(edges)) {
            IListSequence<Point> pointsToShift;
            layout.removeStraightBends(edge);
            Iterable edgeLayout = layout.getEdgeLayout(edge);
            if (edge.getSource() == node) {
                pointsToShift = ListSequence.fromListAndArray(new ArrayList(), (Point)ListSequence.fromList(edgeLayout).getElement(0), (Point)ListSequence.fromList(edgeLayout).getElement(1));
            } else {
                int last = ListSequence.fromList(edgeLayout).count() - 1;
                pointsToShift = ListSequence.fromListAndArray(new ArrayList(), (Point)ListSequence.fromList(edgeLayout).getElement(last), (Point)ListSequence.fromList(edgeLayout).getElement(last - 1));
            }
            Edge newEdge = (Edge)newEdgeItr.next();
            for (Point point : ListSequence.fromList(pointsToShift)) {
                point.translate(dx * (Integer)MapSequence.fromMap(edgeShifts).get(newEdge), dy * (Integer)MapSequence.fromMap(edgeShifts).get(newEdge));
            }
        }
    }

    private void splitEdges(GraphLayout layout, QuasiRepresentationModifier.Modification modification) {
        Direction2D dartsDir;
        List<Edge> edges = modification.getModifiedEdges();
        Edge firstEdge = (Edge)ListSequence.fromList(edges).first();
        Iterable path = layout.getEdgeLayout(firstEdge);
        Node node = modification.getSource();
        if (firstEdge.getSource() == node) {
            dartsDir = OrthogonalUtil.getDirection((Point)ListSequence.fromList(path).getElement(0), (Point)ListSequence.fromList(path).getElement(1));
        } else {
            int last = ListSequence.fromList(path).count() - 1;
            dartsDir = OrthogonalUtil.getDirection((Point)ListSequence.fromList(path).getElement(last), (Point)ListSequence.fromList(path).getElement(last - 1));
        }
        Direction2D shiftDir = dartsDir.turnClockwise(3);
        int dx = shiftDir.dx();
        int dy = shiftDir.dy();
        int nodeLenght = dx != 0 ? layout.getNodeLayout((INode)node).width : layout.getNodeLayout((INode)node).height;
        int unitShift = nodeLenght / (2 * ListSequence.fromList(edges).count());
        int curShift = 0;
        for (Edge edge : ListSequence.fromList(edges)) {
            if (edge != ListSequence.fromList(edges).first()) {
                IListSequence<Point> pointsToShift;
                layout.removeStraightBends(edge);
                Iterable edgeLayout = layout.getEdgeLayout(edge);
                if (edge.getSource() == node) {
                    pointsToShift = ListSequence.fromListAndArray(new ArrayList(), (Point)ListSequence.fromList(edgeLayout).getElement(0), (Point)ListSequence.fromList(edgeLayout).getElement(1));
                } else {
                    int last = ListSequence.fromList(edgeLayout).count() - 1;
                    pointsToShift = ListSequence.fromListAndArray(new ArrayList(), (Point)ListSequence.fromList(edgeLayout).getElement(last), (Point)ListSequence.fromList(edgeLayout).getElement(last - 1));
                }
                for (Point point : ListSequence.fromList(pointsToShift)) {
                    point.translate(dx * curShift, dy * curShift);
                }
            }
            curShift += unitShift;
        }
    }

    public void setUnitLength(int unitLength) {
        this.myUnitLength = unitLength;
    }
}

