/*
 * Decompiled with CFR 0.152.
 */
package com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.internal.flowOrthogonalLayout;

import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.algorithms.BiconnectAugmentation;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.flowOrthogonalLayout.EmbeddedGraphModifier;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.flowOrthogonalLayout.OrthogonalRepresentation;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.flowOrthogonalLayout.QuasiOrthogonalRepresentation;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.flowOrthogonalLayout.QuasiRepresentationModifier;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Edge;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.EdgesHistoryManager;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Graph;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.INode;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Node;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graphLayout.GraphPointLayout;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graphLayout.IPointLayouter;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.intGeom2D.Direction2D;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.intGeom2D.Point;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.internal.flowOrthogonalLayout.ConstraintsGraphProcessor;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.internal.flowOrthogonalLayout.EdgeLengthComputer;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarGraph.Dart;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarGraph.EmbeddedGraph;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarGraph.Face;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarization.PQPlanarizationFinder;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarization.ShortestPathEmbeddingFinder;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.IListSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.IMapSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ISequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ListSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.MapSequence;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class OrthogonalPointFlowLayouter
implements IPointLayouter {
    private static int UNIT_LENGHT = 1;
    private static int SHOW_lOG = 0;
    private static int SHOW_TIME = 0;
    private static int MILLIS = 1000;
    private double curTime;

    @Override
    public GraphPointLayout doLayout(Graph graph) {
        double time;
        this.curTime = time = (double)System.currentTimeMillis();
        if (SHOW_TIME > 0) {
            System.out.println("creating layout for graph with " + ListSequence.fromList(graph.getNodes()).count() + " nodes and " + ListSequence.fromList(graph.getEdges()).count() + " edges...");
        }
        Graph copy = new Graph();
        IMapSequence nodeMap = MapSequence.fromMap(new HashMap());
        IMapSequence edgeMap = MapSequence.fromMap(new HashMap());
        for (Node node : ListSequence.fromList(graph.getNodes())) {
            MapSequence.fromMap(nodeMap).put(node, copy.createNode());
        }
        for (Edge edge : ListSequence.fromList(graph.getEdges())) {
            MapSequence.fromMap(edgeMap).put(edge, copy.connect((INode)MapSequence.fromMap(nodeMap).get(edge.getSource()), (INode)MapSequence.fromMap(nodeMap).get(edge.getTarget())));
        }
        EdgesHistoryManager historyManager = new EdgesHistoryManager(copy);
        BiconnectAugmentation.smartMakeBiconnected(copy);
        EmbeddedGraph embeddedGraph = new ShortestPathEmbeddingFinder(new PQPlanarizationFinder()).find(copy);
        IMapSequence history = MapSequence.fromMap(new HashMap());
        for (Edge edge : ListSequence.fromList(graph.getEdges())) {
            Iterator copyEdge = (Edge)MapSequence.fromMap(edgeMap).get(edge);
            MapSequence.fromMap(history).put(edge, historyManager.getHistory((Edge)((Object)copyEdge)));
            if (((Edge)((Object)copyEdge)).getSource() == MapSequence.fromMap(nodeMap).get(edge.getSource())) continue;
            MapSequence.fromMap(history).put(edge, ListSequence.fromList((List)MapSequence.fromMap(history).get(edge)).reversedList());
        }
        if (SHOW_TIME > 0) {
            long newTime = System.currentTimeMillis();
            System.out.println("finding the embedding: " + ((double)newTime - this.curTime) / (double)MILLIS);
            System.out.println("graph now has " + ListSequence.fromList(copy.getNodes()).count() + " nodes and " + ListSequence.fromList(copy.getEdges()).count() + " edges");
            this.curTime = newTime;
        }
        GraphPointLayout copyLayout = this.getFlowLayout(embeddedGraph, historyManager);
        GraphPointLayout graphLayout = new GraphPointLayout(graph);
        for (Node node : ListSequence.fromList(graph.getNodes())) {
            graphLayout.setLayoutFor(node, copyLayout.getLayoutFor((Node)MapSequence.fromMap(nodeMap).get(node)));
        }
        for (Edge graphEdge : ListSequence.fromList(graph.getEdges())) {
            IListSequence<Point> edgeLayout = ListSequence.fromList(new ArrayList());
            List edgeHistory = (List)MapSequence.fromMap(history).get(graphEdge);
            Node cur = (Node)MapSequence.fromMap(nodeMap).get(graphEdge.getSource());
            for (Edge edge : ListSequence.fromList(edgeHistory)) {
                if (cur == edge.getSource()) {
                    ListSequence.fromList(edgeLayout).addSequence(ListSequence.fromList(copyLayout.getLayoutFor(edge)));
                } else {
                    ListSequence.fromList(edgeLayout).addSequence(ListSequence.fromList(copyLayout.getLayoutFor(edge)).reversedList());
                }
                cur = edge.getOpposite(cur);
            }
            graphLayout.setLayoutFor(graphEdge, edgeLayout);
        }
        if (SHOW_TIME > 0) {
            long newTime = System.currentTimeMillis();
            System.out.println("all: " + ((double)newTime - time) / (double)MILLIS);
        }
        return graphLayout;
    }

    public GraphPointLayout getFlowLayout(EmbeddedGraph embeddedGraph, EdgesHistoryManager historyManager) {
        Graph graph = embeddedGraph.getGraph();
        IListSequence oldEdges = ListSequence.fromList(new ArrayList());
        ListSequence.fromList(oldEdges).addSequence((ISequence)ListSequence.fromList(graph.getEdges()));
        IListSequence oldNodes = ListSequence.fromList(new ArrayList());
        ListSequence.fromList(oldNodes).addSequence((ISequence)ListSequence.fromList(graph.getNodes()));
        IMapSequence<Dart, Integer> bends = MapSequence.fromMap(new HashMap());
        IMapSequence<Dart, Integer> angles = MapSequence.fromMap(new HashMap());
        QuasiOrthogonalRepresentation.getRepresentation(embeddedGraph, bends, angles);
        if (SHOW_lOG > 0) {
            System.out.println("bends:");
            System.out.println(bends);
        }
        if (SHOW_TIME > 0) {
            long newTime = System.currentTimeMillis();
            System.out.println("finding the representation: " + ((double)newTime - this.curTime) / (double)MILLIS);
            this.curTime = newTime;
        }
        new QuasiRepresentationModifier(embeddedGraph, bends, angles).reduceToOrthogonalRepresentation();
        OrthogonalRepresentation.replaceBendsByNodes(embeddedGraph, bends, angles);
        Map<Dart, Direction2D> directions = OrthogonalRepresentation.getDirections(embeddedGraph, angles);
        EmbeddedGraphModifier modifier = new EmbeddedGraphModifier(embeddedGraph);
        modifier.setDartDirections(directions);
        modifier.makeRectangularFaces();
        if (SHOW_lOG > 0) {
            System.out.println("after making faces rectangular: ");
            this.printEmbeddedGraphWithDirections(embeddedGraph, directions);
        }
        if (SHOW_TIME > 0) {
            long newTime = System.currentTimeMillis();
            System.out.println("making faces rectangular: " + ((double)newTime - this.curTime) / (double)MILLIS);
            System.out.println("graph now has " + ListSequence.fromList(graph.getNodes()).count() + " nodes and " + ListSequence.fromList(graph.getEdges()).count() + " edges");
            this.curTime = newTime;
        }
        Map<Edge, Integer> lengths = new EdgeLengthComputer().compute(embeddedGraph, directions);
        ConstraintsGraphProcessor processor = new ConstraintsGraphProcessor(embeddedGraph, directions);
        processor.constructGraph();
        Map<Node, Point> coordinates = processor.getCoordinates();
        GraphPointLayout graphLayout = new GraphPointLayout(graph);
        for (Node node : ListSequence.fromList(oldNodes)) {
            graphLayout.setLayoutFor(node, (Point)MapSequence.fromMap(coordinates).get(node));
        }
        for (Edge edge : ListSequence.fromList(oldEdges)) {
            List<Edge> history = historyManager.getHistory(edge);
            IListSequence<Point> edgeLayout = ListSequence.fromList(new ArrayList());
            Node cur = edge.getSource();
            ListSequence.fromList(edgeLayout).addElement((Point)MapSequence.fromMap(coordinates).get(cur));
            for (Edge historyEdge : ListSequence.fromList(history)) {
                Node next = historyEdge.getOpposite(cur);
                ListSequence.fromList(edgeLayout).addElement((Point)MapSequence.fromMap(coordinates).get(next));
                cur = next;
            }
            graphLayout.setLayoutFor(edge, edgeLayout);
        }
        if (SHOW_TIME > 0) {
            long newTime = System.currentTimeMillis();
            System.out.println("finding layout: " + ((double)newTime - this.curTime) / (double)MILLIS);
            this.curTime = newTime;
        }
        return graphLayout;
    }

    private void printEmbeddedGraphWithDirections(EmbeddedGraph embeddedGraph, Map<Dart, Direction2D> directions) {
        for (Face face : ListSequence.fromList(embeddedGraph.getFaces())) {
            System.out.println("face: ");
            if (embeddedGraph.isOuterFace(face)) {
                System.out.println("outer!");
            }
            for (Dart dart : ListSequence.fromList(face.getDarts())) {
                System.out.print(String.valueOf(dart) + " dir = " + String.valueOf(MapSequence.fromMap(directions).get(dart)) + "; ");
            }
            System.out.println();
        }
    }
}

