/*
 * Decompiled with CFR 0.152.
 */
package com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.internal.flowOrthogonalLayout;

import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.algorithms.BiconnectAugmentation;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.flowOrthogonalLayout.EmbeddedGraphModifier;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.flowOrthogonalLayout.OrthogonalRepresentation;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Edge;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.EdgesHistoryManager;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Graph;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.INode;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Node;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graphLayout.GraphLayout;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graphLayout.GraphLayoutFactory;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.intGeom2D.Dimension;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.intGeom2D.Direction2D;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.intGeom2D.GeomUtil;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.intGeom2D.Point;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.intGeom2D.Rectangle;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.internal.flowOrthogonalLayout.CoordinatePlacer;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.internal.flowOrthogonalLayout.EdgeLengthComputer;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarGraph.Dart;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarGraph.EmbeddedGraph;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarization.PQPlanarizationFinder;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarization.ShortestPathEmbeddingFinder;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.IListSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.IMapSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ISequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ListSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.MapSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.Sequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.SetSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.backports.LinkedList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OrthogonalRectFlowLayouter {
    private static int SHOW_lOG = 0;

    public GraphLayout doLayout(Graph graph, Map<Node, Dimension> nodeSizes) {
        Graph copy = new Graph();
        IMapSequence nodeMap = MapSequence.fromMap(new HashMap());
        IMapSequence edgeMap = MapSequence.fromMap(new HashMap());
        for (Node node : ListSequence.fromList(graph.getNodes())) {
            MapSequence.fromMap(nodeMap).put(node, copy.createNode());
        }
        for (Edge edge : ListSequence.fromList(graph.getEdges())) {
            MapSequence.fromMap(edgeMap).put(edge, copy.connect((INode)MapSequence.fromMap(nodeMap).get(edge.getSource()), (INode)MapSequence.fromMap(nodeMap).get(edge.getTarget())));
        }
        EdgesHistoryManager historyManager = new EdgesHistoryManager(copy);
        BiconnectAugmentation.smartMakeBiconnected(copy);
        EmbeddedGraph embeddedGraph = new ShortestPathEmbeddingFinder(new PQPlanarizationFinder()).find(copy);
        IMapSequence history = MapSequence.fromMap(new HashMap());
        for (Edge edge : ListSequence.fromList(graph.getEdges())) {
            Edge copyEdge = (Edge)MapSequence.fromMap(edgeMap).get(edge);
            MapSequence.fromMap(history).put(edge, historyManager.getHistory(copyEdge));
            if (copyEdge.getSource() == MapSequence.fromMap(nodeMap).get(edge.getSource())) continue;
            MapSequence.fromMap(history).put(edge, ListSequence.fromList((List)MapSequence.fromMap(history).get(edge)).reversedList());
        }
        IMapSequence<Node, List<Node>> newNodes = MapSequence.fromMap(new HashMap());
        IMapSequence<Edge, Edge> replacedEdges = MapSequence.fromMap(new HashMap());
        Set<Edge> newEdges = new EmbeddedGraphModifier(embeddedGraph).reduceNodesDegree(newNodes, replacedEdges);
        for (List list : Sequence.fromIterable(MapSequence.fromMap(history).values())) {
            Edge first = (Edge)ListSequence.fromList(list).first();
            if (MapSequence.fromMap(replacedEdges).containsKey(first)) {
                ListSequence.fromList(list).setElement(0, (Edge)MapSequence.fromMap(replacedEdges).get(first));
            }
            if (ListSequence.fromList(list).count() <= 1) continue;
            Edge last = (Edge)ListSequence.fromList(list).last();
            if (!MapSequence.fromMap(replacedEdges).containsKey(last)) continue;
            ListSequence.fromList(list).setElement(ListSequence.fromList(list).count() - 1, (Edge)MapSequence.fromMap(replacedEdges).get(last));
        }
        IMapSequence<Node, List<Node>> nodesToSplit = MapSequence.fromMap(new LinkedHashMap(16, 0.75f, false));
        IMapSequence<Node, Dimension> copyNodeSizes = MapSequence.fromMap(new HashMap());
        for (Node node : ListSequence.fromList(graph.getNodes())) {
            Iterator copyNode = (Node)MapSequence.fromMap(nodeMap).get(node);
            if (!MapSequence.fromMap(newNodes).containsKey(copyNode)) {
                MapSequence.fromMap(nodesToSplit).put(copyNode, ListSequence.fromList(new ArrayList()));
            } else {
                MapSequence.fromMap(nodesToSplit).put(copyNode, (List)MapSequence.fromMap(newNodes).get(copyNode));
            }
            MapSequence.fromMap(copyNodeSizes).put(copyNode, (Dimension)MapSequence.fromMap(nodeSizes).get(node));
        }
        GraphLayout copyLayout = this.getFlowLayout(embeddedGraph, newEdges, nodesToSplit, copyNodeSizes, historyManager);
        GraphLayout graphLayout = GraphLayoutFactory.createGraphLayout(graph);
        for (Node node : ListSequence.fromList(graph.getNodes())) {
            Node copyNode = (Node)MapSequence.fromMap(nodeMap).get(node);
            graphLayout.setLayoutFor(node, new Rectangle(copyLayout.getNodeLayout(copyNode)));
        }
        for (Edge graphEdge : ListSequence.fromList(graph.getEdges())) {
            Node firstSource;
            IListSequence<Point> edgeLayout = ListSequence.fromList(new ArrayList());
            List edgeHistory = (List)MapSequence.fromMap(history).get(graphEdge);
            Node copySource = (Node)MapSequence.fromMap(nodeMap).get(graphEdge.getSource());
            Node cur = copySource == (firstSource = ((Edge)ListSequence.fromList(edgeHistory).first()).getSource()) || ListSequence.fromList((List)MapSequence.fromMap(newNodes).get(copySource)).contains(firstSource) ? firstSource : ((Edge)ListSequence.fromList(edgeHistory).first()).getTarget();
            for (Edge edge : ListSequence.fromList(edgeHistory)) {
                if (cur == edge.getSource()) {
                    ListSequence.fromList(edgeLayout).addSequence((ISequence)ListSequence.fromList(copyLayout.getEdgeLayout(edge)));
                } else {
                    ListSequence.fromList(edgeLayout).addSequence((ISequence)ListSequence.fromList(copyLayout.getEdgeLayout(edge)).reversedList());
                }
                cur = edge.getOpposite(cur);
            }
            graphLayout.setLayoutFor(graphEdge, edgeLayout);
        }
        Rectangle containingRect = graphLayout.getContainingRectangle();
        graphLayout = graphLayout.shift(20 - containingRect.x, 20 - containingRect.y);
        return graphLayout;
    }

    public GraphLayout getFlowLayout(EmbeddedGraph embeddedGraph, Set<Edge> edgesToBeStraight, Map<Node, List<Node>> nodeMap, Map<Node, Dimension> nodeSizes, EdgesHistoryManager historyManager) {
        EmbeddedGraphModifier modifier = new EmbeddedGraphModifier(embeddedGraph);
        Graph graph = embeddedGraph.getGraph();
        IListSequence oldEdges = ListSequence.fromList(new ArrayList());
        ListSequence.fromList(oldEdges).addSequence((ISequence)ListSequence.fromList(graph.getEdges()));
        IMapSequence<Dart, Integer> bends = MapSequence.fromMap(new HashMap());
        IMapSequence<Dart, Integer> angles = MapSequence.fromMap(new HashMap());
        OrthogonalRepresentation.getRepresentation(embeddedGraph, edgesToBeStraight, bends, angles);
        if (SHOW_lOG > 0) {
            System.out.println("bends:");
            System.out.println(bends);
        }
        OrthogonalRepresentation.replaceBendsByNodes(embeddedGraph, bends, angles);
        Map<Dart, Direction2D> directions = OrthogonalRepresentation.getDirections(embeddedGraph, angles);
        modifier.setDartDirections(directions);
        Map<Edge, Edge> modifiedEdges = modifier.makeRectanglesForNodes(nodeMap);
        for (Object edge : SetSequence.fromSet(MapSequence.fromMap(modifiedEdges).keySet())) {
            Edge newEdge = (Edge)MapSequence.fromMap(modifiedEdges).get(edge);
            if (!MapSequence.fromMap(modifiedEdges).containsKey(newEdge)) continue;
            MapSequence.fromMap(modifiedEdges).put(edge, (Edge)MapSequence.fromMap(modifiedEdges).get(newEdge));
        }
        modifier.makeRectangularFaces();
        modifier.makerInnerFaces();
        IMapSequence<Edge, Integer> nodeBorderLengths = MapSequence.fromMap(new HashMap());
        for (Node node : SetSequence.fromSet(MapSequence.fromMap(nodeMap).keySet())) {
            for (Dart dart : ListSequence.fromList(modifier.getNodeFace(node).getDarts())) {
                Edge edge = dart.getEdge();
                if (((Direction2D)((Object)MapSequence.fromMap(directions).get(dart))).isHorizontal()) {
                    MapSequence.fromMap(nodeBorderLengths).put(edge, ((Dimension)MapSequence.fromMap(nodeSizes).get((Object)node)).width);
                    continue;
                }
                MapSequence.fromMap(nodeBorderLengths).put(edge, ((Dimension)MapSequence.fromMap(nodeSizes).get((Object)node)).height);
            }
        }
        Map<Edge, Integer> lengths = new EdgeLengthComputer().compute(embeddedGraph, directions, nodeBorderLengths);
        Map<Node, Point> coordinates = new CoordinatePlacer(embeddedGraph, lengths, directions).getCoordinates();
        GraphLayout nodesLayout = GraphLayoutFactory.createGraphLayout(graph);
        for (Node node : SetSequence.fromSet(MapSequence.fromMap(nodeMap).keySet())) {
            Node[] corners = modifier.getCornerNodes(node);
            Rectangle rect = GeomUtil.getRectangle((Point)MapSequence.fromMap(coordinates).get(corners[0]), (Point)MapSequence.fromMap(coordinates).get(corners[2]));
            nodesLayout.setLayoutFor(node, rect);
        }
        for (Edge edge : ListSequence.fromList(oldEdges)) {
            IListSequence history = ListSequence.fromList(new LinkedList());
            for (Edge historyEdge : ListSequence.fromList(historyManager.getHistory(edge))) {
                if (MapSequence.fromMap(modifiedEdges).containsKey(historyEdge)) {
                    ListSequence.fromList(history).addElement((Edge)MapSequence.fromMap(modifiedEdges).get(historyEdge));
                    continue;
                }
                ListSequence.fromList(history).addElement(historyEdge);
            }
            IListSequence<Point> edgeLayout = ListSequence.fromList(new ArrayList());
            Node cur = ((Edge)ListSequence.fromList(history).first()).getSource();
            ListSequence.fromList(edgeLayout).addElement((Point)MapSequence.fromMap(coordinates).get(cur));
            for (Edge historyEdge : ListSequence.fromList(history)) {
                Node next = historyEdge.getOpposite(cur);
                ListSequence.fromList(edgeLayout).addElement((Point)MapSequence.fromMap(coordinates).get(next));
                cur = next;
            }
            nodesLayout.setLayoutFor(edge, edgeLayout);
        }
        return nodesLayout;
    }
}

