/*
 * Decompiled with CFR 0.152.
 */
package com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.internal.flowOrthogonalLayout;

import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Edge;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Graph;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.IEdge;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.INode;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Node;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graphLayout.GraphLayout;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graphLayout.GraphLayoutFactory;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.intGeom2D.Dimension;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.intGeom2D.Direction2D;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.intGeom2D.OrthogonalUtil;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.intGeom2D.Point;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.intGeom2D.Rectangle;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.intGeom2D.Util1D;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.internal.flowOrthogonalLayout.OrthogonalFlowLayouterConstraints;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.IListSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.IMapSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ISetSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ListSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.MapSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.SetSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.backports.LinkedList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class TestPullingLabels {
    private int myUnitLength = 20;

    public GraphLayout doLayout(Graph graph, Map<Node, Dimension> nodeSizes, Map<Edge, Dimension> edgeSizes) {
        OrthogonalFlowLayouterConstraints flowLayouterConstraints = new OrthogonalFlowLayouterConstraints();
        flowLayouterConstraints.setUnitLength(this.myUnitLength);
        GraphLayout layout = flowLayouterConstraints.doLayout(graph, nodeSizes);
        IMapSequence<Edge, Integer> labeledSegment = MapSequence.fromMap(new HashMap());
        for (Edge edge : SetSequence.fromSet(MapSequence.fromMap(edgeSizes).keySet())) {
            layout = this.addEdgeLabel(layout, edge, (Dimension)MapSequence.fromMap(edgeSizes).get(edge), labeledSegment);
        }
        Rectangle rect = layout.getContainingRectangle();
        layout = layout.shift(20 - rect.x, 20 - rect.y);
        return layout;
    }

    private GraphLayout addEdgeLabel(GraphLayout layout, Edge edge, Dimension labelSize, Map<Edge, Integer> labeledSegments) {
        Rectangle rect;
        int dist;
        int length;
        Iterable path = layout.getEdgeLayout(edge);
        int begin = 0;
        int end = ListSequence.fromList(path).count() - 1;
        if (this.wasSplitted(layout, edge.getSource(), edge)) {
            ++begin;
        }
        if (this.wasSplitted(layout, edge.getTarget(), edge)) {
            --end;
        }
        int middle = (begin + end) / 2;
        Point first = (Point)ListSequence.fromList(path).getElement(middle);
        Point second = (Point)ListSequence.fromList(path).getElement(middle + 1);
        Point center = new Point((first.x + second.x) / 2, (first.y + second.y) / 2);
        Direction2D dir = OrthogonalUtil.getDirection(first, second);
        int width = labelSize.width;
        int height = labelSize.height;
        if (dir.isVertical()) {
            width = labelSize.height;
            height = labelSize.width;
        }
        if ((length = Math.abs(first.x - second.x) + Math.abs(first.y - second.y)) < width + this.myUnitLength) {
            int shift = (width + this.myUnitLength - length) / 2;
            layout = this.pullGraphLayout(layout, dir, shift, center, labeledSegments, true);
            layout = this.pullGraphLayout(layout, dir.opposite(), shift, center, labeledSegments, true);
        }
        if ((dist = this.getMinDist(layout, rect = this.getRectangle(labelSize, center, dir), dir)) < height + this.myUnitLength) {
            Direction2D shiftDir = Direction2D.RIGHT;
            if (dir.isHorizontal()) {
                shiftDir = Direction2D.UP;
            }
            int shift = height + this.myUnitLength - dist;
            layout = this.pullGraphLayout(layout, shiftDir, shift, center, labeledSegments, false);
        }
        MapSequence.fromMap(labeledSegments).put(edge, middle);
        layout.setLabelLayout(edge, rect);
        return layout;
    }

    public int getMinDist(GraphLayout layout, Rectangle rect, Direction2D dir) {
        Point[] points;
        Rectangle nodeRect;
        int minDist = Integer.MAX_VALUE;
        for (INode node : SetSequence.fromSet(MapSequence.fromMap(layout.getNodeLayout()).keySet())) {
            nodeRect = layout.getNodeLayout(node);
            for (Point point : points = nodeRect.getCornerPoints()) {
                if (!rect.contains(point)) continue;
                minDist = Math.min(minDist, this.getDist(rect, point, dir));
            }
        }
        for (IEdge edge : SetSequence.fromSet(MapSequence.fromMap(layout.getLabelLayout()).keySet())) {
            nodeRect = layout.getLabelLayout(edge);
            for (Point point : points = nodeRect.getCornerPoints()) {
                if (!rect.contains(point)) continue;
                minDist = Math.min(minDist, this.getDist(rect, point, dir));
            }
        }
        for (IEdge edge : SetSequence.fromSet(MapSequence.fromMap(layout.getEdgeLayout()).keySet())) {
            Iterable points2 = layout.getEdgeLayout(edge);
            for (Point point : points2) {
                if (!rect.contains(point)) continue;
                minDist = Math.min(minDist, this.getDist(rect, point, dir));
            }
        }
        return minDist;
    }

    public int getDist(Rectangle rect, Point point, Direction2D dir) {
        if (dir.isHorizontal()) {
            return point.y - rect.y;
        }
        return point.x - rect.x;
    }

    public Rectangle getRectangle(Dimension size, Point center, Direction2D dir) {
        if (dir.isVertical()) {
            return new Rectangle(center.x, center.y - size.height / 2, size.width, size.height);
        }
        return new Rectangle(center.x - size.width / 2, center.y, size.width, size.height);
    }

    public GraphLayout pullGraphLayout(GraphLayout layout, Direction2D direction, int shift, Point center, Map<Edge, Integer> labeledSegments, boolean alongEdge) {
        GraphLayout pulledLayout = GraphLayoutFactory.createGraphLayout(layout.getGraph());
        ISetSequence unpulledNodes = SetSequence.fromSet(new HashSet());
        for (INode node : SetSequence.fromSet(MapSequence.fromMap(layout.getNodeLayout()).keySet())) {
            Node myNode = (Node)node;
            Rectangle nodeRect = layout.getNodeLayout(myNode);
            Rectangle pulledRect = this.pullRectangle(nodeRect, center, direction, shift, alongEdge);
            if (pulledRect.equals(nodeRect)) {
                SetSequence.fromSet(unpulledNodes).addElement(myNode);
            }
            pulledLayout.setLayoutFor(node, pulledRect);
        }
        for (IEdge edge : SetSequence.fromSet(MapSequence.fromMap(layout.getEdgeLayout()).keySet())) {
            Edge myEdge = (Edge)edge;
            Iterable path = layout.getEdgeLayout(edge);
            IListSequence<Point> pulledPath = ListSequence.fromList(new LinkedList());
            ISetSequence pulled = SetSequence.fromSet(new HashSet());
            int index = 0;
            for (Point point : ListSequence.fromList(path)) {
                if (point == ListSequence.fromList(path).first() || point == ListSequence.fromList(path).last()) {
                    Node node = myEdge.getSource();
                    if (point == ListSequence.fromList(path).last()) {
                        node = myEdge.getTarget();
                    }
                    if (SetSequence.fromSet(unpulledNodes).contains(node)) {
                        ListSequence.fromList(pulledPath).addElement(new Point(point));
                    } else {
                        SetSequence.fromSet(pulled).addElement(index);
                        int dx = direction.dx() * shift;
                        int dy = direction.dy() * shift;
                        ListSequence.fromList(pulledPath).addElement(new Point(point.x + dx, point.y + dy));
                    }
                } else {
                    Point newPoint = this.pullPoint(point, center, direction, shift);
                    if (!newPoint.equals(point)) {
                        SetSequence.fromSet(pulled).addElement(index);
                    }
                    ListSequence.fromList(pulledPath).addElement(newPoint);
                }
                ++index;
            }
            if (MapSequence.fromMap(labeledSegments).containsKey(myEdge)) {
                Rectangle rect = layout.getLabelLayout(edge);
                int seg = (Integer)MapSequence.fromMap(labeledSegments).get(myEdge);
                if (SetSequence.fromSet(pulled).contains(seg) || SetSequence.fromSet(pulled).contains(seg + 1)) {
                    int dx = direction.dx() * shift;
                    int dy = direction.dy() * shift;
                    pulledLayout.setLabelLayout(myEdge, new Rectangle(rect.x + dx, rect.y + dy, rect.width, rect.height));
                } else {
                    pulledLayout.setLabelLayout(myEdge, new Rectangle(rect));
                }
            }
            pulledLayout.setLayoutFor(edge, pulledPath);
        }
        return pulledLayout;
    }

    public Point pullPoint(Point point, Point center, Direction2D direction, int shift) {
        int dx = direction.dx();
        int dy = direction.dy();
        if (direction.isHorizontal() && Util1D.getDirection(center.x, point.x) != dx) {
            return new Point(point);
        }
        if (direction.isVertical() && Util1D.getDirection(center.y, point.y) != dy) {
            return new Point(point);
        }
        dx = direction.dx() * shift;
        dy = direction.dy() * shift;
        return new Point(point.x + dx, point.y + dy);
    }

    public Rectangle pullRectangle(Rectangle rect, Point center, Direction2D direction, int shift, boolean alongEdge) {
        boolean notShift;
        boolean eq2;
        boolean eq1;
        int dx = direction.dx();
        int dy = direction.dy();
        if (direction.isHorizontal()) {
            eq1 = Util1D.getDirection(center.x, rect.x) != dx;
            eq2 = Util1D.getDirection(center.x, rect.x + rect.width) != dx;
        } else {
            eq1 = Util1D.getDirection(center.y, rect.y) != dy;
            boolean bl = eq2 = Util1D.getDirection(center.y, rect.y + rect.height) != dy;
        }
        if (alongEdge) {
            notShift = eq1 && eq2;
        } else {
            boolean bl = notShift = eq1 || eq2;
        }
        if (notShift) {
            return new Rectangle(rect);
        }
        dx = direction.dx() * shift;
        dy = direction.dy() * shift;
        return new Rectangle(rect.x + dx, rect.y + dy, rect.width, rect.height);
    }

    private boolean wasSplitted(GraphLayout layout, Node node, Edge edge) {
        Direction2D dir = this.getStartDirection(layout, node, edge);
        boolean wasSplitted = false;
        for (Edge sourceEdge : ListSequence.fromList(node.getEdges())) {
            if (sourceEdge == edge || this.getStartDirection(layout, node, sourceEdge) != dir) continue;
            wasSplitted = true;
        }
        return wasSplitted;
    }

    private Direction2D getStartDirection(GraphLayout layout, Node node, Edge edge) {
        Iterable path = layout.getEdgeLayout(edge);
        if (node == edge.getSource()) {
            return OrthogonalUtil.getDirection((Point)ListSequence.fromList(path).getElement(0), (Point)ListSequence.fromList(path).getElement(1));
        }
        int last = ListSequence.fromList(path).count() - 1;
        return OrthogonalUtil.getDirection((Point)ListSequence.fromList(path).getElement(last), (Point)ListSequence.fromList(path).getElement(last - 1));
    }
}

