/*
 * Decompiled with CFR 0.152.
 */
package com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.internal.planarization;

import com.vertabelo.autolayout_tool.repackaged.javaslang.Tuple;
import com.vertabelo.autolayout_tool.repackaged.javaslang.Tuple2;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.algorithms.ConnectivityComponents;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.ClusterNodesAdditionListener;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.ClusteredGraph;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Edge;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.EdgesHistoryManager;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Graph;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.GroupedGraphModificationSynchronizer;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.INode;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Node;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarGraph.CheckEmbeddedGraph;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarGraph.Dart;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarGraph.EmbeddedGraph;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarGraph.Face;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarization.EmbeddingFinderFactory;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarization.ShortestPathEmbeddingFinder;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.IListSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.IMapSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ListSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.MapSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.Sequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.SetSequence;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ClusterEmbeddingConstructorTemp {
    private static int debugMode = 1;
    private static int showInfo = 1;
    private ClusteredGraph myGraph;
    private Node myCluster;
    private Set<Node> myClusterNodes;
    private List<Edge> myOuterEdgesOrder;
    private Graph mySubclustersGraph;
    private EmbeddedGraph mySubEmbeddedGraph;
    private Map<INode, Node> mySubclustersMap;
    private EdgesHistoryManager myHistoryManager;
    private List<Edge> mySubClusterBorder;
    private EmbeddedGraph myEmbeddedGraph;
    private Map<Node, Node> myNodeMap;
    private Map<Face, Face> myFaceMap;
    private ClusterNodesAdditionListener myNodesAdditionListener;

    public ClusterEmbeddingConstructorTemp(ClusteredGraph graph, Node cluster, List<Edge> outerEdgesOrder) {
        this.myGraph = graph;
        this.myCluster = cluster;
        this.myClusterNodes = graph.getNodesInCluster(cluster);
        this.myOuterEdgesOrder = outerEdgesOrder;
        this.myHistoryManager = new EdgesHistoryManager(graph);
    }

    public EmbeddedGraph constructEmbedding() {
        Face realFace;
        List<Node> subclusters = this.myGraph.getSubclusters(this.myCluster);
        if (Sequence.fromIterable(subclusters).count() == 0) {
            return new EmbeddedGraph(this.myGraph);
        }
        this.myNodesAdditionListener = new ClusterNodesAdditionListener(this.myGraph);
        this.myNodesAdditionListener.setCurrentCluster(this.myCluster);
        Map<Edge, Edge> invEdgeMap = this.constructSubclusterGraphEmbedding();
        this.myGraph.removeListener(this.myNodesAdditionListener);
        if (showInfo > 0) {
            System.out.println("for cluster " + String.valueOf(this.myCluster) + " border is: " + String.valueOf(this.mySubClusterBorder));
        }
        this.myEmbeddedGraph = new EmbeddedGraph(this.myGraph);
        this.myFaceMap = MapSequence.fromMap(new HashMap());
        for (Edge edge : ListSequence.fromList(this.mySubClusterBorder)) {
            this.mySubEmbeddedGraph.removeEdge(edge);
        }
        for (Face face : ListSequence.fromList(this.mySubEmbeddedGraph.getFaces())) {
            realFace = new Face(this.myGraph);
            MapSequence.fromMap(this.myFaceMap).put(face, realFace);
            for (Dart dart : ListSequence.fromList(face.getDarts())) {
                Edge edge = dart.getEdge();
                Edge realEdge = (Edge)MapSequence.fromMap(invEdgeMap).get(edge);
                if (realEdge == null) {
                    throw new RuntimeException("wrong synchronized embedding");
                }
                Node source = dart.getSource();
                Node realSource = source == edge.getSource() ? realEdge.getSource() : realEdge.getTarget();
                realFace.addLast(new Dart(realEdge, realSource));
            }
        }
        for (Node subcluster : Sequence.fromIterable(subclusters)) {
            this.findSubclusterEmbedding(subcluster, invEdgeMap);
        }
        for (Face face : SetSequence.fromSet(MapSequence.fromMap(this.myFaceMap).keySet())) {
            realFace = (Face)MapSequence.fromMap(this.myFaceMap).get(face);
            this.myEmbeddedGraph.addFace(realFace);
            if (!this.mySubEmbeddedGraph.isOuterFace(face)) continue;
            this.myEmbeddedGraph.setOuterFace(realFace);
        }
        this.myGraph.removeListener(this.myNodesAdditionListener);
        return this.myEmbeddedGraph;
    }

    private void findSubclusterEmbedding(Node subcluster, Map<Edge, Edge> invEdgeMap) {
        Node node = (Node)MapSequence.fromMap(this.mySubclustersMap).get(subcluster);
        List<Dart> darts = this.mySubEmbeddedGraph.getOrderedDarts(node);
        IListSequence<Edge> subOuterEdgesOrder = ListSequence.fromList(new ArrayList(ListSequence.fromList(darts).count()));
        for (Dart dart : ListSequence.fromList(darts)) {
            Edge edge = dart.getEdge();
            Object realEdge = (Edge)MapSequence.fromMap(invEdgeMap).get(edge);
            List<Edge> history = this.myHistoryManager.getHistory((Edge)realEdge);
            realEdge = edge.getSource() == node ? (Edge)ListSequence.fromList(history).first() : (Edge)ListSequence.fromList(history).last();
            ListSequence.fromList(subOuterEdgesOrder).addElement((Edge)realEdge);
        }
        ClusterEmbeddingConstructorTemp subProcessor = new ClusterEmbeddingConstructorTemp(this.myGraph, subcluster, subOuterEdgesOrder);
        EmbeddedGraph subclusterEmbedding = subProcessor.constructEmbedding();
        CheckEmbeddedGraph.checkEmbeddedGraph(subclusterEmbedding, false);
        if (ListSequence.fromList(subclusterEmbedding.getFaces()).count() > 0) {
            Face outerFace = subclusterEmbedding.getOuterFace();
            for (Face face : ListSequence.fromList(subclusterEmbedding.getFaces())) {
                if (face == outerFace) continue;
                this.myEmbeddedGraph.addFace(face);
            }
            Edge lastOuterEdge = ((Dart)ListSequence.fromList(darts).last()).getEdge();
            Tuple2<Edge, Node> lastOuterEdgeInfo = this.getCurOuterEdge(lastOuterEdge, subclusterEmbedding);
            int i = 0;
            Dart prev = (Dart)ListSequence.fromList(darts).last();
            Edge prevCurOuterEdge = lastOuterEdgeInfo._1();
            Node prevBorderNode = lastOuterEdgeInfo._2();
            outerFace.makeEndsWith(prevBorderNode);
            Iterator borderItr = ListSequence.fromList(outerFace.getDarts()).reversedList().iterator();
            for (Dart dart : ListSequence.fromList(darts)) {
                Edge outerEdge = ListSequence.fromList(subOuterEdgesOrder).getElement(i);
                Tuple2<Edge, Node> outerEdgeInfo = this.getCurOuterEdge(outerEdge, subclusterEmbedding);
                Edge curOuterEdge = outerEdgeInfo._1();
                Node borderNode = outerEdgeInfo._2();
                Face face = (Face)MapSequence.fromMap(this.myFaceMap).get(this.mySubEmbeddedGraph.getFace(prev));
                List<Dart> faceDarts = face.getDarts();
                Dart outerEdgeDart = ListSequence.fromList(faceDarts).findFirst(_dart -> _dart.getEdge() == outerEdge);
                if (outerEdgeDart == null) {
                    throw new RuntimeException("error during merging subcluster's embeddings");
                }
                face.makeStartsWith(outerEdgeDart);
                ListSequence.fromList(faceDarts).removeElementAt(0);
                ListSequence.fromList(faceDarts).removeElementAt(0);
                ListSequence.fromList(faceDarts).insertElement(0, new Dart(prevCurOuterEdge, prevBorderNode));
                if (dart == ListSequence.fromList(darts).last()) {
                    while (borderItr.hasNext()) {
                        ListSequence.fromList(faceDarts).insertElement(0, (Dart)borderItr.next());
                    }
                } else if (prevBorderNode != borderNode) {
                    Dart cur = (Dart)borderItr.next();
                    while (cur.getSource() != borderNode) {
                        ListSequence.fromList(faceDarts).insertElement(0, cur);
                        cur = (Dart)borderItr.next();
                    }
                    ListSequence.fromList(faceDarts).insertElement(0, cur);
                }
                ListSequence.fromList(faceDarts).insertElement(0, new Dart(curOuterEdge, curOuterEdge.getOpposite(borderNode)));
                prev = dart;
                prevCurOuterEdge = curOuterEdge;
                prevBorderNode = borderNode;
            }
        }
    }

    private Tuple2<Edge, Node> getCurOuterEdge(Edge outerEdge, EmbeddedGraph embeddedGraph) {
        List<Edge> history = this.myHistoryManager.getHistory(outerEdge);
        Edge curOuterEdge = (Edge)ListSequence.fromList(history).first();
        if (embeddedGraph.getDarts(curOuterEdge) == null) {
            return Tuple.of(curOuterEdge, curOuterEdge.getTarget());
        }
        curOuterEdge = (Edge)ListSequence.fromList(history).last();
        return Tuple.of(curOuterEdge, curOuterEdge.getSource());
    }

    private Map<Edge, Edge> constructSubclusterGraphEmbedding() {
        Node target;
        this.mySubclustersGraph = new Graph();
        IMapSequence<Node, Node> nodeMap = MapSequence.fromMap(new HashMap());
        this.mySubclustersMap = MapSequence.fromMap(new HashMap());
        List<Node> subclusters = this.myGraph.getSubclusters(this.myCluster);
        for (Node node : ListSequence.fromList(subclusters)) {
            Node node2 = this.mySubclustersGraph.createNode();
            for (Node node3 : this.myGraph.getNodesInCluster(node)) {
                MapSequence.fromMap(nodeMap).put(node3, node2);
            }
            MapSequence.fromMap(this.mySubclustersMap).put(node, node2);
        }
        IMapSequence<Edge, Edge> invEdgeMap = MapSequence.fromMap(new HashMap());
        for (Node node : SetSequence.fromSet(this.myClusterNodes)) {
            for (Edge edge : node.getOutEdges()) {
                target = edge.getTarget();
                if (!SetSequence.fromSet(this.myClusterNodes).contains(target) || MapSequence.fromMap(nodeMap).get(node) == MapSequence.fromMap(nodeMap).get(target)) continue;
                Edge newEdge = this.mySubclustersGraph.connect((INode)MapSequence.fromMap(nodeMap).get(node), (INode)MapSequence.fromMap(nodeMap).get(target));
                MapSequence.fromMap(invEdgeMap).put(newEdge, edge);
            }
        }
        Set<Edge> set = ConnectivityComponents.makeConnected(this.mySubclustersGraph);
        for (Edge edge : SetSequence.fromSet(set)) {
            Node source = this.getRealNode(edge.getSource(), nodeMap);
            target = this.getRealNode(edge.getTarget(), nodeMap);
            Edge realEdge = this.myGraph.connect(source, target);
            MapSequence.fromMap(invEdgeMap).put(edge, realEdge);
        }
        GroupedGraphModificationSynchronizer groupedGraphModificationSynchronizer = new GroupedGraphModificationSynchronizer(this.mySubclustersGraph, this.myGraph, invEdgeMap);
        this.mySubEmbeddedGraph = EmbeddingFinderFactory.getFinder().find(this.mySubclustersGraph);
        if (ListSequence.fromList(this.myOuterEdgesOrder).count() > 0) {
            this.mySubclustersGraph.removeListener(groupedGraphModificationSynchronizer);
            IListSequence subClusterBorder = ListSequence.fromList(new ArrayList(ListSequence.fromList(this.myOuterEdgesOrder).count()));
            this.mySubClusterBorder = ListSequence.fromList(new ArrayList(ListSequence.fromList(this.myOuterEdgesOrder).count()));
            IListSequence subOuterEdges = ListSequence.fromList(new ArrayList(ListSequence.fromList(this.myOuterEdgesOrder).count()));
            IListSequence realBorderNodes = ListSequence.fromList(new ArrayList(ListSequence.fromList(this.myOuterEdgesOrder).count()));
            IListSequence subBorderNodes = ListSequence.fromList(new ArrayList(ListSequence.fromList(this.myOuterEdgesOrder).count()));
            for (Edge outerEdge : ListSequence.fromList(this.myOuterEdgesOrder)) {
                Node realClusterNode = this.getClusterNode(outerEdge);
                boolean isSource = realClusterNode == outerEdge.getSource();
                Node subBorderNode = this.mySubclustersGraph.createNode();
                ListSequence.fromList(subBorderNodes).addElement(subBorderNode);
                Edge subOuterEdge = isSource ? this.mySubclustersGraph.connect((INode)MapSequence.fromMap(nodeMap).get(realClusterNode), subBorderNode) : this.mySubclustersGraph.connect(subBorderNode, (INode)MapSequence.fromMap(nodeMap).get(realClusterNode));
                MapSequence.fromMap(invEdgeMap).put(subOuterEdge, outerEdge);
                ListSequence.fromList(subOuterEdges).addElement(subOuterEdge);
            }
            Face outerFace = new Face(this.mySubclustersGraph);
            for (int i = 0; i < ListSequence.fromList(this.myOuterEdgesOrder).count(); ++i) {
                int next = i + 1;
                if (next == ListSequence.fromList(this.myOuterEdgesOrder).count()) {
                    next = 0;
                }
                Edge subBorderEdge = this.mySubclustersGraph.connect((INode)ListSequence.fromList(subBorderNodes).getElement(i), (INode)ListSequence.fromList(subBorderNodes).getElement(next));
                ListSequence.fromList(subClusterBorder).addElement(subBorderEdge);
                ListSequence.fromList(this.mySubClusterBorder).addElement(subBorderEdge);
                outerFace.addLast(new Dart(subBorderEdge, (Node)ListSequence.fromList(subBorderNodes).getElement(next)));
            }
            Node borderFirstNode = (Node)ListSequence.fromList(subBorderNodes).first();
            Edge bridge = (Edge)ListSequence.fromList(subOuterEdges).first();
            Node clusterFirstNode = bridge.getOpposite(borderFirstNode);
            Face clusterOuterFace = this.mySubEmbeddedGraph.findContainingFace(ListSequence.fromListAndArray(new ArrayList(), clusterFirstNode));
            Face ringFace = new Face(this.mySubclustersGraph);
            ringFace.addLast(new Dart(bridge, clusterFirstNode));
            for (Edge edge : ListSequence.fromList(subClusterBorder)) {
                ringFace.addLast(new Dart(edge, edge.getSource()));
            }
            ringFace.addLast(new Dart(bridge, borderFirstNode));
            for (Dart dart : ListSequence.fromList(clusterOuterFace.getDarts())) {
                ringFace.addLast(dart);
            }
            this.mySubEmbeddedGraph.removeFace(clusterOuterFace);
            this.mySubEmbeddedGraph.addFace(ringFace);
            this.mySubEmbeddedGraph.addFace(outerFace);
            this.mySubEmbeddedGraph.setOuterFace(outerFace);
            if (debugMode > 0) {
                CheckEmbeddedGraph.checkEmbeddedGraph(this.mySubEmbeddedGraph, false);
            }
            GroupedGraphModificationSynchronizer groupedGraphModificationSynchronizer2 = new GroupedGraphModificationSynchronizer(this.mySubclustersGraph, this.myGraph, invEdgeMap);
            for (Edge edge : ListSequence.fromList(subOuterEdges)) {
                if (edge == ListSequence.fromList(subOuterEdges).first()) continue;
                this.mySubclustersGraph.removeEdge(edge);
                ShortestPathEmbeddingFinder.restoreEdge(this.mySubEmbeddedGraph, edge, true);
            }
        }
        this.myNodeMap = nodeMap;
        return invEdgeMap;
    }

    private Node getRealNode(Node subNode, Map<Node, Node> nodeMap) {
        return SetSequence.fromSet(this.myClusterNodes).findFirst(it -> MapSequence.fromMap(nodeMap).get(it) == subNode);
    }

    private Node getClusterNode(Edge edge) {
        boolean isTarget;
        boolean isSource = SetSequence.fromSet(this.myClusterNodes).contains(edge.getSource());
        if (isSource == (isTarget = SetSequence.fromSet(this.myClusterNodes).contains(edge.getTarget()))) {
            throw new RuntimeException(String.valueOf(edge) + " is not outer for cluster " + String.valueOf(this.myCluster));
        }
        if (isSource) {
            return edge.getSource();
        }
        return edge.getTarget();
    }

    public List<Edge> getClusterBorder() {
        return this.mySubClusterBorder;
    }
}

