/*
 * Decompiled with CFR 0.152.
 */
package com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.layeredLayout;

import com.vertabelo.autolayout_tool.repackaged.javaslang.Function2;
import com.vertabelo.autolayout_tool.repackaged.mps.baseLanguage.closures.runtime.Wrappers;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Edge;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Graph;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Node;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.intGeom2D.Point;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.layeredLayout.BlockGraphProcessor;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.layeredLayout.ICoordinatePlacer;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.layeredLayout.NodeLayeredOrder;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.util.NodeMap;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.IListSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ISelector;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ISetSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ListSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.MapSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.SetSequence;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BKCoordinatePlacer
implements ICoordinatePlacer {
    private static int LEFTMOST = 0;
    private static int RIGHTMOST = 1;
    private static int TOP_TO_BOTTOM = 0;
    private static int BOTTOM_TO_TOP = 1;
    private Graph myGraph;
    private NodeLayeredOrder myOrder;
    private Map<Node, Integer> myPosInLayer;
    private Map<Node, Integer> myNumLayer;
    private Map<Node, Node> myBlocks;
    private Set<Edge> badEdges;

    @Override
    public Map<Node, Point> placeCoordinates(Graph graph, NodeLayeredOrder order) {
        this.myGraph = graph;
        this.myOrder = order;
        this.init();
        IListSequence xCoords = ListSequence.fromList(new ArrayList());
        ListSequence.fromList(xCoords).addElement(this.computeCoords(TOP_TO_BOTTOM, LEFTMOST));
        ListSequence.fromList(xCoords).addElement(this.computeCoords(TOP_TO_BOTTOM, RIGHTMOST));
        ListSequence.fromList(xCoords).addElement(this.computeCoords(BOTTOM_TO_TOP, LEFTMOST));
        ListSequence.fromList(xCoords).addElement(this.computeCoords(BOTTOM_TO_TOP, RIGHTMOST));
        IListSequence maxCoord = ListSequence.fromList(new ArrayList());
        int minMaxCoord = Integer.MAX_VALUE;
        Iterable nodes = graph.getNodes();
        for (Map coords : ListSequence.fromList(xCoords)) {
            int curMaxCoord = 0;
            for (Node node : ListSequence.fromList(nodes)) {
                curMaxCoord = Math.max(curMaxCoord, (Integer)MapSequence.fromMap(coords).get(node));
            }
            minMaxCoord = Math.min(minMaxCoord, curMaxCoord);
            ListSequence.fromList(maxCoord).addElement(curMaxCoord);
        }
        IListSequence shifts = ListSequence.fromList(new ArrayList());
        for (int i = 0; i < ListSequence.fromList(xCoords).count(); ++i) {
            if (i % 2 == 0) {
                ListSequence.fromList(shifts).addElement(0);
                continue;
            }
            ListSequence.fromList(shifts).addElement(minMaxCoord - (Integer)ListSequence.fromList(maxCoord).getElement(i));
        }
        NodeMap finalXCoord = new NodeMap(graph);
        for (Iterator node : ListSequence.fromList(nodes)) {
            IListSequence<Object> nodeXCoords = ListSequence.fromList(new ArrayList());
            for (int i = 0; i < ListSequence.fromList(xCoords).count(); ++i) {
                ListSequence.fromList(nodeXCoords).addElement((Integer)MapSequence.fromMap((Map)ListSequence.fromList(xCoords).getElement(i)).get(node) + (Integer)ListSequence.fromList(shifts).getElement(i));
            }
            nodeXCoords = ListSequence.fromList(nodeXCoords).sort(new ISelector<Integer, Integer>(this){

                @Override
                public Integer select(Integer it) {
                    return it;
                }
            }, true).toListSequence();
            MapSequence.fromMap(finalXCoord).put(node, (Integer)ListSequence.fromList(nodeXCoords).getElement(1) + (Integer)ListSequence.fromList(nodeXCoords).getElement(2));
        }
        int minXCoord = Integer.MAX_VALUE;
        for (Node node : ListSequence.fromList(nodes)) {
            minXCoord = Math.min(minXCoord, (Integer)MapSequence.fromMap(finalXCoord).get(node));
        }
        for (Node node : ListSequence.fromList(nodes)) {
            MapSequence.fromMap(finalXCoord).put(node, (Integer)MapSequence.fromMap(finalXCoord).get(node) - minXCoord);
        }
        NodeMap<Point> coord = new NodeMap<Point>(graph);
        for (Node node : ListSequence.fromList(nodes)) {
            MapSequence.fromMap(coord).put(node, new Point((Integer)MapSequence.fromMap(finalXCoord).get(node), (Integer)MapSequence.fromMap(this.myNumLayer).get(node)));
        }
        return coord;
    }

    private Map<Node, Integer> computeCoords(int orderDir, int layerDir) {
        Edge.Direction dir = orderDir == TOP_TO_BOTTOM ? Edge.Direction.BACK : Edge.Direction.FRONT;
        Map<Node, Node> roots = this.computeBlocks(this.getOrderIterator(this.myOrder, orderDir), dir, layerDir);
        Graph blockGraph = this.createBlockGraph(this.getOrderIterator(this.myOrder, orderDir), roots, layerDir);
        Map<Node, Integer> layers = new BlockGraphProcessor().process(blockGraph);
        NodeMap<Integer> curCoords = new NodeMap<Integer>(this.myGraph);
        if (layerDir == LEFTMOST) {
            for (Node node : ListSequence.fromList(this.myGraph.getNodes())) {
                MapSequence.fromMap(curCoords).put(node, (Integer)MapSequence.fromMap(layers).get(MapSequence.fromMap(this.myBlocks).get(MapSequence.fromMap(roots).get(node))));
            }
        } else {
            int maxCoord = 0;
            for (Node block : ListSequence.fromList(blockGraph.getNodes())) {
                maxCoord = Math.max(maxCoord, (Integer)MapSequence.fromMap(layers).get(block));
            }
            for (Node node : ListSequence.fromList(this.myGraph.getNodes())) {
                MapSequence.fromMap(curCoords).put(node, maxCoord - (Integer)MapSequence.fromMap(layers).get(MapSequence.fromMap(this.myBlocks).get(MapSequence.fromMap(roots).get(node))));
            }
        }
        return curCoords;
    }

    public Graph createBlockGraph(Iterator<List<Node>> orderIterator, Map<Node, Node> roots, int layerDirection) {
        Graph blockGraph = new Graph();
        this.myBlocks = MapSequence.fromMap(new HashMap());
        while (orderIterator.hasNext()) {
            Node prevBlock = null;
            Iterator<Node> nodeIterator = this.getListIterator(orderIterator.next(), layerDirection);
            while (nodeIterator.hasNext()) {
                Node node = nodeIterator.next();
                if (MapSequence.fromMap(roots).get(node) == node) {
                    MapSequence.fromMap(this.myBlocks).put(node, blockGraph.createNode());
                }
                Node currentBlock = (Node)MapSequence.fromMap(this.myBlocks).get(MapSequence.fromMap(roots).get(node));
                if (prevBlock != null) {
                    blockGraph.connect(prevBlock, currentBlock);
                }
                prevBlock = currentBlock;
            }
        }
        return blockGraph;
    }

    public void init() {
        int layer;
        this.myPosInLayer = new NodeMap<Integer>(this.myGraph);
        this.myNumLayer = new NodeMap<Integer>(this.myGraph);
        for (layer = 0; layer < this.myOrder.getNumLayers(); ++layer) {
            List<Node> layerOrder = this.myOrder.getOrder(layer);
            for (int pos = 0; pos < ListSequence.fromList(layerOrder).count(); ++pos) {
                MapSequence.fromMap(this.myPosInLayer).put(ListSequence.fromList(layerOrder).getElement(pos), pos);
                MapSequence.fromMap(this.myNumLayer).put(ListSequence.fromList(layerOrder).getElement(pos), layer);
            }
        }
        this.badEdges = SetSequence.fromSet(new HashSet());
        for (layer = 0; layer < this.myOrder.getNumLayers() - 1; ++layer) {
            SetSequence.fromSet(this.badEdges).addSequence(SetSequence.fromSet(this.findBadEdgesInLayer(this.myOrder.getOrder(layer))));
        }
    }

    private Set<Edge> findBadEdgesInLayer(List<Node> layerOrder) {
        int targetPos;
        Node node;
        int i;
        ISetSequence<Edge> badEdges = SetSequence.fromSet(new HashSet());
        int closestInnerEdgePos = -1;
        for (i = 0; i < ListSequence.fromList(layerOrder).count(); ++i) {
            node = ListSequence.fromList(layerOrder).getElement(i);
            if (this.isInnerDummy(node)) {
                closestInnerEdgePos = this.getOppositePos(node);
                continue;
            }
            for (Edge edge : ListSequence.fromList(node.getOutEdges())) {
                targetPos = (Integer)MapSequence.fromMap(this.myPosInLayer).get(edge.getTarget());
                if (targetPos >= closestInnerEdgePos) continue;
                SetSequence.fromSet(badEdges).addElement(edge);
            }
        }
        closestInnerEdgePos = Integer.MAX_VALUE;
        for (i = ListSequence.fromList(layerOrder).count() - 1; i >= 0; --i) {
            node = ListSequence.fromList(layerOrder).getElement(i);
            if (this.isInnerDummy(node)) {
                closestInnerEdgePos = this.getOppositePos(node);
                continue;
            }
            for (Edge edge : ListSequence.fromList(node.getOutEdges())) {
                targetPos = (Integer)MapSequence.fromMap(this.myPosInLayer).get(edge.getTarget());
                if (targetPos <= closestInnerEdgePos) continue;
                SetSequence.fromSet(badEdges).addElement(edge);
            }
        }
        return badEdges;
    }

    private boolean isInnerDummy(Node node) {
        if (ListSequence.fromList(node.getOutEdges()).count() != 1) {
            return false;
        }
        Edge edge = (Edge)ListSequence.fromList(node.getOutEdges()).getElement(0);
        return edge.getSource().isDummy() && edge.getTarget().isDummy();
    }

    private int getOppositePos(Node dummyNode) {
        return (Integer)MapSequence.fromMap(this.myPosInLayer).get(((Edge)ListSequence.fromList(dummyNode.getOutEdges()).getElement(0)).getTarget());
    }

    private Iterator<Node> getListIterator(List<Node> nodeList, int direction) {
        if (direction == LEFTMOST) {
            return ListSequence.fromList(nodeList).iterator();
        }
        return ListSequence.fromList(nodeList).reversedList().iterator();
    }

    private Iterator<List<Node>> getOrderIterator(NodeLayeredOrder order, int direction) {
        if (direction == TOP_TO_BOTTOM) {
            return order.getTopToBottomIterator();
        }
        return order.getBottomToTopIterator();
    }

    public Map<Node, Node> computeBlocks(Iterator<List<Node>> layerIterator, Edge.Direction dir, int layerDirection) {
        int initPositionValue;
        NodeMap<Node> roots = new NodeMap<Node>(this.myGraph);
        for (Node node : ListSequence.fromList(this.myGraph.getNodes())) {
            MapSequence.fromMap(roots).put(node, node);
        }
        final Wrappers._T edgeComparator = new Wrappers._T();
        if (layerDirection == LEFTMOST) {
            edgeComparator.value = (a, b) -> (Integer)MapSequence.fromMap(this.myPosInLayer).get(a.getTarget(dir)) - (Integer)MapSequence.fromMap(this.myPosInLayer).get(b.getTarget(dir));
            initPositionValue = -1;
        } else {
            edgeComparator.value = (a, b) -> (Integer)MapSequence.fromMap(this.myPosInLayer).get(b.getTarget(dir)) - (Integer)MapSequence.fromMap(this.myPosInLayer).get(a.getTarget(dir));
            initPositionValue = Integer.MAX_VALUE;
        }
        layerIterator.next();
        while (layerIterator.hasNext()) {
            int curConnectedPos = initPositionValue;
            Iterator<Node> nodeIterator = this.getListIterator(layerIterator.next(), layerDirection);
            while (nodeIterator.hasNext()) {
                boolean hasDummy1;
                Node node = nodeIterator.next();
                if (ListSequence.fromList(node.getEdges(dir)).count() <= 0) continue;
                IListSequence<Edge> sortedByPos = ListSequence.fromList(node.getEdges(dir)).sort(new Comparator<Edge>(){

                    @Override
                    public int compare(Edge a, Edge b) {
                        return (Integer)((Function2)edgeComparator.value).apply(a, b);
                    }
                }, true).toListSequence();
                IListSequence candidates = ListSequence.fromList(new ArrayList());
                ListSequence.fromList(candidates).addElement(ListSequence.fromList(sortedByPos).getElement((ListSequence.fromList(sortedByPos).count() - 1) / 2));
                ListSequence.fromList(candidates).addElement(ListSequence.fromList(sortedByPos).getElement(ListSequence.fromList(sortedByPos).count() / 2));
                if (layerDirection != LEFTMOST) {
                    candidates = ListSequence.fromList(candidates).reversedList();
                }
                boolean hasDummy0 = ((Edge)ListSequence.fromList(candidates).getElement(0)).getSource().isDummy() || ((Edge)ListSequence.fromList(candidates).getElement(0)).getTarget().isDummy();
                boolean bl = hasDummy1 = ((Edge)ListSequence.fromList(candidates).getElement(1)).getSource().isDummy() || ((Edge)ListSequence.fromList(candidates).getElement(1)).getTarget().isDummy();
                if (hasDummy1 && !hasDummy0) {
                    candidates = ListSequence.fromList(candidates).reversedList();
                }
                for (Edge candidate : ListSequence.fromList(candidates)) {
                    if (MapSequence.fromMap(roots).get(node) != node) continue;
                    curConnectedPos = this.tryToAddRoot(node, roots, candidate, curConnectedPos, dir, layerDirection);
                }
            }
        }
        return roots;
    }

    private int tryToAddRoot(Node node, Map<Node, Node> roots, Edge edge, int curConnectedPos, Edge.Direction dir, int layerDirection) {
        boolean after;
        Node medianNode = edge.getTarget(dir);
        if (layerDirection == LEFTMOST) {
            after = (Integer)MapSequence.fromMap(this.myPosInLayer).get(medianNode) > curConnectedPos;
        } else {
            boolean bl = after = (Integer)MapSequence.fromMap(this.myPosInLayer).get(medianNode) < curConnectedPos;
        }
        if (!SetSequence.fromSet(this.badEdges).contains(edge) && after) {
            MapSequence.fromMap(roots).put(node, (Node)MapSequence.fromMap(roots).get(medianNode));
            curConnectedPos = (Integer)MapSequence.fromMap(this.myPosInLayer).get(medianNode);
        }
        return curConnectedPos;
    }
}

