/*
 * Decompiled with CFR 0.152.
 */
package com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.layeredLayout;

import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.algorithms.Dfs;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Edge;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Graph;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Node;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.util.NodeMap;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.IQueueSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ListSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.MapSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.QueueSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.backports.LinkedList;
import java.util.Map;

public class BlockGraphProcessor {
    private Map<Node, Integer> myClasses;
    private Map<Node, Integer> myNumInEdges;
    private int[] myShift;
    private int myMaxClass;
    private Map<Node, Integer> myLayers;

    public Map<Node, Integer> process(Graph blockGraph) {
        this.myMaxClass = 0;
        this.myClasses = new NodeMap<Integer>(blockGraph);
        this.myNumInEdges = new NodeMap<Integer>(blockGraph);
        ClassesFinder finder = new ClassesFinder();
        finder.doDfs(blockGraph);
        int curClass = 1;
        this.myShift = new int[this.myMaxClass + 1];
        this.myLayers = new NodeMap<Integer>(blockGraph);
        for (Node node : ListSequence.fromList(blockGraph.getNodes())) {
            if ((Integer)MapSequence.fromMap(this.myClasses).get(node) != curClass) continue;
            this.processClass(node);
            if (this.myShift[(Integer)MapSequence.fromMap(this.myClasses).get(node)] == Integer.MAX_VALUE) {
                this.myShift[((Integer)MapSequence.fromMap(this.myClasses).get((Object)node)).intValue()] = 0;
            }
            ++curClass;
        }
        int minPos = Integer.MAX_VALUE;
        for (Node node : ListSequence.fromList(blockGraph.getNodes())) {
            MapSequence.fromMap(this.myLayers).put(node, (Integer)MapSequence.fromMap(this.myLayers).get(node) + this.myShift[(Integer)MapSequence.fromMap(this.myClasses).get(node)]);
            minPos = Math.min(minPos, (Integer)MapSequence.fromMap(this.myLayers).get(node));
        }
        for (Node node : ListSequence.fromList(blockGraph.getNodes())) {
            MapSequence.fromMap(this.myLayers).put(node, (Integer)MapSequence.fromMap(this.myLayers).get(node) - minPos);
        }
        return this.myLayers;
    }

    private void processClass(Node node) {
        IQueueSequence queue = QueueSequence.fromQueue(new LinkedList());
        QueueSequence.fromQueue(queue).addLastElement(node);
        MapSequence.fromMap(this.myLayers).put(node, 0);
        int nodeClass = (Integer)MapSequence.fromMap(this.myClasses).get(node);
        this.myShift[nodeClass] = Integer.MAX_VALUE;
        while (QueueSequence.fromQueue(queue).count() > 0) {
            Node cur = (Node)QueueSequence.fromQueue(queue).removeFirstElement();
            for (Edge edge : ListSequence.fromList(cur.getOutEdges())) {
                Node target = edge.getTarget();
                if (MapSequence.fromMap(this.myClasses).get(node) == MapSequence.fromMap(this.myClasses).get(target)) {
                    MapSequence.fromMap(this.myNumInEdges).put(target, (Integer)MapSequence.fromMap(this.myNumInEdges).get(target) - 1);
                    if ((Integer)MapSequence.fromMap(this.myNumInEdges).get(target) != 0) continue;
                    MapSequence.fromMap(this.myLayers).put(target, (Integer)MapSequence.fromMap(this.myLayers).get(cur) + 1);
                    QueueSequence.fromQueue(queue).addLastElement(target);
                    continue;
                }
                this.myShift[nodeClass] = Math.min(this.myShift[nodeClass], (Integer)MapSequence.fromMap(this.myLayers).get(target) - (Integer)MapSequence.fromMap(this.myLayers).get(cur) - 1);
            }
        }
    }

    private class ClassesFinder
    extends Dfs {
        @Override
        protected void preprocess(Node node, Edge from) {
            MapSequence.fromMap(BlockGraphProcessor.this.myClasses).put(node, BlockGraphProcessor.this.myMaxClass);
        }

        @Override
        protected void processEdge(Edge edge, Node source) {
            Node target = edge.getTarget();
            if (MapSequence.fromMap(BlockGraphProcessor.this.myClasses).get(target) == null || MapSequence.fromMap(BlockGraphProcessor.this.myClasses).get(source) == MapSequence.fromMap(BlockGraphProcessor.this.myClasses).get(target)) {
                if (MapSequence.fromMap(BlockGraphProcessor.this.myNumInEdges).get(target) == null) {
                    MapSequence.fromMap(BlockGraphProcessor.this.myNumInEdges).put(target, 1);
                } else {
                    MapSequence.fromMap(BlockGraphProcessor.this.myNumInEdges).put(target, (Integer)MapSequence.fromMap(BlockGraphProcessor.this.myNumInEdges).get(target) + 1);
                }
            }
        }

        @Override
        protected void preprocessRoot(Node node) {
            ++BlockGraphProcessor.this.myMaxClass;
        }
    }
}

