/*
 * Decompiled with CFR 0.152.
 */
package com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.layeredLayout;

import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Edge;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Graph;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Node;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.layeredLayout.INodeSorter;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.layeredLayout.IOneLayerSorter;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.layeredLayout.NodeLayeredOrder;
import java.util.Map;

public class LayerByLayerNodeSorter
implements INodeSorter {
    private int myNumIterations = 51;
    private INodeSorter mySorter;
    private IOneLayerSorter myLayerSorter;

    public LayerByLayerNodeSorter(IOneLayerSorter layerSorter, INodeSorter initialSorter) {
        this.myLayerSorter = layerSorter;
        this.mySorter = initialSorter;
    }

    @Override
    public NodeLayeredOrder sortNodes(Graph graph, Map<Node, Integer> layers) {
        NodeLayeredOrder order = this.mySorter.sortNodes(graph, layers);
        for (int iteration = 0; iteration < this.myNumIterations; ++iteration) {
            int layer;
            if (iteration % 2 == 0) {
                for (layer = 0; layer < order.getNumLayers() - 1; ++layer) {
                    this.myLayerSorter.sortLayer(layer + 1, order, Edge.Direction.BACK);
                }
                continue;
            }
            for (layer = order.getNumLayers() - 1; layer > 0; --layer) {
                this.myLayerSorter.sortLayer(layer - 1, order, Edge.Direction.FRONT);
            }
        }
        return order;
    }

    public void setNumIterations(int numIterations) {
        this.myNumIterations = numIterations;
    }
}

