/*
 * Decompiled with CFR 0.152.
 */
package com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.layeredLayout;

import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Edge;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Graph;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Node;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graphLayout.GraphPointLayout;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graphLayout.IPointLayouter;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.intGeom2D.Point;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.layeredLayout.ICoordinatePlacer;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.layeredLayout.IEdgeReverter;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.layeredLayout.ILayerer;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.layeredLayout.INodeSorter;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.layeredLayout.NodeLayeredOrder;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.IListSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.IMapSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ListSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.MapSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.SetSequence;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class LayeredLayouter
implements IPointLayouter {
    private IEdgeReverter myReverter;
    private ILayerer myLayerer;
    private ICoordinatePlacer myPlacer;
    private INodeSorter mySorter;

    public LayeredLayouter(IEdgeReverter reverter, ILayerer layerer, ICoordinatePlacer placer, INodeSorter sorter) {
        this.mySorter = sorter;
        this.myPlacer = placer;
        this.myLayerer = layerer;
        this.myReverter = reverter;
    }

    @Override
    public GraphPointLayout doLayout(Graph graph) {
        Set<Edge> reverted = this.myReverter.revertEdges(graph);
        Map<Node, Integer> layers = this.myLayerer.computeLayers(graph);
        Map<Edge, List<Edge>> substituteEdgeMap = LayeredLayouter.insertDummyNodes(graph, layers);
        NodeLayeredOrder order = this.mySorter.sortNodes(graph, layers);
        Map<Node, Point> nodeCoordinates = this.myPlacer.placeCoordinates(graph, order);
        GraphPointLayout graphLayout = new GraphPointLayout(graph);
        for (Edge deletedEdge : SetSequence.fromSet(MapSequence.fromMap(substituteEdgeMap).keySet())) {
            IListSequence<Point> edgeLayout = ListSequence.fromList(new ArrayList());
            ListSequence.fromList(edgeLayout).addElement((Point)MapSequence.fromMap(nodeCoordinates).get(deletedEdge.getSource()));
            for (Edge newEdge : ListSequence.fromList((List)MapSequence.fromMap(substituteEdgeMap).get(deletedEdge))) {
                ListSequence.fromList(edgeLayout).addElement((Point)MapSequence.fromMap(nodeCoordinates).get(newEdge.getTarget()));
                graph.removeEdge(newEdge);
            }
            graphLayout.setLayoutFor(deletedEdge, edgeLayout);
            graph.addEdge(deletedEdge);
        }
        ListSequence.fromList(graph.getNodes()).removeWhere(it -> it.isDummy());
        for (Node node : ListSequence.fromList(graph.getNodes())) {
            graphLayout.setLayoutFor(node, (Point)MapSequence.fromMap(nodeCoordinates).get(node));
            for (Edge edge : ListSequence.fromList(node.getOutEdges())) {
                if (MapSequence.fromMap(substituteEdgeMap).containsKey(edge)) continue;
                graphLayout.setLayoutFor(edge, ListSequence.fromListAndArray(new ArrayList(), (Point)MapSequence.fromMap(nodeCoordinates).get(edge.getSource()), (Point)MapSequence.fromMap(nodeCoordinates).get(edge.getTarget())));
            }
        }
        return graphLayout;
    }

    public static Map<Edge, List<Edge>> insertDummyNodes(Graph graph, Map<Node, Integer> layers) {
        IMapSequence<Edge, List<Edge>> substituteMap = MapSequence.fromMap(new HashMap());
        int numOfRealNodes = graph.getNumNodes();
        for (int index = 0; index < numOfRealNodes; ++index) {
            Node node = graph.getNode(index);
            for (Edge edge : ListSequence.fromList(node.getOutEdges())) {
                int sourceLayer = (Integer)MapSequence.fromMap(layers).get(edge.getSource());
                int targetLayer = (Integer)MapSequence.fromMap(layers).get(edge.getTarget());
                if (targetLayer <= sourceLayer + 1) continue;
                MapSequence.fromMap(substituteMap).put(edge, ListSequence.fromList(new ArrayList()));
                Node cur = edge.getSource();
                for (int i = sourceLayer + 1; i <= targetLayer; ++i) {
                    Node newTarget;
                    if (i < targetLayer) {
                        newTarget = graph.createDummyNode();
                        MapSequence.fromMap(layers).put(newTarget, i);
                    } else {
                        newTarget = edge.getTarget();
                    }
                    ListSequence.fromList((List)MapSequence.fromMap(substituteMap).get(edge)).addElement(new Edge(cur, newTarget));
                    cur = newTarget;
                }
            }
        }
        for (Edge deletedEdge : SetSequence.fromSet(MapSequence.fromMap(substituteMap).keySet())) {
            graph.removeEdge(deletedEdge);
            for (Edge newEdge : ListSequence.fromList((List)MapSequence.fromMap(substituteMap).get(deletedEdge))) {
                graph.addEdge(newEdge);
            }
        }
        return substituteMap;
    }
}

