/*
 * Decompiled with CFR 0.152.
 */
package com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.layeredLayout;

import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Graph;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Node;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.util.NodeMap;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ListSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.MapSequence;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class NodeLayeredOrder {
    private List<List<Node>> myLayeredOrder;
    private Map<Node, Integer> myPosInLayer;
    private Graph myGraph;

    public NodeLayeredOrder(Graph graph) {
        this.myGraph = graph;
        this.myLayeredOrder = ListSequence.fromList(new ArrayList());
        this.myPosInLayer = new NodeMap<Integer>(graph);
    }

    public void addLast(Node node, int layer) {
        if (ListSequence.fromList(this.myLayeredOrder).count() <= layer) {
            for (int i = ListSequence.fromList(this.myLayeredOrder).count(); i <= layer; ++i) {
                ListSequence.fromList(this.myLayeredOrder).addElement(ListSequence.fromList(new ArrayList()));
            }
        }
        MapSequence.fromMap(this.myPosInLayer).put(node, ListSequence.fromList(ListSequence.fromList(this.myLayeredOrder).getElement(layer)).count());
        ListSequence.fromList(ListSequence.fromList(this.myLayeredOrder).getElement(layer)).addElement(node);
    }

    public void setLayer(List<Node> nodes, int layer) {
        ListSequence.fromList(this.myLayeredOrder).setElement(layer, nodes);
        for (int i = 0; i < ListSequence.fromList(nodes).count(); ++i) {
            MapSequence.fromMap(this.myPosInLayer).put(ListSequence.fromList(nodes).getElement(i), i);
        }
    }

    public void set(int layer, Node node, int pos) {
        ListSequence.fromList(ListSequence.fromList(this.myLayeredOrder).getElement(layer)).setElement(pos, node);
        MapSequence.fromMap(this.myPosInLayer).put(node, pos);
    }

    public Map<Node, Integer> getPosInLayer() {
        return this.myPosInLayer;
    }

    public List<Node> getOrder(int layer) {
        return ListSequence.fromList(this.myLayeredOrder).getElement(layer);
    }

    public int getNumLayers() {
        return ListSequence.fromList(this.myLayeredOrder).count();
    }

    public Graph getGraph() {
        return this.myGraph;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Node layered order: \n");
        for (List list : ListSequence.fromList(this.myLayeredOrder)) {
            for (Node node : ListSequence.fromList(list)) {
                builder.append(node.getIndex() + " ");
            }
            builder.append("\n");
        }
        builder.append("end order");
        return builder.toString();
    }

    public Iterator<List<Node>> getTopToBottomIterator() {
        return ListSequence.fromList(this.myLayeredOrder).iterator();
    }

    public Iterator<List<Node>> getBottomToTopIterator() {
        return ListSequence.fromList(this.myLayeredOrder).reversedList().iterator();
    }
}

