/*
 * Decompiled with CFR 0.152.
 */
package com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.outputUtil;

import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.intGeom2D.Point;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.intGeom2D.Rectangle;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ListSequence;
import java.awt.geom.Point2D;
import java.util.List;

public class GraphLayoutOutputUtil {
    public static Point2D getPointPosAlongRectBorder(Rectangle rect, Point p) {
        double x = -1.0;
        double y = -1.0;
        if (rect.x == p.x) {
            x = 0.0;
        }
        if (rect.x + rect.width == p.x) {
            x = 1.0;
        }
        if (rect.y == p.y) {
            y = 0.0;
        }
        if (rect.y + rect.height == p.y) {
            y = 1.0;
        }
        if (x < 0.0 && y < 0.0) {
            throw new RuntimeException("bad connection:" + String.valueOf(rect) + " " + String.valueOf(p));
        }
        if (x < 0.0) {
            x = 1.0 * (double)(p.x - rect.x) / (double)rect.width;
        }
        if (y < 0.0) {
            y = 1.0 * (double)(p.y - rect.y) / (double)rect.height;
        }
        Point2D.Double res = new Point2D.Double(x, y);
        return res;
    }

    public static Point2D getRectPosAlongPolyline(List<Point> route, Rectangle rect) {
        Point prev = null;
        int x = rect.x;
        int y = rect.y;
        Point res = null;
        int len = 0;
        int num = 0;
        for (Point next : ListSequence.fromList(route)) {
            int dist;
            if (prev == null || prev.equals(next)) {
                prev = next;
                continue;
            }
            ++num;
            if (prev.x == next.x && prev.x == x && (prev.y - y) * (next.y - y) < 0) {
                int yCenter = y + rect.height / 2;
                dist = rect.width / 2;
                if (prev.y > next.y) {
                    dist = -dist;
                }
                res = new Point(len + Math.abs(yCenter - prev.y), dist);
            }
            if (prev.y == next.y && prev.y == y && (prev.x - x) * (next.x - x) < 0) {
                int xCenter = x + rect.width / 2;
                dist = rect.height / 2;
                if (prev.x < next.x) {
                    dist = -dist;
                }
                res = new Point(len + Math.abs(xCenter - prev.x), dist);
            }
            len += prev.manhattanDist(next);
            prev = next;
        }
        if (res == null) {
            return null;
        }
        int l = len / 2;
        double relX = 1.0 * (double)Math.abs(res.x - l) / (double)l;
        if (res.x < l) {
            relX = -relX;
        }
        Point2D.Double point = new Point2D.Double(relX, res.y);
        return point;
    }
}

