/*
 * Decompiled with CFR 0.152.
 */
package com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarGraph;

import com.vertabelo.autolayout_tool.repackaged.com.google.common.base.Preconditions;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Edge;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Node;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarGraph.CheckFace;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarGraph.Dart;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarGraph.EmbeddedGraph;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarGraph.Face;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ISelector;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ISetSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ListSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.SetSequence;
import java.util.HashSet;
import java.util.List;

public class CheckEmbeddedGraph {
    public static boolean checkAdjacentFaces(EmbeddedGraph embeddedGraph) {
        for (Edge edge : SetSequence.fromSet(embeddedGraph.getEdges())) {
            if (ListSequence.fromList(embeddedGraph.getAdjacentFaces(edge)).count() == 2) continue;
            return false;
        }
        return true;
    }

    public static void checkEmbeddedGraph(EmbeddedGraph embeddedGraph, boolean isRegularFaces) {
        CheckEmbeddedGraph.checkAdjacentFaces(embeddedGraph);
        for (Face face : ListSequence.fromList(embeddedGraph.getFaces())) {
            if (!CheckFace.check(face) || isRegularFaces && ListSequence.fromList(face.getDarts()).count() < 3) {
                throw new RuntimeException("bad face: " + String.valueOf(face));
            }
            for (Dart dart : ListSequence.fromList(face.getDarts())) {
                if (embeddedGraph.getFace(dart) == face) continue;
                throw new RuntimeException("bad dart: " + String.valueOf(dart));
            }
        }
        for (Edge edge : ListSequence.fromList(embeddedGraph.getGraph().getEdges())) {
            List<Dart> darts = embeddedGraph.getDarts(edge);
            if (darts == null) continue;
            Preconditions.checkArgument(ListSequence.fromList(darts).count() == 2);
            ISetSequence sources = SetSequence.fromSet(new HashSet());
            SetSequence.fromSet(sources).addSequence(ListSequence.fromList(darts).select(new ISelector<Dart, Node>(){

                @Override
                public Node select(Dart it) {
                    return it.getSource();
                }
            }));
            Preconditions.checkArgument(SetSequence.fromSet(sources).contains(edge.getSource()));
            Preconditions.checkArgument(SetSequence.fromSet(sources).contains(edge.getTarget()));
        }
    }

    public static void checkFull(EmbeddedGraph embeddedGraph) {
        for (Edge edge : ListSequence.fromList(embeddedGraph.getGraph().getEdges())) {
            Preconditions.checkArgument(embeddedGraph.getAdjacentFaces(edge) != null);
        }
    }
}

