/*
 * Decompiled with CFR 0.152.
 */
package com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarGraph;

import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Edge;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Graph;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.INode;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Node;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarGraph.EmbeddedGraph;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarGraph.Face;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ListSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.MapSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.SetSequence;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DualGraph
extends Graph {
    private EmbeddedGraph myEmbeddedGraph;
    private Map<Node, Face> myFacesMap;
    private Map<Face, Node> myNodesMap;
    private Map<Edge, Edge> myEdgesMap;

    public DualGraph(EmbeddedGraph graph) {
        this.myEmbeddedGraph = graph;
        this.myEdgesMap = MapSequence.fromMap(new HashMap());
        this.compute();
    }

    private void compute() {
        this.myNodesMap = MapSequence.fromMap(new HashMap());
        this.myFacesMap = MapSequence.fromMap(new HashMap());
        for (Face face : ListSequence.fromList(this.myEmbeddedGraph.getFaces())) {
            Node node = this.createNode();
            MapSequence.fromMap(this.myNodesMap).put(face, node);
            MapSequence.fromMap(this.myFacesMap).put(node, face);
        }
        for (Edge edge : SetSequence.fromSet(this.myEmbeddedGraph.getEdges())) {
            List<Face> faces = this.myEmbeddedGraph.getAdjacentFaces(edge);
            Node faceNode1 = (Node)MapSequence.fromMap(this.myNodesMap).get(ListSequence.fromList(faces).getElement(0));
            Node faceNode2 = (Node)MapSequence.fromMap(this.myNodesMap).get(ListSequence.fromList(faces).getElement(1));
            Edge faceEdge = this.connect(faceNode1, faceNode2);
            MapSequence.fromMap(this.myEdgesMap).put(faceEdge, edge);
        }
    }

    public Node addRealNode(Node realNode) {
        Node newNode = this.createDummyNode();
        for (Edge edge : ListSequence.fromList(realNode.getEdges())) {
            for (Face face : ListSequence.fromList(this.myEmbeddedGraph.getAdjacentFaces(edge))) {
                this.connect(newNode, (INode)MapSequence.fromMap(this.getNodesMap()).get(face));
            }
        }
        return newNode;
    }

    public EmbeddedGraph getEmbeddedGraph() {
        return this.myEmbeddedGraph;
    }

    public Map<Node, Face> getFacesMap() {
        return this.myFacesMap;
    }

    public Map<Face, Node> getNodesMap() {
        return this.myNodesMap;
    }

    public Map<Edge, Edge> getEdgesMap() {
        return this.myEdgesMap;
    }

    public void removeFromGraph(Edge edge) {
        this.removeEdge(edge);
        MapSequence.fromMap(this.myEdgesMap).removeKey(edge);
    }

    public Edge addEdge(Node source, Node target, Edge realEdge) {
        Edge edge = this.connect(source, target);
        MapSequence.fromMap(this.myEdgesMap).put(edge, realEdge);
        return edge;
    }
}

