/*
 * Decompiled with CFR 0.152.
 */
package com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarGraph;

import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Edge;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Graph;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Node;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarGraph.Dart;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarGraph.Face;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.IListSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ISelector;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ListSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.MapSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.backports.LinkedList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class EmbeddedGraph {
    private List<Face> myFaces = ListSequence.fromList(new ArrayList());
    private Map<Edge, List<Face>> myAdjacentFacesMap = MapSequence.fromMap(new HashMap());
    private Map<Dart, Face> myDartsToFacesMap = MapSequence.fromMap(new HashMap());
    private Map<Edge, List<Dart>> myEdgeDarts = MapSequence.fromMap(new LinkedHashMap(16, 0.75f, false));
    private Graph myGraph;
    private Face myOuterFace;

    public EmbeddedGraph(Graph graph) {
        this.myGraph = graph;
    }

    public Face findContainingFace(List<Node> nodes) {
        Face containingFace = null;
        for (Face face : ListSequence.fromList(this.getFaces())) {
            if (!face.contains(nodes)) continue;
            if (this.isOuterFace(face)) {
                containingFace = face;
                continue;
            }
            return face;
        }
        return containingFace;
    }

    public Face getFaceToTheRight(Edge edge) {
        List<Dart> darts = this.getDarts(edge);
        for (Dart dart : ListSequence.fromList(darts)) {
            if (dart.getSource() != edge.getTarget()) continue;
            return this.getFace(dart);
        }
        return null;
    }

    public Face getFaceToTheLeft(Edge edge) {
        List<Dart> darts = this.getDarts(edge);
        for (Dart dart : ListSequence.fromList(darts)) {
            if (dart.getSource() != edge.getSource()) continue;
            return this.getFace(dart);
        }
        return null;
    }

    public Dart getSourceDart(Edge edge, Node source) {
        return ListSequence.fromList(this.getDarts(edge)).findFirst(dart -> dart.getSource() == source);
    }

    public Node splitEdge(Edge edge) {
        return this.splitEdge(edge, ListSequence.fromList(new ArrayList()));
    }

    public Node splitEdge(Edge edge, List<Edge> newEdges) {
        Graph originalGraph = this.getGraph();
        List<Edge> split = originalGraph.splitEdge(edge);
        ListSequence.fromList(newEdges).addSequence(ListSequence.fromList(split));
        Node newNode = ListSequence.fromList(split).getElement(0).getTarget();
        IListSequence facesToProcess = ListSequence.fromList(new ArrayList());
        ListSequence.fromList(facesToProcess).addSequence(ListSequence.fromList(this.getAdjacentFaces(edge)));
        List<Edge> addOrder = null;
        for (Face face : ListSequence.fromList(facesToProcess)) {
            List<Dart> darts = face.getDarts();
            int numDartsToRemove = ListSequence.fromList(darts).where(it -> it.getEdge() == edge).count();
            for (int dartNum = 0; dartNum < numDartsToRemove; ++dartNum) {
                int pos = 0;
                while (ListSequence.fromList(darts).getElement(pos).getEdge() != edge) {
                    ++pos;
                }
                Dart dartToReplace = ListSequence.fromList(darts).getElement(pos);
                if (addOrder == null) {
                    addOrder = newEdges;
                    if (dartToReplace.getSource() != edge.getSource()) {
                        addOrder = ListSequence.fromList(newEdges).reversedList();
                    }
                } else {
                    addOrder = ListSequence.fromList(addOrder).reversedList();
                }
                this.setDart(face, pos, new Dart(ListSequence.fromList(addOrder).getElement(0), dartToReplace.getSource()));
                this.insertDart(face, pos + 1, new Dart(ListSequence.fromList(addOrder).getElement(1), newNode));
            }
        }
        return newNode;
    }

    public List<Face> splitFace(Face face, List<Edge> path, Node start, Node end) {
        int i;
        int endSucc;
        int begSucc;
        Face split;
        Face succ;
        Graph originalGraph = this.getGraph();
        Face faceSToE = new Face(originalGraph);
        Face faceEToS = new Face(originalGraph);
        List<Dart> darts = face.getDarts();
        int posStart = -1;
        int posEnd = -1;
        for (int i2 = 0; i2 < ListSequence.fromList(darts).count(); ++i2) {
            Dart cur = ListSequence.fromList(darts).getElement(i2);
            if (cur.getSource() == start) {
                posStart = i2;
            }
            if (cur.getSource() != end) continue;
            posEnd = i2;
        }
        if (posEnd > posStart) {
            succ = faceEToS;
            split = faceSToE;
            begSucc = posStart;
            endSucc = posEnd;
        } else {
            succ = faceSToE;
            split = faceEToS;
            begSucc = posEnd;
            endSucc = posStart;
        }
        for (i = begSucc; i < endSucc; ++i) {
            succ.addLast(ListSequence.fromList(darts).getElement(i));
        }
        for (i = endSucc; i < ListSequence.fromList(darts).count(); ++i) {
            split.addLast(ListSequence.fromList(darts).getElement(i));
        }
        for (i = 0; i < begSucc; ++i) {
            split.addLast(ListSequence.fromList(darts).getElement(i));
        }
        Node cur = start;
        for (Edge edge : ListSequence.fromList(path)) {
            faceSToE.addLast(new Dart(edge, cur));
            cur = edge.getOpposite(cur);
        }
        cur = end;
        for (Edge edge : ListSequence.fromList(path).reversedList()) {
            faceEToS.addLast(new Dart(edge, cur));
            cur = edge.getOpposite(cur);
        }
        this.removeFace(face);
        this.addFace(faceEToS);
        this.addFace(faceSToE);
        if (this.isOuterFace(face)) {
            this.setOuterFace(split);
        }
        return ListSequence.fromListAndArray(new ArrayList(), faceSToE, faceEToS);
    }

    public Face makeLoop(Face face, List<Edge> loop, Node node) {
        face.makeEndsWith(node);
        for (Edge edge : ListSequence.fromList(loop)) {
            this.addLastDart(face, new Dart(edge, edge.getSource()));
        }
        Face newFace = new Face(this.getGraph());
        for (Edge edge : ListSequence.fromList(loop)) {
            newFace.addFirst(new Dart(edge, edge.getTarget()));
        }
        this.addFace(newFace);
        return newFace;
    }

    public void addFace(Face face) {
        ListSequence.fromList(this.myFaces).addElement(face);
        for (Dart dart : ListSequence.fromList(face.getDarts())) {
            this.adjustDart(dart, face);
        }
    }

    private void adjustDart(Dart dart, Face face) {
        MapSequence.fromMap(this.myDartsToFacesMap).put(dart, face);
        Edge edge = dart.getEdge();
        if (!MapSequence.fromMap(this.myEdgeDarts).containsKey(edge)) {
            MapSequence.fromMap(this.myEdgeDarts).put(edge, ListSequence.fromList(new ArrayList()));
        }
        ListSequence.fromList((List)MapSequence.fromMap(this.myEdgeDarts).get(edge)).addElement(dart);
    }

    public void removeFace(Face face) {
        ListSequence.fromList(this.myFaces).removeElement(face);
        for (Dart dart : ListSequence.fromList(face.getDarts())) {
            this.unadjustDart(dart);
        }
    }

    private void unadjustDart(Dart dart) {
        MapSequence.fromMap(this.myDartsToFacesMap).removeKey(dart);
        Edge edge = dart.getEdge();
        ListSequence.fromList((List)MapSequence.fromMap(this.myEdgeDarts).get(edge)).removeElement(dart);
        if (ListSequence.fromList((List)MapSequence.fromMap(this.myEdgeDarts).get(edge)).count() == 0) {
            MapSequence.fromMap(this.myEdgeDarts).removeKey(edge);
        }
    }

    public void setDart(Face face, int pos, Dart dart) {
        Dart oldDart = ListSequence.fromList(face.getDarts()).getElement(pos);
        this.unadjustDart(oldDart);
        ListSequence.fromList(face.getDarts()).setElement(pos, dart);
        this.adjustDart(dart, face);
    }

    public void removeDart(Face face, Dart dart) {
        this.unadjustDart(dart);
        ListSequence.fromList(face.getDarts()).removeElement(dart);
    }

    public void insertDart(Face face, int pos, Dart dart) {
        ListSequence.fromList(face.getDarts()).insertElement(pos, dart);
        this.adjustDart(dart, face);
    }

    public void addFirstDart(Face face, Dart dart) {
        this.insertDart(face, 0, dart);
    }

    public void addLastDart(Face face, Dart dart) {
        this.insertDart(face, ListSequence.fromList(face.getDarts()).count(), dart);
    }

    public List<Face> getFaces() {
        return this.myFaces;
    }

    public List<Face> getAdjacentFaces(Edge edge) {
        IListSequence<Face> faces = ListSequence.fromList(new ArrayList());
        ListSequence.fromList(faces).addSequence(ListSequence.fromList(this.getDarts(edge)).select(new ISelector<Dart, Face>(){

            @Override
            public Face select(Dart dart) {
                return EmbeddedGraph.this.getFace(dart);
            }
        }));
        if (ListSequence.fromList(faces).count() == 0) {
            return null;
        }
        return faces;
    }

    public Set<Edge> getEdges() {
        return MapSequence.fromMap(this.myEdgeDarts).keySet();
    }

    public List<Dart> getDarts(Edge edge) {
        return (List)MapSequence.fromMap(this.myEdgeDarts).get(edge);
    }

    public Dart getOpposite(Dart dart) {
        return ListSequence.fromList(this.getDarts(dart.getEdge())).findFirst(it -> it != dart);
    }

    public Face getFace(Dart dart) {
        return (Face)MapSequence.fromMap(this.myDartsToFacesMap).get(dart);
    }

    public List<Dart> getDartWithSource(Node node) {
        IListSequence<Dart> darts = ListSequence.fromList(new ArrayList());
        for (Edge edge : ListSequence.fromList(node.getEdges())) {
            List<Dart> edgeDarts = this.getDarts(edge);
            if (edgeDarts == null) continue;
            ListSequence.fromList(darts).addElement(ListSequence.fromList(edgeDarts).findFirst(dart -> dart.getSource() == node));
        }
        return darts;
    }

    public Dart getNextSourceDart(Dart dart) {
        Face face = this.getFace(dart);
        Dart next = null;
        int num = 0;
        for (Dart sourceDart : ListSequence.fromList(this.getDartWithSource(dart.getSource()))) {
            if (this.getFace(this.getOpposite(sourceDart)) != face) continue;
            next = sourceDart;
            ++num;
        }
        if (num > 1) {
            face.makeStartsWith(dart);
            next = this.getOpposite((Dart)ListSequence.fromList(face.getDarts()).last());
        }
        return next;
    }

    public List<Dart> getOrderedDarts(Node node) {
        List<Dart> darts = this.getDartWithSource(node);
        IListSequence<Dart> sortedDarts = ListSequence.fromList(new LinkedList());
        Dart curDart = (Dart)ListSequence.fromList(darts).first();
        while (ListSequence.fromList(sortedDarts).count() != ListSequence.fromList(darts).count()) {
            ListSequence.fromList(sortedDarts).addElement(curDart);
            curDart = this.getNextSourceDart(curDart);
        }
        return sortedDarts;
    }

    public Graph getGraph() {
        return this.myGraph;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (Face face : ListSequence.fromList(this.myFaces)) {
            builder.append(String.valueOf(face) + "\n");
        }
        builder.append("outer face has num: " + ListSequence.fromList(this.myFaces).indexOf(this.myOuterFace));
        return builder.toString();
    }

    public Face getOuterFace() {
        return this.myOuterFace;
    }

    public void setOuterFace(Face outerFace) {
        this.myOuterFace = outerFace;
    }

    public boolean isOuterFace(Face face) {
        return face == this.myOuterFace;
    }

    public void removeEdge(Edge edge) {
        List<Dart> edgeDarts = this.getDarts(edge);
        Dart first = (Dart)ListSequence.fromList(edgeDarts).first();
        Face face = this.getFace(first);
        face.makeStartsWith(first);
        this.removeDart(face, first);
        Dart last = (Dart)ListSequence.fromList(edgeDarts).last();
        Face toRemove = this.getFace(last);
        if (this.isOuterFace(toRemove)) {
            this.setOuterFace(face);
        }
        this.removeFace(toRemove);
        List<Dart> darts = toRemove.makeStartsWith(last);
        for (Dart dart : ListSequence.fromList(darts)) {
            if (dart == last) continue;
            this.addLastDart(face, dart);
        }
    }

    public boolean isEmpty() {
        return ListSequence.fromList(this.getFaces()).count() == 0;
    }
}

