/*
 * Decompiled with CFR 0.152.
 */
package com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarGraph;

import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Edge;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Graph;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Node;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarGraph.Dart;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarGraph.DualGraph;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarGraph.EmbeddedGraph;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarGraph.Face;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ListSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.MapSequence;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class STPlanarGraph {
    private Map<Face, Node> myOrigNode;
    private Map<Face, Node> myDestNode;
    private Map<Edge, Face> myLeftFaceForEdge;
    private Map<Edge, Face> myRightFaceForEdge;
    private Map<Node, Face> myLeftFaceForNode;
    private Map<Node, Face> myRightFaceForNode;
    private Node mySource;
    private Node myTarget;
    private EmbeddedGraph myEmbeddedGraph;

    public STPlanarGraph(EmbeddedGraph embeddedGraph, Node source, Node target) {
        this.myEmbeddedGraph = embeddedGraph;
        this.myOrigNode = MapSequence.fromMap(new HashMap());
        this.myDestNode = MapSequence.fromMap(new HashMap());
        this.myLeftFaceForEdge = MapSequence.fromMap(new HashMap());
        this.myRightFaceForEdge = MapSequence.fromMap(new HashMap());
        this.myLeftFaceForNode = MapSequence.fromMap(new HashMap());
        this.myRightFaceForNode = MapSequence.fromMap(new HashMap());
        this.mySource = source;
        this.myTarget = target;
        this.computeMaps();
    }

    public void computeMaps() {
        for (Face face : ListSequence.fromList(this.myEmbeddedGraph.getFaces())) {
            List<Dart> darts = face.getDarts();
            for (Dart dart : ListSequence.fromList(darts)) {
                Edge edge = dart.getEdge();
                if (dart.getSource() == edge.getSource()) {
                    MapSequence.fromMap(this.myRightFaceForEdge).put(edge, face);
                    continue;
                }
                MapSequence.fromMap(this.myLeftFaceForEdge).put(edge, face);
            }
            for (int i = 0; i < ListSequence.fromList(darts).count(); ++i) {
                Dart cur = ListSequence.fromList(darts).getElement(i);
                Dart next = i + 1 < ListSequence.fromList(darts).count() ? ListSequence.fromList(darts).getElement(i + 1) : ListSequence.fromList(darts).getElement(0);
                Node mid = cur.getTarget();
                if (cur.getEdge().getSource() == mid && next.getEdge().getSource() == mid) {
                    MapSequence.fromMap(this.myOrigNode).put(face, mid);
                }
                if (cur.getEdge().getTarget() == mid && next.getEdge().getTarget() == mid) {
                    MapSequence.fromMap(this.myDestNode).put(face, mid);
                }
                if (cur.getEdge().getTarget() == mid && next.getEdge().getSource() == mid) {
                    MapSequence.fromMap(this.myRightFaceForNode).put(mid, face);
                }
                if (cur.getEdge().getSource() != mid || next.getEdge().getTarget() != mid) continue;
                MapSequence.fromMap(this.myLeftFaceForNode).put(mid, face);
            }
        }
        Face outerFace = this.myEmbeddedGraph.getOuterFace();
        MapSequence.fromMap(this.myLeftFaceForNode).put(this.mySource, outerFace);
        MapSequence.fromMap(this.myRightFaceForNode).put(this.mySource, outerFace);
        MapSequence.fromMap(this.myLeftFaceForNode).put(this.myTarget, outerFace);
        MapSequence.fromMap(this.myRightFaceForNode).put(this.myTarget, outerFace);
    }

    public Node getOrigNode(Object o) {
        if (o instanceof Node) {
            return (Node)o;
        }
        if (o instanceof Edge) {
            return ((Edge)o).getSource();
        }
        return (Node)MapSequence.fromMap(this.myOrigNode).get((Face)o);
    }

    public Node getDestNode(Object o) {
        if (o instanceof Node) {
            return (Node)o;
        }
        if (o instanceof Edge) {
            return ((Edge)o).getTarget();
        }
        return (Node)MapSequence.fromMap(this.myDestNode).get((Face)o);
    }

    public Face getLeftFace(Object o) {
        if (o instanceof Node) {
            return (Face)MapSequence.fromMap(this.myLeftFaceForNode).get((Node)o);
        }
        if (o instanceof Edge) {
            return (Face)MapSequence.fromMap(this.myLeftFaceForEdge).get((Edge)o);
        }
        return (Face)o;
    }

    public Face getRightFace(Object o) {
        if (o instanceof Node) {
            return (Face)MapSequence.fromMap(this.myRightFaceForNode).get((Node)o);
        }
        if (o instanceof Edge) {
            return (Face)MapSequence.fromMap(this.myRightFaceForEdge).get((Edge)o);
        }
        return (Face)o;
    }

    public Node getSource() {
        return this.mySource;
    }

    public Node getTarget() {
        return this.myTarget;
    }

    public DualGraph getModifiedDualGraph() {
        DualGraph dualGraph = new DualGraph(this.myEmbeddedGraph);
        for (Edge edge : ListSequence.fromList(dualGraph.getEdges())) {
            Face sourceFace = (Face)MapSequence.fromMap(dualGraph.getFacesMap()).get(edge.getSource());
            if (sourceFace == MapSequence.fromMap(this.myLeftFaceForEdge).get(MapSequence.fromMap(dualGraph.getEdgesMap()).get(edge))) continue;
            dualGraph.revertEdge(edge);
        }
        Face outerFace = this.myEmbeddedGraph.getOuterFace();
        Node rightOuterFace = dualGraph.createDummyNode();
        MapSequence.fromMap(dualGraph.getFacesMap()).put(rightOuterFace, outerFace);
        Node outerFaceNode = (Node)MapSequence.fromMap(dualGraph.getNodesMap()).get(outerFace);
        for (Edge edge : ListSequence.fromList(outerFaceNode.getEdges(Edge.Direction.BOTH))) {
            Edge realEdge = (Edge)MapSequence.fromMap(dualGraph.getEdgesMap()).get(edge);
            if (MapSequence.fromMap(this.myRightFaceForEdge).get(realEdge) != outerFace) continue;
            dualGraph.removeFromGraph(edge);
            dualGraph.addEdge(edge.getOpposite(outerFaceNode), rightOuterFace, realEdge);
        }
        return dualGraph;
    }

    public EmbeddedGraph getEmbeddedGraph() {
        return this.myEmbeddedGraph;
    }

    public Graph getGraph() {
        return this.myEmbeddedGraph.getGraph();
    }
}

