/*
 * Decompiled with CFR 0.152.
 */
package com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarization;

import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.algorithms.ShortestPath;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Edge;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Graph;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.GraphModificationEvent;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Node;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarGraph.Dart;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarGraph.DualGraph;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarGraph.EmbeddedGraph;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarGraph.Face;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarization.IEmbeddingFinder;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.IListSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ISequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ISetSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ListSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.MapSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.SetSequence;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class BiconnectedInitialEmbeddingFinder
implements IEmbeddingFinder {
    private static int SHOW_LOG = 0;

    @Override
    public EmbeddedGraph find(Graph graph) {
        EmbeddedGraph embeddedGraph = new EmbeddedGraph(graph);
        this.findCycle(embeddedGraph);
        ISetSequence<Node> toBeAdded = SetSequence.fromSet(new HashSet());
        SetSequence.fromSet(toBeAdded).addSequence((ISequence)ListSequence.fromList(graph.getNodes()));
        for (Dart dart : ListSequence.fromList(embeddedGraph.getOuterFace().getDarts())) {
            SetSequence.fromSet(toBeAdded).removeElement(dart.getSource());
        }
        while (SetSequence.fromSet(toBeAdded).count() > 0) {
            for (Edge edge : ListSequence.fromList(graph.getEdges())) {
                for (Node node : ListSequence.fromList(edge.getAdjacentNodes())) {
                    Node opNode = edge.getOpposite(node);
                    if (SetSequence.fromSet(toBeAdded).contains(node) || !SetSequence.fromSet(toBeAdded).contains(opNode)) continue;
                    this.addPath(embeddedGraph, node, opNode, toBeAdded);
                }
            }
        }
        return embeddedGraph;
    }

    private void addPath(EmbeddedGraph embeddedGraph, Node start, Node toAdd, Set<Node> toBeAdded) {
        if (SHOW_LOG > 0) {
            System.out.println("before: \n" + String.valueOf(embeddedGraph));
        }
        ISetSequence removed = SetSequence.fromSet(new HashSet());
        for (Edge edge : ListSequence.fromList(start.getEdges())) {
            if (!SetSequence.fromSet(toBeAdded).contains(edge.getOpposite(start))) continue;
            SetSequence.fromSet(removed).addElement(edge);
        }
        for (Edge edge : SetSequence.fromSet(removed)) {
            embeddedGraph.getGraph().removeEdge(edge);
        }
        List<Edge> path = ShortestPath.getPath(embeddedGraph.getGraph(), toAdd, start, Edge.Direction.BOTH);
        int endIndex = 0;
        Node cur = toAdd;
        while (SetSequence.fromSet(toBeAdded).contains(cur)) {
            cur = ListSequence.fromList(path).getElement(endIndex).getOpposite(cur);
            ++endIndex;
        }
        path = ListSequence.fromList(path).subListSequence(0, endIndex);
        for (Edge edge : SetSequence.fromSet(removed)) {
            embeddedGraph.getGraph().addEdge(edge);
        }
        ListSequence.fromList(path).insertElement(0, ListSequence.fromList(SetSequence.fromSet(removed).where(it -> it.getOpposite(start) == toAdd).toListSequence()).getElement(0));
        for (Edge edge : ListSequence.fromList(path)) {
            for (Node node : ListSequence.fromList(edge.getAdjacentNodes())) {
                SetSequence.fromSet(toBeAdded).removeElement(node);
            }
        }
        if (SHOW_LOG > 0) {
            System.out.println("find path: " + String.valueOf(path));
        }
        this.connect(embeddedGraph, path, start, cur);
    }

    private void findCycle(EmbeddedGraph embeddedGraph) {
        ISetSequence visited = SetSequence.fromSet(new HashSet());
        IListSequence darts = ListSequence.fromList(new ArrayList());
        Graph graph = embeddedGraph.getGraph();
        Node cur = graph.getNode(0);
        Edge prevEdge = null;
        while (!SetSequence.fromSet(visited).contains(cur)) {
            SetSequence.fromSet(visited).addElement(cur);
            Edge next = (Edge)ListSequence.fromList(cur.getEdges()).getElement(0);
            if (next == prevEdge) {
                next = (Edge)ListSequence.fromList(cur.getEdges()).getElement(1);
            }
            ListSequence.fromList(darts).addElement(new Dart(next, cur));
            cur = next.getOpposite(cur);
            prevEdge = next;
        }
        IListSequence path = ListSequence.fromList(new ArrayList());
        boolean inCycle = false;
        for (Object dart : ListSequence.fromList(darts)) {
            if (((Dart)dart).getSource() == cur) {
                inCycle = true;
            }
            if (!inCycle) continue;
            ListSequence.fromList(path).addElement(dart);
        }
        Face innerFace = new Face(graph);
        for (Dart dart : ListSequence.fromList(path)) {
            innerFace.addLast(dart);
        }
        Face outerFace = new Face(graph);
        for (Dart dart : ListSequence.fromList(path).reversedList()) {
            outerFace.addLast(new Dart(dart.getEdge(), dart.getTarget()));
        }
        embeddedGraph.addFace(innerFace);
        embeddedGraph.addFace(outerFace);
        embeddedGraph.setOuterFace(outerFace);
    }

    public void connect(EmbeddedGraph embeddedGraph, List<Edge> path, Node start, Node end) {
        Graph graph = embeddedGraph.getGraph();
        DualGraph dualGraph = new DualGraph(embeddedGraph);
        Node dualStart = dualGraph.addRealNode(start);
        Node dualEnd = dualGraph.addRealNode(end);
        List<Edge> dualPath = ShortestPath.getPath(dualGraph, dualStart, dualEnd, Edge.Direction.BOTH);
        IListSequence nodePath = ListSequence.fromList(new ArrayList());
        IListSequence facePath = ListSequence.fromList(new ArrayList());
        ListSequence.fromList(nodePath).addElement(start);
        Node cur = dualStart;
        for (Edge edge : ListSequence.fromList(dualPath)) {
            Edge realEdge = (Edge)MapSequence.fromMap(dualGraph.getEdgesMap()).get(edge);
            if (embeddedGraph.getAdjacentFaces(realEdge) != null) {
                ListSequence.fromList(nodePath).addElement(embeddedGraph.splitEdge((Edge)MapSequence.fromMap(dualGraph.getEdgesMap()).get(edge)));
            }
            cur = edge.getOpposite(cur);
            Face curFace = (Face)MapSequence.fromMap(dualGraph.getFacesMap()).get(cur);
            if (curFace == null) continue;
            ListSequence.fromList(facePath).addElement(curFace);
        }
        ListSequence.fromList(nodePath).addElement(end);
        Edge deletedEdge = null;
        IListSequence<Edge> newEdges = ListSequence.fromList(new ArrayList());
        for (int i = 0; i < ListSequence.fromList(nodePath).count() - 1; ++i) {
            Node curStart = (Node)ListSequence.fromList(nodePath).getElement(i);
            Node curEnd = (Node)ListSequence.fromList(nodePath).getElement(i + 1);
            IListSequence<Edge> tempPath = ListSequence.fromList(new ArrayList());
            if (i == 0) {
                if (end == ListSequence.fromList(nodePath).getElement(i + 1)) {
                    ListSequence.fromList(tempPath).addSequence(ListSequence.fromList(path));
                } else {
                    Edge lastEdge = ListSequence.fromList(path).removeLastElement();
                    graph.removeEdge(lastEdge);
                    deletedEdge = lastEdge;
                    ListSequence.fromList(tempPath).addSequence(ListSequence.fromList(path));
                    Edge newEdge = graph.connect(lastEdge.getOpposite(end), curEnd);
                    ListSequence.fromList(newEdges).addElement(newEdge);
                    ListSequence.fromList(tempPath).addElement(newEdge);
                }
            } else {
                Edge newEdge = graph.connect(curStart, curEnd);
                ListSequence.fromList(newEdges).addElement(newEdge);
                ListSequence.fromList(tempPath).addElement(newEdge);
            }
            embeddedGraph.splitFace((Face)ListSequence.fromList(facePath).getElement(i), tempPath, curStart, curEnd);
            if (deletedEdge == null) continue;
            GraphModificationEvent splitEvent = new GraphModificationEvent(GraphModificationEvent.Type.EDGE_SPLITTED, deletedEdge, newEdges);
            graph.getModificationProcessor().fire(splitEvent);
        }
    }
}

