/*
 * Decompiled with CFR 0.152.
 */
package com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarization;

import com.vertabelo.autolayout_tool.repackaged.javaslang.Tuple;
import com.vertabelo.autolayout_tool.repackaged.javaslang.Tuple2;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.algorithms.ConnectivityComponents;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.ClusteredGraph;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Edge;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.EdgesHistoryManager;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Graph;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.GroupedGraphModificationSynchronizer;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.INode;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Node;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarGraph.CheckEmbeddedGraph;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarGraph.Dart;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarGraph.EmbeddedGraph;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarGraph.Face;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarization.EmbeddingFinderFactory;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarization.ShortestPathEmbeddingFinder;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarization.SubsequenceFinder;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.IListSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.IMapSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ISetSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ListSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.MapSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.Sequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.SetSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.backports.LinkedList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ClusterEmbeddingConstructor {
    private static int debugMode = 0;
    private static int showInfo = 0;
    private static boolean useSlowFaceFinder = true;
    private ClusteredGraph myGraph;
    private Node myCluster;
    private Set<Node> myClusterNodes;
    private List<Edge> myOuterEdgesOrder;
    private Graph mySubclustersGraph;
    private EmbeddedGraph mySubEmbeddedGraph;
    private Map<INode, Node> mySubclustersMap;
    private EdgesHistoryManager myHistoryManager;
    private List<Edge> myClusterBorder;
    private EmbeddedGraph myEmbeddedGraph;
    private Map<Node, Node> myNodeMap;
    private Map<Face, Face> myFaceMap;
    private Map<Node, List<Edge>> myClusterBorderMap;

    public ClusterEmbeddingConstructor(ClusteredGraph graph, Node cluster, List<Edge> outerEdgesOrder) {
        this.myGraph = graph;
        this.myCluster = cluster;
        this.myClusterNodes = graph.getNodesInCluster(cluster);
        this.myOuterEdgesOrder = ListSequence.fromList(new LinkedList());
        ListSequence.fromList(this.myOuterEdgesOrder).addSequence(ListSequence.fromList(outerEdgesOrder));
        this.myHistoryManager = new EdgesHistoryManager(graph);
        if (showInfo > 0) {
            System.out.println("cluster " + String.valueOf(this.myCluster) + " outer edges: " + String.valueOf(outerEdgesOrder));
        }
    }

    public EmbeddedGraph constructEmbedding() {
        Face realFace;
        List<Node> subclusters = this.myGraph.getSubclusters(this.myCluster);
        if (Sequence.fromIterable(subclusters).count() == 0) {
            return new EmbeddedGraph(this.myGraph);
        }
        Map<Edge, Edge> invEdgeMap = this.constructSubclusterGraphEmbedding();
        if (showInfo > 0) {
            System.out.println("for cluster " + String.valueOf(this.myCluster) + " border is: " + String.valueOf(this.myClusterBorder));
        }
        this.myEmbeddedGraph = new EmbeddedGraph(this.myGraph);
        this.myFaceMap = MapSequence.fromMap(new LinkedHashMap(16, 0.75f, false));
        for (Face face : ListSequence.fromList(this.mySubEmbeddedGraph.getFaces())) {
            realFace = new Face(this.myGraph);
            MapSequence.fromMap(this.myFaceMap).put(face, realFace);
            for (Dart dart : ListSequence.fromList(face.getDarts())) {
                Edge edge = dart.getEdge();
                Edge realEdge = (Edge)MapSequence.fromMap(invEdgeMap).get(edge);
                if (realEdge == null) {
                    throw new RuntimeException("wrong synchronized embedding");
                }
                Node source = dart.getSource();
                Node realSource = source == edge.getSource() ? realEdge.getSource() : realEdge.getTarget();
                realFace.addLast(new Dart(realEdge, realSource));
            }
        }
        for (Node subcluster : Sequence.fromIterable(subclusters)) {
            this.findSubclusterEmbedding(subcluster, invEdgeMap);
        }
        for (Face face : SetSequence.fromSet(MapSequence.fromMap(this.myFaceMap).keySet())) {
            realFace = (Face)MapSequence.fromMap(this.myFaceMap).get(face);
            this.myEmbeddedGraph.addFace(realFace);
            if (!this.mySubEmbeddedGraph.isOuterFace(face)) continue;
            this.myEmbeddedGraph.setOuterFace(realFace);
        }
        if (this.myClusterBorderMap != null && ListSequence.fromList(this.myClusterBorder).count() > 0) {
            MapSequence.fromMap(this.myClusterBorderMap).put(this.myCluster, this.myClusterBorder);
        }
        return this.myEmbeddedGraph;
    }

    private void findSubclusterEmbedding(Node subcluster, Map<Edge, Edge> invEdgeMap) {
        Node node = (Node)MapSequence.fromMap(this.mySubclustersMap).get(subcluster);
        List<Dart> darts = this.mySubEmbeddedGraph.getOrderedDarts(node);
        IListSequence<Edge> subOuterEdgesOrder = ListSequence.fromList(new ArrayList(ListSequence.fromList(darts).count()));
        for (Dart dart2 : ListSequence.fromList(darts)) {
            Iterator edge = dart2.getEdge();
            Edge realEdge = (Edge)MapSequence.fromMap(invEdgeMap).get(edge);
            List<Edge> history = this.myHistoryManager.getHistory(realEdge);
            realEdge = ((Edge)((Object)edge)).getSource() == node ? (Edge)ListSequence.fromList(history).first() : (Edge)ListSequence.fromList(history).last();
            ListSequence.fromList(subOuterEdgesOrder).addElement(realEdge);
        }
        if (showInfo > 0) {
            for (Dart dart2 : ListSequence.fromList(darts)) {
                System.out.println("pr dart " + String.valueOf(dart2) + " -> " + String.valueOf(MapSequence.fromMap(invEdgeMap).get(dart2.getEdge())));
            }
            System.out.println("pr " + String.valueOf(subOuterEdgesOrder));
        }
        ClusterEmbeddingConstructor subProcessor = new ClusterEmbeddingConstructor(this.myGraph, subcluster, subOuterEdgesOrder);
        subProcessor.setClusterBorderMap(this.myClusterBorderMap);
        EmbeddedGraph subclusterEmbedding = subProcessor.constructEmbedding();
        CheckEmbeddedGraph.checkEmbeddedGraph(subclusterEmbedding, false);
        if (ListSequence.fromList(subclusterEmbedding.getFaces()).count() > 0) {
            for (Face face : ListSequence.fromList(subclusterEmbedding.getFaces())) {
                if (subclusterEmbedding.isOuterFace(face)) continue;
                this.myEmbeddedGraph.addFace(face);
            }
            if (showInfo > 0) {
                for (Edge edge : ListSequence.fromList(subOuterEdgesOrder)) {
                    System.out.println("order " + String.valueOf(edge) + ": " + String.valueOf(this.myHistoryManager.getHistory(edge)));
                }
                for (Dart dart3 : ListSequence.fromList(darts)) {
                    System.out.println("dart " + String.valueOf(dart3) + " -> " + String.valueOf(MapSequence.fromMap(invEdgeMap).get(dart3.getEdge())));
                }
            }
            List<Edge> subclusterBorder = subProcessor.getClusterBorder();
            for (int i = 0; i < ListSequence.fromList(darts).count(); ++i) {
                Edge borderEdge = ListSequence.fromList(subclusterBorder).getElement(i);
                Edge outerEdge = ListSequence.fromList(subOuterEdgesOrder).getElement(i);
                int next = i + 1;
                if (next == ListSequence.fromList(darts).count()) {
                    next = 0;
                }
                Edge nextOuterEdge = ListSequence.fromList(subOuterEdgesOrder).getElement(next);
                Face face = (Face)MapSequence.fromMap(this.myFaceMap).get(this.mySubEmbeddedGraph.getFace(ListSequence.fromList(darts).getElement(i)));
                List<Dart> faceDarts = face.getDarts();
                IListSequence<Dart> nextOuterFaceDarts = ListSequence.fromList(faceDarts).where(dart -> dart.getEdge() == nextOuterEdge).toListSequence();
                Node outerNode = this.getOuterNode(nextOuterEdge, subcluster);
                Dart nextOuterEdgeDart = ListSequence.fromList(nextOuterFaceDarts).findFirst(it -> it.getSource() == outerNode);
                if (nextOuterEdgeDart == null) {
                    throw new RuntimeException("error during merging subcluster's embeddings");
                }
                face.makeStartsWith(nextOuterEdgeDart);
                ListSequence.fromList(faceDarts).removeElementAt(0);
                ListSequence.fromList(faceDarts).removeElementAt(0);
                Edge curOuterEdge = this.getOuterEdgeAfterModifications(subcluster, outerEdge);
                Edge curNextOuterEdge = this.getOuterEdgeAfterModifications(subcluster, nextOuterEdge);
                ListSequence.fromList(faceDarts).insertElement(0, new Dart(curOuterEdge, borderEdge.getSource()));
                ListSequence.fromList(faceDarts).insertElement(0, new Dart(borderEdge, borderEdge.getTarget()));
                ListSequence.fromList(faceDarts).insertElement(0, new Dart(curNextOuterEdge, curNextOuterEdge.getOpposite(borderEdge.getTarget())));
            }
        }
    }

    private Edge getOuterEdgeAfterModifications(Node subcluster, Edge outerEdge) {
        Node outerNode = this.getOuterNode(outerEdge, subcluster);
        return ListSequence.fromList(this.myHistoryManager.getHistory(outerEdge)).findFirst(edge -> ListSequence.fromList(edge.getAdjacentNodes()).contains(outerNode));
    }

    private Node getOuterNode(Edge outerEdge, Node subcluster) {
        return ListSequence.fromList(outerEdge.getAdjacentNodes()).findFirst(node -> MapSequence.fromMap(this.myNodeMap).get(node) != MapSequence.fromMap(this.mySubclustersMap).get(subcluster));
    }

    private Map<Edge, Edge> constructSubclusterGraphEmbedding() {
        Node target;
        this.mySubclustersGraph = new Graph();
        IMapSequence<Node, Node> nodeMap = MapSequence.fromMap(new HashMap());
        this.myNodeMap = nodeMap;
        this.mySubclustersMap = MapSequence.fromMap(new HashMap());
        List<Node> subclusters = this.myGraph.getSubclusters(this.myCluster);
        for (Node node : ListSequence.fromList(subclusters)) {
            Node node2 = this.mySubclustersGraph.createNode();
            for (Node node3 : this.myGraph.getNodesInCluster(node)) {
                MapSequence.fromMap(nodeMap).put(node3, node2);
            }
            MapSequence.fromMap(this.mySubclustersMap).put(node, node2);
        }
        IMapSequence<Edge, Edge> invEdgeMap = MapSequence.fromMap(new HashMap());
        for (Node node : SetSequence.fromSet(this.myClusterNodes)) {
            for (Edge edge : node.getOutEdges()) {
                target = edge.getTarget();
                if (!SetSequence.fromSet(this.myClusterNodes).contains(target) || MapSequence.fromMap(nodeMap).get(node) == MapSequence.fromMap(nodeMap).get(target)) continue;
                Edge newEdge = this.mySubclustersGraph.connect((INode)MapSequence.fromMap(nodeMap).get(node), (INode)MapSequence.fromMap(nodeMap).get(target));
                MapSequence.fromMap(invEdgeMap).put(newEdge, edge);
            }
        }
        if (showInfo > 0) {
            System.out.println("i subgraph " + String.valueOf(this.myCluster) + ": " + String.valueOf(this.mySubclustersGraph.getEdges()));
        }
        Set<Edge> set = ConnectivityComponents.makeConnected(this.mySubclustersGraph);
        if (showInfo > 0) {
            System.out.println("c subgraph " + String.valueOf(this.myCluster) + ": " + String.valueOf(this.mySubclustersGraph.getEdges()));
        }
        for (Edge edge : SetSequence.fromSet(set)) {
            Node source = this.getRealNode(edge.getSource(), nodeMap);
            target = this.getRealNode(edge.getTarget(), nodeMap);
            Edge realEdge = this.myGraph.connect(source, target);
            MapSequence.fromMap(invEdgeMap).put(edge, realEdge);
        }
        GroupedGraphModificationSynchronizer groupedGraphModificationSynchronizer = new GroupedGraphModificationSynchronizer(this.mySubclustersGraph, this.myGraph, invEdgeMap);
        this.mySubEmbeddedGraph = EmbeddingFinderFactory.getFinder().find(this.mySubclustersGraph);
        if (showInfo > 0) {
            System.out.println("e subgraph " + String.valueOf(this.myCluster) + ": " + String.valueOf(this.mySubclustersGraph.getEdges()));
        }
        groupedGraphModificationSynchronizer.disconnect();
        if (ListSequence.fromList(this.myOuterEdgesOrder).count() > 0) {
            int i;
            int numShifts;
            for (numShifts = 0; this.getSubcluster((Edge)ListSequence.fromList(this.myOuterEdgesOrder).first()) == this.getSubcluster((Edge)ListSequence.fromList(this.myOuterEdgesOrder).last()) && numShifts < ListSequence.fromList(this.myOuterEdgesOrder).count(); ++numShifts) {
                ListSequence.fromList(this.myOuterEdgesOrder).insertElement(0, ListSequence.fromList(this.myOuterEdgesOrder).removeLastElement());
            }
            IListSequence<Edge> subClusterBorder = ListSequence.fromList(new ArrayList(ListSequence.fromList(this.myOuterEdgesOrder).count()));
            this.myClusterBorder = ListSequence.fromList(new ArrayList(ListSequence.fromList(this.myOuterEdgesOrder).count()));
            IListSequence<Edge> subOuterEdges = ListSequence.fromList(new ArrayList(ListSequence.fromList(this.myOuterEdgesOrder).count()));
            IListSequence realBorderNodes = ListSequence.fromList(new ArrayList(ListSequence.fromList(this.myOuterEdgesOrder).count()));
            IListSequence<Node> subBorderNodes = ListSequence.fromList(new ArrayList(ListSequence.fromList(this.myOuterEdgesOrder).count()));
            for (Edge outerEdge : ListSequence.fromList(this.myOuterEdgesOrder)) {
                Node realClusterNode = this.getClusterNode(outerEdge);
                boolean isSource = realClusterNode == outerEdge.getSource();
                List<Edge> realSplit = this.myGraph.splitEdge(outerEdge);
                ListSequence.fromList(realBorderNodes).addElement(ListSequence.fromList(realSplit).getElement(0).getTarget());
                Node subBorderNode = this.mySubclustersGraph.createNode();
                ListSequence.fromList(subBorderNodes).addElement(subBorderNode);
                Edge subOuterEdge = isSource ? this.mySubclustersGraph.connect((INode)MapSequence.fromMap(nodeMap).get(realClusterNode), subBorderNode) : this.mySubclustersGraph.connect(subBorderNode, (INode)MapSequence.fromMap(nodeMap).get(realClusterNode));
                Edge realOuterEdge = ListSequence.fromList(realSplit).findFirst(it -> ListSequence.fromList(it.getAdjacentNodes()).contains(realClusterNode));
                MapSequence.fromMap(invEdgeMap).put(subOuterEdge, realOuterEdge);
                ListSequence.fromList(subOuterEdges).addElement(subOuterEdge);
            }
            Face outerFace = new Face(this.mySubclustersGraph);
            for (i = 0; i < ListSequence.fromList(this.myOuterEdgesOrder).count(); ++i) {
                int next = i + 1;
                if (next == ListSequence.fromList(this.myOuterEdgesOrder).count()) {
                    next = 0;
                }
                Edge realBorderEdge = this.myGraph.connect((INode)ListSequence.fromList(realBorderNodes).getElement(i), (INode)ListSequence.fromList(realBorderNodes).getElement(next));
                ListSequence.fromList(this.myClusterBorder).addElement(realBorderEdge);
                Edge subBorderEdge = this.mySubclustersGraph.connect(ListSequence.fromList(subBorderNodes).getElement(i), ListSequence.fromList(subBorderNodes).getElement(next));
                ListSequence.fromList(subClusterBorder).addElement(subBorderEdge);
                MapSequence.fromMap(invEdgeMap).put(subBorderEdge, realBorderEdge);
                outerFace.addFirst(new Dart(subBorderEdge, ListSequence.fromList(subBorderNodes).getElement(next)));
            }
            for (i = 0; i < numShifts; ++i) {
                ListSequence.fromList(this.myClusterBorder).addElement(ListSequence.fromList(this.myClusterBorder).removeElementAt(0));
            }
            Set<Object> addedEdges = SetSequence.fromSet(new HashSet());
            if (useSlowFaceFinder) {
                addedEdges = this.createOuterFaceWithFaceSelection(subBorderNodes, subOuterEdges, subClusterBorder);
            } else {
                Edge bridge = this.createOuterFace(subBorderNodes, subOuterEdges, subClusterBorder);
                SetSequence.fromSet(addedEdges).addElement(bridge);
            }
            this.mySubEmbeddedGraph.addFace(outerFace);
            this.mySubEmbeddedGraph.setOuterFace(outerFace);
            if (debugMode > 0) {
                CheckEmbeddedGraph.checkEmbeddedGraph(this.mySubEmbeddedGraph, false);
            }
            GroupedGraphModificationSynchronizer groupedGraphModificationSynchronizer2 = new GroupedGraphModificationSynchronizer(this.mySubclustersGraph, this.myGraph, invEdgeMap);
            for (Edge edge : ListSequence.fromList(subOuterEdges)) {
                if (SetSequence.fromSet(addedEdges).contains(edge)) continue;
                this.mySubclustersGraph.removeEdge(edge);
                ShortestPathEmbeddingFinder.restoreEdge(this.mySubEmbeddedGraph, edge, true);
            }
            groupedGraphModificationSynchronizer2.disconnect();
        }
        return invEdgeMap;
    }

    private Set<Edge> createOuterFaceWithFaceSelection(List<Node> subBorderNodes, List<Edge> subOuterEdges, List<Edge> subClusterBorder) {
        if (this.mySubEmbeddedGraph.isEmpty()) {
            Node node = (Node)ListSequence.fromList(this.mySubclustersGraph.getNodes()).first();
            Edge prev = (Edge)ListSequence.fromList(subOuterEdges).last();
            Edge borderEdge = (Edge)ListSequence.fromList(subClusterBorder).last();
            Iterator borderEdgeItr = ListSequence.fromList(subClusterBorder).iterator();
            for (Edge edge : ListSequence.fromList(subOuterEdges)) {
                Face face = new Face(this.mySubclustersGraph);
                face.addLast(new Dart(borderEdge, borderEdge.getSource()));
                face.addLast(new Dart(edge, edge.getOpposite(node)));
                face.addLast(new Dart(prev, node));
                this.mySubEmbeddedGraph.addFace(face);
                prev = edge;
                borderEdge = (Edge)borderEdgeItr.next();
            }
            ISetSequence<Edge> addedEdges = SetSequence.fromSet(new HashSet());
            SetSequence.fromSet(addedEdges).addSequence(ListSequence.fromList(subOuterEdges));
            return addedEdges;
        }
        Tuple2<Face, List<Tuple2<Integer, Integer>>> bestFaceInfo = this.findBestFace();
        Face bestFace = bestFaceInfo._1();
        this.mySubEmbeddedGraph.removeFace(bestFace);
        List<Tuple2<Integer, Integer>> positions = bestFaceInfo._2();
        IListSequence<Dart> darts = ListSequence.fromList(bestFace.getDarts()).reversedList();
        positions = this.shiftLists(positions, darts, subBorderNodes, subOuterEdges, subClusterBorder);
        this.checkPos(positions);
        ListParser<Dart> dartParser = new ListParser<Dart>(this, darts);
        ListParser<Edge> edgeParser = new ListParser<Edge>(this, subClusterBorder);
        Tuple2 prev = Tuple.of(-1, -1);
        ISetSequence<Edge> addedEdges = SetSequence.fromSet(new HashSet());
        for (Tuple2 tuple2 : ListSequence.fromList(positions)) {
            if (prev._1() == -1) {
                prev = tuple2;
                continue;
            }
            List<Dart> curDarts = dartParser.getNext((Integer)tuple2._2());
            List<Edge> curEdges = edgeParser.getNext((Integer)tuple2._1());
            this.addFace(subOuterEdges, prev, subBorderNodes, curEdges, tuple2, curDarts, addedEdges);
            prev = tuple2;
        }
        List<Dart> curDarts = dartParser.getEnd();
        List<Edge> list = edgeParser.getEnd();
        Tuple2 pos = (Tuple2)ListSequence.fromList(positions).first();
        this.addFace(subOuterEdges, prev, subBorderNodes, list, pos, curDarts, addedEdges);
        return addedEdges;
    }

    private void addFace(List<Edge> subOuterEdges, Tuple2<Integer, Integer> prev, List<Node> subBorderNodes, List<Edge> curEdges, Tuple2<Integer, Integer> pos, List<Dart> curDarts, Set<Edge> addedEdges) {
        Face face = new Face(this.mySubclustersGraph);
        Edge prevEdge = ListSequence.fromList(subOuterEdges).getElement(prev._1());
        face.addLast(new Dart(prevEdge, prevEdge.getOpposite(ListSequence.fromList(subBorderNodes).getElement(prev._1()))));
        for (Edge edge : ListSequence.fromList(curEdges)) {
            face.addLast(new Dart(edge, edge.getSource()));
        }
        face.addLast(new Dart(ListSequence.fromList(subOuterEdges).getElement(pos._1()), ListSequence.fromList(subBorderNodes).getElement(pos._1())));
        for (Dart dart : ListSequence.fromList(curDarts).reversedList()) {
            face.addLast(dart);
        }
        this.mySubEmbeddedGraph.addFace(face);
        SetSequence.fromSet(addedEdges).addElement(ListSequence.fromList(subOuterEdges).getElement(pos._1()));
    }

    public void checkPos(List<Tuple2<Integer, Integer>> pos) {
        int last0 = Integer.MIN_VALUE;
        int last1 = Integer.MIN_VALUE;
        for (Tuple2 tuple2 : ListSequence.fromList(pos)) {
            if ((Integer)tuple2._1() <= last0) {
                throw new RuntimeException("fail");
            }
            if ((Integer)tuple2._2() < last1) {
                throw new RuntimeException("fail");
            }
            last0 = (Integer)tuple2._1();
            last1 = (Integer)tuple2._2();
        }
    }

    private List<Tuple2<Integer, Integer>> shiftLists(List<Tuple2<Integer, Integer>> pos, List<Dart> darts, List<Node> borderNodes, List<Edge> outerEdges, List<Edge> borderEdges) {
        Tuple2 first = (Tuple2)ListSequence.fromList(pos).first();
        int firstBorderPos = (Integer)first._1();
        for (int i = 0; i < firstBorderPos; ++i) {
            ListSequence.fromList(borderNodes).addElement(ListSequence.fromList(borderNodes).removeElementAt(0));
            ListSequence.fromList(outerEdges).addElement(ListSequence.fromList(outerEdges).removeElementAt(0));
            ListSequence.fromList(borderEdges).addElement(ListSequence.fromList(borderEdges).removeElementAt(0));
        }
        int firstDartPos = (Integer)first._2();
        for (int i = 0; i < firstDartPos; ++i) {
            ListSequence.fromList(darts).addElement(ListSequence.fromList(darts).removeElementAt(0));
        }
        IListSequence<Tuple2<Integer, Integer>> newPos = ListSequence.fromList(new ArrayList(ListSequence.fromList(pos).count()));
        for (Tuple2 tuple2 : ListSequence.fromList(pos)) {
            int p0 = (Integer)tuple2._1() - firstBorderPos;
            int p1 = (Integer)tuple2._2() - firstDartPos;
            if (p1 < 0) {
                p1 += ListSequence.fromList(darts).count();
            }
            ListSequence.fromList(newPos).addElement(Tuple.of(p0, p1));
        }
        return newPos;
    }

    private Tuple2<Face, List<Tuple2<Integer, Integer>>> findBestFace() {
        Face bestFace = null;
        List<Object> pos = ListSequence.fromList(new ArrayList());
        IListSequence<Object> outerOrder = ListSequence.fromList(new LinkedList());
        for (Edge outerEdge : ListSequence.fromList(this.myOuterEdgesOrder)) {
            ListSequence.fromList(outerOrder).addElement(this.getSubcluster(outerEdge));
        }
        for (Face face : ListSequence.fromList(this.mySubEmbeddedGraph.getFaces())) {
            IListSequence<Object> faceOrder = ListSequence.fromList(new LinkedList());
            List<Dart> darts = face.getDarts();
            for (Dart dart : ListSequence.fromList(darts).reversedList()) {
                ListSequence.fromList(faceOrder).addElement(dart.getTarget());
            }
            List<Tuple2<Integer, Integer>> facePos = SubsequenceFinder.getCyclicSubsequence(outerOrder, faceOrder);
            if (ListSequence.fromList(facePos).count() <= ListSequence.fromList(pos).count()) continue;
            pos = facePos;
            bestFace = face;
        }
        return Tuple.of(bestFace, pos);
    }

    private Edge createOuterFace(List<Node> subBorderNodes, List<Edge> subOuterEdges, List<Edge> subClusterBorder) {
        Node borderFirstNode = (Node)ListSequence.fromList(subBorderNodes).first();
        Edge bridge = (Edge)ListSequence.fromList(subOuterEdges).first();
        Node clusterFirstNode = bridge.getOpposite(borderFirstNode);
        Face clusterOuterFace = this.mySubEmbeddedGraph.findContainingFace(ListSequence.fromListAndArray(new ArrayList(), clusterFirstNode));
        clusterOuterFace.makeEndsWith(clusterFirstNode);
        Face ringFace = new Face(this.mySubclustersGraph);
        ringFace.addLast(new Dart(bridge, clusterFirstNode));
        for (Edge edge : ListSequence.fromList(subClusterBorder)) {
            ringFace.addLast(new Dart(edge, edge.getSource()));
        }
        ringFace.addLast(new Dart(bridge, borderFirstNode));
        for (Dart dart : ListSequence.fromList(clusterOuterFace.getDarts())) {
            ringFace.addLast(dart);
        }
        this.mySubEmbeddedGraph.removeFace(clusterOuterFace);
        this.mySubEmbeddedGraph.addFace(ringFace);
        return bridge;
    }

    private Node getRealNode(Node subNode, Map<Node, Node> nodeMap) {
        return SetSequence.fromSet(this.myClusterNodes).findFirst(it -> MapSequence.fromMap(nodeMap).get(it) == subNode);
    }

    private Node getClusterNode(Edge edge) {
        boolean isTarget;
        boolean isSource = SetSequence.fromSet(this.myClusterNodes).contains(edge.getSource());
        if (isSource == (isTarget = SetSequence.fromSet(this.myClusterNodes).contains(edge.getTarget()))) {
            throw new RuntimeException(String.valueOf(edge) + " is not outer for cluster " + String.valueOf(this.myCluster));
        }
        if (isSource) {
            return edge.getSource();
        }
        return edge.getTarget();
    }

    private Node getSubcluster(Edge outerEdge) {
        for (Node node : ListSequence.fromList(outerEdge.getAdjacentNodes())) {
            Node subcluster = (Node)MapSequence.fromMap(this.myNodeMap).get(node);
            if (subcluster == null) continue;
            return subcluster;
        }
        return null;
    }

    public List<Edge> getClusterBorder() {
        return this.myClusterBorder;
    }

    public void setClusterBorderMap(Map<Node, List<Edge>> clusterBorderMap) {
        this.myClusterBorderMap = clusterBorderMap;
    }

    public class ListParser<T> {
        private Iterator<T> myItr;
        private int myPos;

        public ListParser(ClusterEmbeddingConstructor this$0, List<T> list) {
            this.myItr = ListSequence.fromList(list).iterator();
            this.myPos = 0;
        }

        public List<T> getNext(int nextPos) {
            IListSequence part = ListSequence.fromList(new LinkedList());
            while (this.myPos != nextPos) {
                ListSequence.fromList(part).addElement(this.myItr.next());
                ++this.myPos;
            }
            return part;
        }

        public List<T> getEnd() {
            IListSequence part = ListSequence.fromList(new LinkedList());
            while (this.myItr.hasNext()) {
                ListSequence.fromList(part).addElement(this.myItr.next());
                ++this.myPos;
            }
            return part;
        }
    }
}

