/*
 * Decompiled with CFR 0.152.
 */
package com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarization;

import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.algorithms.BiconnectAugmentation;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.algorithms.ConnectivityComponents;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.ClusteredGraph;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Edge;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Graph;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Node;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarGraph.CheckEmbeddedGraph;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarGraph.EmbeddedGraph;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarization.ClusterEmbeddingConstructor;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarization.IEmbeddingFinder;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.IListSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ListSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.MapSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.SetSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.backports.LinkedList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ClusteredGraphEmbeddingFinder
implements IEmbeddingFinder {
    private Map<Node, List<Edge>> myClusterBorderMap;

    @Override
    public EmbeddedGraph find(Graph graph) {
        if (graph instanceof ClusteredGraph) {
            ClusteredGraph clusteredGraph = (ClusteredGraph)graph;
            Node root = clusteredGraph.getRoot();
            this.myClusterBorderMap = MapSequence.fromMap(new HashMap());
            ConnectivityComponents.makeConnected(graph);
            BiconnectAugmentation.smartMakeBiconnected(graph);
            ClusterEmbeddingConstructor constructor = new ClusterEmbeddingConstructor(clusteredGraph, root, null);
            constructor.setClusterBorderMap(this.myClusterBorderMap);
            EmbeddedGraph embeddedGraph = constructor.constructEmbedding();
            for (Node cluster : SetSequence.fromSet(MapSequence.fromMap(this.myClusterBorderMap).keySet())) {
                IListSequence newBorder = ListSequence.fromList(new LinkedList());
                for (Edge edge : ListSequence.fromList((List)MapSequence.fromMap(this.myClusterBorderMap).get(cluster))) {
                    if (edge.getSource() == edge.getTarget()) {
                        IListSequence<Edge> newEdges = ListSequence.fromList(new LinkedList());
                        embeddedGraph.splitEdge(edge, newEdges);
                        ListSequence.fromList(newBorder).addSequence(ListSequence.fromList(newEdges));
                        continue;
                    }
                    ListSequence.fromList(newBorder).addElement(edge);
                }
                MapSequence.fromMap(this.myClusterBorderMap).put(cluster, newBorder);
            }
            CheckEmbeddedGraph.checkEmbeddedGraph(embeddedGraph, false);
            return embeddedGraph;
        }
        throw new RuntimeException("can find embedding of clustered graphs only");
    }

    public Map<Node, List<Edge>> getClusterBorderMap() {
        return this.myClusterBorderMap;
    }
}

