/*
 * Decompiled with CFR 0.152.
 */
package com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarization;

import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Edge;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Graph;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Node;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarGraph.Dart;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarGraph.Face;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ListSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.MapSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.SetSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.backports.LinkedList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class EdgesOrder {
    private Map<Node, List<Edge>> myInEdgesMap = MapSequence.fromMap(new LinkedHashMap(16, 0.75f, false));
    private Map<Node, List<Edge>> myOutEdgesMap = MapSequence.fromMap(new LinkedHashMap(16, 0.75f, false));
    private boolean myReversed = false;

    public List<Edge> getInEdgesOrder(Node node) {
        List edges = (List)MapSequence.fromMap(this.myInEdgesMap).get(node);
        return this.reverseIfNeed(edges);
    }

    public List<Edge> getOutEdgesOrder(Node node) {
        List edges = (List)MapSequence.fromMap(this.myOutEdgesMap).get(node);
        return this.reverseIfNeed(edges);
    }

    public void reverse() {
        this.myReversed = !this.myReversed;
    }

    public String toString(String prefix) {
        StringBuilder builder = new StringBuilder();
        for (Node node : SetSequence.fromSet(MapSequence.fromMap(this.myInEdgesMap).keySet())) {
            builder.append(prefix + " NODE " + String.valueOf(node));
            builder.append(" in edges: " + String.valueOf(MapSequence.fromMap(this.myInEdgesMap).get(node)));
            builder.append(" out edges: " + String.valueOf(MapSequence.fromMap(this.myOutEdgesMap).get(node)) + "\n");
        }
        return builder.toString();
    }

    public Set<Node> getNodes() {
        return MapSequence.fromMap(this.myInEdgesMap).keySet();
    }

    public void merge(EdgesOrder order) {
        for (Node node : SetSequence.fromSet(order.getNodes())) {
            this.checkNode(node);
            ListSequence.fromList((List)MapSequence.fromMap(this.myInEdgesMap).get(node)).addSequence(ListSequence.fromList(order.getInEdgesOrder(node)));
            ListSequence.fromList((List)MapSequence.fromMap(this.myOutEdgesMap).get(node)).addSequence(ListSequence.fromList(order.getOutEdgesOrder(node)));
        }
    }

    public void addEdge(Node node, Edge edge) {
        this.checkNode(node);
        if (edge != null) {
            this.checkNode(edge.getSource());
            ListSequence.fromList((List)MapSequence.fromMap(this.myInEdgesMap).get(edge.getTarget())).addElement(edge);
            ListSequence.fromList((List)MapSequence.fromMap(this.myOutEdgesMap).get(edge.getSource())).addElement(edge);
        }
    }

    private void checkNode(Node node) {
        if (!MapSequence.fromMap(this.myInEdgesMap).containsKey(node)) {
            MapSequence.fromMap(this.myInEdgesMap).put(node, ListSequence.fromList(new LinkedList()));
            MapSequence.fromMap(this.myOutEdgesMap).put(node, ListSequence.fromList(new LinkedList()));
        }
    }

    private List<Edge> reverseIfNeed(List<Edge> edges) {
        if (this.myReversed) {
            return ListSequence.fromList(edges).reversedList();
        }
        return edges;
    }

    public Face findFace(Graph graph, Node node, Edge edge, boolean clockwise) {
        Face face = new Face(graph);
        Dart curDart = new Dart(edge, node);
        while (curDart.getTarget() != node) {
            face.addLast(curDart);
            Node curNode = curDart.getTarget();
            Edge nextEdge = clockwise ? this.getPrevClockwise(curNode, curDart.getEdge()) : this.getNextClockwise(curNode, curDart.getEdge());
            curDart = new Dart(nextEdge, curNode);
        }
        face.addLast(curDart);
        return face;
    }

    public Edge getNextClockwise(Node node, Edge edge) {
        List<Edge> inOrder = this.getInEdgesOrder(node);
        List<Edge> outOrder = this.getOutEdgesOrder(node);
        if (node == edge.getSource()) {
            return this.findEdge(edge, outOrder, inOrder, true);
        }
        return this.findEdge(edge, inOrder, outOrder, false);
    }

    public Edge getPrevClockwise(Node node, Edge edge) {
        List<Edge> inOrder = this.getInEdgesOrder(node);
        List<Edge> outOrder = this.getOutEdgesOrder(node);
        if (node == edge.getSource()) {
            return this.findEdge(edge, outOrder, inOrder, false);
        }
        return this.findEdge(edge, inOrder, outOrder, true);
    }

    private Edge findEdge(Edge edge, List<Edge> containingList, List<Edge> alternativeList, boolean tryFirst) {
        Edge sideEdge = tryFirst ? (Edge)ListSequence.fromList(containingList).first() : (Edge)ListSequence.fromList(containingList).last();
        if (edge == sideEdge) {
            if (ListSequence.fromList(alternativeList).count() > 0) {
                if (tryFirst) {
                    return (Edge)ListSequence.fromList(alternativeList).first();
                }
                return (Edge)ListSequence.fromList(alternativeList).last();
            }
            if (tryFirst) {
                return (Edge)ListSequence.fromList(containingList).last();
            }
            return (Edge)ListSequence.fromList(containingList).first();
        }
        Iterator edgeItr = tryFirst ? ListSequence.fromList(containingList).reversedList().iterator() : ListSequence.fromList(containingList).iterator();
        while (edgeItr.hasNext()) {
            Edge cur = (Edge)edgeItr.next();
            if (cur != edge) continue;
            return (Edge)edgeItr.next();
        }
        throw new RuntimeException("findEdge failed with " + String.valueOf(edge));
    }
}

