/*
 * Decompiled with CFR 0.152.
 */
package com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarization;

import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Edge;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Node;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarization.EdgesOrder;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarization.PQNode;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarization.QNode;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.IListSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ListSequence;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class PNode
extends PQNode {
    private Node myGraphNode;
    private Edge myGraphEdge;
    private int myHValue;
    private PQNode myHChild;
    private int myAValue;
    private PQNode myFirstAChild;
    private PQNode mySecondAChild;
    private boolean myMakeAFromH;

    public PNode(Node graphNode, Edge graphEdge) {
        this.myGraphNode = graphNode;
        this.myGraphEdge = graphEdge;
    }

    @Override
    public PQNode processAsPertinentRoot(List<PQNode> children, Node nextGraphNode) {
        ListSequence.fromList(this.getChildren()).removeWhere(it -> it.getState() != PQNode.State.EMPTY);
        children = ListSequence.fromList(children).removeWhere(it -> it.getState() == PQNode.State.EMPTY);
        IListSequence<PQNode> partialChildren = ListSequence.fromList(children).where(it -> it.getState() == PQNode.State.PARTIAL).toListSequence();
        int numPartialChildren = ListSequence.fromList(partialChildren).count();
        QNode newComponent = new QNode();
        PNode nextNode = new PNode(nextGraphNode, null);
        newComponent.addLastChild(nextNode);
        EdgesOrder edgesOrder = newComponent.getEdgesOrder();
        this.addLastChild(newComponent);
        if (numPartialChildren > 2) {
            throw new RuntimeException("can not make reduction: pertinent root has more than two partial children");
        }
        if (numPartialChildren == 0) {
            for (PQNode child : ListSequence.fromList(children).where(it -> it.getState() == PQNode.State.FULL)) {
                child.collectEdgesOrderInSubtree(edgesOrder);
            }
        }
        if (numPartialChildren == 1) {
            PQNode partialChild = (PQNode)ListSequence.fromList(partialChildren).first();
            IListSequence firstEmptySegment = ListSequence.fromList(new ArrayList());
            boolean endFirstSegment = false;
            for (PQNode child : ListSequence.fromList(partialChild.getChildren())) {
                if (child.getState() == PQNode.State.FULL) {
                    endFirstSegment = true;
                    continue;
                }
                if (endFirstSegment) {
                    newComponent.addLastChild(child);
                    continue;
                }
                ListSequence.fromList(firstEmptySegment).addElement(child);
            }
            for (PQNode child : ListSequence.fromList(firstEmptySegment).reversedList()) {
                newComponent.addFirstChild(child);
            }
            ListSequence.fromList(partialChild.getChildren()).removeWhere(it -> it.getState() != PQNode.State.FULL);
            partialChild.collectEdgesOrderInSubtree(edgesOrder);
            for (PQNode child : ListSequence.fromList(children).where(it -> it.getState() == PQNode.State.FULL)) {
                child.collectEdgesOrderInSubtree(edgesOrder);
            }
        }
        if (numPartialChildren == 2) {
            PQNode partialChild0 = ListSequence.fromList(partialChildren).getElement(0);
            IListSequence<PQNode> emptyNodes = ListSequence.fromList(partialChild0.getChildren()).where(it -> it.getState() == PQNode.State.EMPTY).toListSequence();
            emptyNodes = ListSequence.fromList(emptyNodes).reversedList();
            for (PQNode child : ListSequence.fromList(emptyNodes)) {
                newComponent.addFirstChild(child);
            }
            PQNode partialChild1 = ListSequence.fromList(partialChildren).getElement(1);
            ((QNode)partialChild1).reverse();
            emptyNodes = ListSequence.fromList(partialChild1.getChildren()).where(it -> it.getState() == PQNode.State.EMPTY).toListSequence();
            for (PQNode child : ListSequence.fromList(emptyNodes)) {
                newComponent.addLastChild(child);
            }
            ListSequence.fromList(partialChild0.getChildren()).removeWhere(it -> it.getState() != PQNode.State.FULL);
            partialChild0.collectEdgesOrderInSubtree(edgesOrder);
            for (PQNode child : ListSequence.fromList(children).where(it -> it.getState() == PQNode.State.FULL)) {
                child.collectEdgesOrderInSubtree(edgesOrder);
            }
            ListSequence.fromList(partialChild1.getChildren()).removeWhere(it -> it.getState() != PQNode.State.FULL);
            partialChild1.collectEdgesOrderInSubtree(edgesOrder);
        }
        return nextNode;
    }

    @Override
    public void collectEdgesOrderInSubtree(EdgesOrder order) {
        order.addEdge(this.myGraphNode, this.myGraphEdge);
        for (PQNode child : ListSequence.fromList(this.getChildren())) {
            child.collectEdgesOrderInSubtree(order);
        }
    }

    @Override
    public PQNode makeReduction(boolean isRealPertinentRoot) {
        int numFull = 0;
        int numPartial = 0;
        int numChildren = ListSequence.fromList(this.getChildren()).count();
        QNode replacement = null;
        for (PQNode node : ListSequence.fromList(this.getChildren())) {
            if (node.getState() == PQNode.State.FULL) {
                ++numFull;
            }
            if (node.getState() != PQNode.State.PARTIAL) continue;
            replacement = (QNode)node;
            ++numPartial;
        }
        if (numPartial > 1) {
            throw new RuntimeException("can not make reduction: P-node has more than one partial child");
        }
        if (numFull == numChildren) {
            this.setState(PQNode.State.FULL);
            return this;
        }
        if (replacement == null) {
            replacement = new QNode();
            replacement.setState(PQNode.State.PARTIAL);
        }
        this.splitNodes(replacement);
        return replacement;
    }

    public void splitNodes(PQNode replacement) {
        PNode newFullNode = new PNode(this.myGraphNode, null);
        newFullNode.setState(PQNode.State.FULL);
        PNode newEmptyNode = new PNode(this.myGraphNode, null);
        newEmptyNode.setState(PQNode.State.EMPTY);
        for (PQNode child : ListSequence.fromList(this.getChildren())) {
            if (child.getState() == PQNode.State.FULL) {
                newFullNode.addLastChild(child);
            }
            if (child.getState() != PQNode.State.EMPTY) continue;
            newEmptyNode.addLastChild(child);
        }
        if (ListSequence.fromList(newFullNode.getChildren()).count() > 0) {
            replacement.addLastChild(newFullNode);
        }
        if (ListSequence.fromList(newEmptyNode.getChildren()).count() > 0) {
            replacement.addFirstChild(newEmptyNode);
        }
        replacement.getEdgesOrder().addEdge(this.myGraphNode, this.myGraphEdge);
        replacement.setParent(this.getParent());
    }

    @Override
    public void addGraphNode(Node node) {
        this.myGraphNode = node;
    }

    @Override
    public Node getGraphNode() {
        return this.myGraphNode;
    }

    public Edge getEdge() {
        return this.myGraphEdge;
    }

    @Override
    public String getType() {
        return "P";
    }

    @Override
    public int getAValue() {
        return this.myAValue;
    }

    @Override
    public void computeAValue() {
        super.computeAValue();
        if (this.getState() != PQNode.State.PARTIAL) {
            this.myAValue = 0;
            return;
        }
        IListSequence<PQNode> partialChildren = ListSequence.fromList(this.getChildren()).where(it -> it.getState() == PQNode.State.PARTIAL).toListSequence();
        int valueFromA = 0;
        PQNode aChild = null;
        for (PQNode child : ListSequence.fromList(partialChildren)) {
            int curValue = child.getNumFullLeaves() - child.getAValue();
            if (valueFromA >= curValue) continue;
            valueFromA = curValue;
            aChild = child;
        }
        valueFromA = this.getNumFullLeaves() - valueFromA;
        int firstHMax = 0;
        int secondHMax = 0;
        PQNode firstHChild = null;
        PQNode secondHChild = null;
        int numPartialFullLeaves = 0;
        for (PQNode child : ListSequence.fromList(partialChildren)) {
            numPartialFullLeaves += child.getNumFullLeaves();
            int curValue = child.getNumFullLeaves() - child.getHValue();
            if (curValue > firstHMax) {
                secondHMax = firstHMax;
                secondHChild = firstHChild;
                firstHMax = curValue;
                firstHChild = child;
                continue;
            }
            if (curValue <= secondHMax) continue;
            secondHMax = curValue;
            secondHChild = child;
        }
        int valueFromH = numPartialFullLeaves - firstHMax - secondHMax;
        if (valueFromA <= valueFromH) {
            this.myMakeAFromH = false;
            this.myAValue = valueFromA;
            this.myFirstAChild = aChild;
            this.mySecondAChild = null;
        } else {
            this.myMakeAFromH = true;
            this.myAValue = valueFromH;
            this.myFirstAChild = firstHChild;
            this.mySecondAChild = secondHChild;
        }
        if (this.myAValue > 1000000) {
            this.myAValue = 1000000;
        }
    }

    @Override
    public void makeADeletion() {
        if (this.getState() == PQNode.State.FULL || this.getState() == PQNode.State.EMPTY) {
            return;
        }
        if (this.myMakeAFromH) {
            for (PQNode child : ListSequence.fromList(this.getChildren())) {
                if (child.getState() != PQNode.State.PARTIAL) continue;
                if (child == this.myFirstAChild || child == this.mySecondAChild) {
                    child.makeHDeletion();
                    continue;
                }
                child.makeEmpty();
            }
        } else {
            Iterator childItr = ListSequence.fromList(this.getChildren()).iterator();
            while (childItr.hasNext()) {
                PQNode child = (PQNode)childItr.next();
                if (child == this.myFirstAChild) {
                    child.makeADeletion();
                    continue;
                }
                if (child.makeEmpty() != null) continue;
                childItr.remove();
            }
            for (PQNode child : ListSequence.fromList(this.getChildren())) {
                if (child == this.myFirstAChild) {
                    child.makeADeletion();
                    continue;
                }
                child.makeEmpty();
            }
        }
    }

    @Override
    public int getHValue() {
        return this.myHValue;
    }

    @Override
    public void computeHValue() {
        super.computeHValue();
        if (this.getState() != PQNode.State.PARTIAL) {
            this.myHValue = 0;
            return;
        }
        if (this.getState() == PQNode.State.FULL || this.getState() == PQNode.State.EMPTY) {
            this.myHValue = 0;
            this.myHChild = null;
        } else {
            this.myHChild = null;
            this.myHValue = 0;
            int numPartialFullLeaves = 0;
            for (PQNode child : ListSequence.fromList(this.getChildren())) {
                if (child.getState() != PQNode.State.PARTIAL) continue;
                numPartialFullLeaves += child.getNumFullLeaves();
                int childHValue = child.getHValue();
                if (this.myHValue >= child.getNumFullLeaves() - childHValue) continue;
                this.myHValue = child.getNumFullLeaves() - childHValue;
                this.myHChild = child;
            }
            this.myHValue = numPartialFullLeaves - this.myHValue;
        }
        if (this.myHValue > 1000000) {
            this.myHValue = 1000000;
        }
    }

    @Override
    public void makeHDeletion() {
        if (this.getState() == PQNode.State.FULL || this.getState() == PQNode.State.EMPTY) {
            return;
        }
        for (PQNode child : ListSequence.fromList(this.getChildren())) {
            if (child.getState() != PQNode.State.PARTIAL) continue;
            if (child == this.myHChild) {
                child.makeHDeletion();
                continue;
            }
            child.makeEmpty();
        }
    }

    @Override
    public String getGraphInfo(String prefix) {
        return prefix + " node: " + String.valueOf(this.myGraphNode) + " edge: " + String.valueOf(this.myGraphEdge);
    }
}

