/*
 * Decompiled with CFR 0.152.
 */
package com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarization;

import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Node;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarization.EdgesOrder;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ListSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.backports.LinkedList;
import java.util.Iterator;
import java.util.List;

public abstract class PQNode {
    public static final int INF = 1000000;
    protected List<PQNode> myChildren = ListSequence.fromList(new LinkedList());
    private PQNode myParent = null;
    private State myState = null;
    private int myNumFullLeaves;

    public abstract PQNode processAsPertinentRoot(List<PQNode> var1, Node var2);

    public abstract PQNode makeReduction(boolean var1);

    public abstract int getAValue();

    public void computeAValue() {
        for (PQNode child : ListSequence.fromList(this.getChildren())) {
            child.computeAValue();
        }
    }

    public abstract void makeADeletion();

    public abstract int getHValue();

    public void computeHValue() {
        for (PQNode child : ListSequence.fromList(this.getChildren())) {
            child.computeHValue();
        }
    }

    public abstract void makeHDeletion();

    public void setState(State state) {
        this.myState = state;
    }

    public State getState() {
        return this.myState;
    }

    public List<PQNode> getChildren() {
        return this.myChildren;
    }

    public EdgesOrder getEdgesOrder() {
        return null;
    }

    public Node getGraphNode() {
        return null;
    }

    public void addLastChild(PQNode child) {
        ListSequence.fromList(this.myChildren).addElement(child);
        child.setParent(this);
    }

    public void addFirstChild(PQNode child) {
        ListSequence.fromList(this.myChildren).insertElement(0, child);
        child.setParent(this);
    }

    public PQNode getParent() {
        return this.myParent;
    }

    public void setParent(PQNode parent) {
        this.myParent = parent;
    }

    public void collectEdgesOrderInSubtree(EdgesOrder order) {
    }

    public String getGraphInfo(String prefix) {
        return prefix;
    }

    public String toString(int offset) {
        StringBuilder builder = new StringBuilder();
        Object spaces = "";
        for (int i = 0; i < offset; ++i) {
            spaces = (String)spaces + " ";
        }
        builder.append((String)spaces + "node " + this.getType() + " state = " + String.valueOf((Object)this.getState()) + "\n");
        builder.append(this.getGraphInfo((String)spaces) + "\n");
        if (ListSequence.fromList(this.getChildren()).count() > 0) {
            builder.append((String)spaces + "children: \n");
            for (PQNode child : ListSequence.fromList(this.getChildren())) {
                builder.append(child.toString(offset + 2));
            }
        }
        return builder.toString();
    }

    public void addGraphNode(Node node) {
    }

    public abstract String getType();

    public int getNumFullLeaves() {
        return this.myNumFullLeaves;
    }

    public void setNumFullLeaves(int numFullLeaves) {
        this.myNumFullLeaves = numFullLeaves;
    }

    public boolean isLeaf() {
        return ListSequence.fromList(this.getChildren()).count() == 0;
    }

    protected PQNode makeEmpty() {
        if (this.getState() == State.EMPTY) {
            return this;
        }
        if (ListSequence.fromList(this.getChildren()).count() == 0) {
            if (this.getState() == State.FULL) {
                return null;
            }
            return this;
        }
        Iterator childItr = ListSequence.fromList(this.getChildren()).iterator();
        while (childItr.hasNext()) {
            if (((PQNode)childItr.next()).makeEmpty() != null) continue;
            childItr.remove();
        }
        this.setState(State.EMPTY);
        if (ListSequence.fromList(this.getChildren()).count() == 0) {
            return null;
        }
        return this;
    }

    public static enum State {
        FULL,
        PARTIAL,
        EMPTY;

    }
}

