/*
 * Decompiled with CFR 0.152.
 */
package com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarization;

import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Edge;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Graph;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Node;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarGraph.Dart;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarGraph.EmbeddedGraph;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarGraph.Face;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarization.EdgesOrder;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarization.PNode;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarization.PQNode;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarization.PQTree;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarization.QNode;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.util.NodeMap;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.IListSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ISequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ISetSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ListSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.MapSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.SetSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.backports.LinkedList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PQPlanarityTest {
    private static int SHOW_LOG = 0;
    private PQTree myTree;
    private Map<Node, List<Edge>> myEdgesOrder;

    public Set<Edge> removeEdgesToPlanarity(Graph graph, Map<Node, Integer> stNumbering) {
        this.myEdgesOrder = new NodeMap<List<Edge>>(graph);
        ISetSequence<Edge> removed = SetSequence.fromSet(new LinkedHashSet());
        if (SHOW_LOG > 0) {
            System.out.println("GRAPH!!! " + String.valueOf(graph));
            System.out.println(stNumbering);
        }
        Node[] nodeOrder = new Node[graph.getNumNodes()];
        Iterator iterator = ListSequence.fromList(graph.getNodes()).iterator();
        while (iterator.hasNext()) {
            Node node;
            nodeOrder[((Integer)MapSequence.fromMap(stNumbering).get((Object)node)).intValue()] = node = (Node)iterator.next();
        }
        this.myTree = new PQTree();
        PQNode curPQNode = new PNode(nodeOrder[0], null);
        this.myTree.setRoot(curPQNode);
        for (int i = 0; i < nodeOrder.length - 1; ++i) {
            PQNode parent;
            Node curGraphNode = nodeOrder[i];
            for (Edge edge : ListSequence.fromList(curGraphNode.getOutEdges())) {
                PNode node = new PNode(edge.getTarget(), edge);
                curPQNode.addLastChild(node);
            }
            Node nextGraphNode = nodeOrder[i + 1];
            if (SHOW_LOG > 0) {
                System.out.println(this.myTree);
                System.out.println("next node is: " + String.valueOf(nextGraphNode));
            }
            List<Edge> remainingEdges = (parent = (curPQNode = this.myTree.modifyTree(nextGraphNode)).getParent()) instanceof QNode ? ((QNode)parent).getEdgesOrder().getInEdgesOrder(nextGraphNode) : ListSequence.fromListAndArray(new ArrayList(), ((PNode)curPQNode).getEdge());
            ISetSequence allInEdges = SetSequence.fromSet(new LinkedHashSet());
            SetSequence.fromSet(allInEdges).addSequence(ListSequence.fromList(nextGraphNode.getEdges(Edge.Direction.BACK)));
            SetSequence.fromSet(allInEdges).removeSequence(ListSequence.fromList(remainingEdges));
            SetSequence.fromSet(removed).addSequence((ISequence)SetSequence.fromSet(allInEdges));
        }
        EdgesOrder order = ((QNode)ListSequence.fromList(this.myTree.getRoot().getChildren()).first()).getEdgesOrder();
        for (Node node : ListSequence.fromList(graph.getNodes())) {
            MapSequence.fromMap(this.myEdgesOrder).put(node, order.getInEdgesOrder(node));
        }
        if (SHOW_LOG > 0) {
            System.out.println(this.myTree);
            for (int i = nodeOrder.length - 1; i >= 0; --i) {
                Node node;
                node = nodeOrder[i];
                System.out.print("node " + String.valueOf(node) + ":");
                System.out.print(" in edges: " + String.valueOf(order.getInEdgesOrder(node)));
                System.out.println(" out edges: " + String.valueOf(order.getOutEdgesOrder(node)));
            }
            System.out.println("removed edges: ");
            System.out.println(removed);
        }
        return removed;
    }

    public EmbeddedGraph getEmbedding(Graph graph, Map<Node, Integer> stNumbering) {
        Set<Edge> edges;
        if (SHOW_LOG > 0) {
            System.out.println("CONSTRUCTING THE EMBEDDING!!!");
        }
        if (SetSequence.fromSet(edges = this.removeEdgesToPlanarity(graph, stNumbering)).count() > 0) {
            throw new RuntimeException("trying to get embedding of nonplanar graph!!!" + String.valueOf(edges));
        }
        EdgesOrder order = ((QNode)ListSequence.fromList(this.myTree.getRoot().getChildren()).first()).getEdgesOrder();
        Node[] nodeOrder = new Node[graph.getNumNodes()];
        Iterator iterator = ListSequence.fromList(graph.getNodes()).iterator();
        while (iterator.hasNext()) {
            Node node;
            nodeOrder[((Integer)MapSequence.fromMap(stNumbering).get((Object)node)).intValue()] = node = (Node)iterator.next();
        }
        EmbeddedGraph embeddedGraph = this.createEmbeddedGraphFromInEdges(graph, List.of(nodeOrder));
        if (SHOW_LOG > 0) {
            System.out.println(embeddedGraph);
        }
        return embeddedGraph;
    }

    public EmbeddedGraph createEmbeddedGraph(Graph graph, EdgesOrder order, List<Node> nodeOrder) {
        EmbeddedGraph embeddedGraph = new EmbeddedGraph(graph);
        Node last = (Node)ListSequence.fromList(nodeOrder).last();
        Face outerFace = order.findFace(graph, last, (Edge)ListSequence.fromList(order.getInEdgesOrder(last)).first(), false);
        embeddedGraph.addFace(outerFace);
        embeddedGraph.setOuterFace(outerFace);
        for (Node node : ListSequence.fromList(nodeOrder).reversedList()) {
            Iterator edgeItr = ListSequence.fromList(order.getInEdgesOrder(node)).iterator();
            while (edgeItr.hasNext()) {
                Edge edge = (Edge)edgeItr.next();
                if (!edgeItr.hasNext()) continue;
                embeddedGraph.addFace(order.findFace(graph, node, edge, true));
            }
        }
        return embeddedGraph;
    }

    public EmbeddedGraph createEmbeddedGraphFromInEdges(Graph graph, List<Node> nodeOrder) {
        Node next;
        Edge curEdge;
        Node last;
        if (SHOW_LOG > 0) {
            System.out.println("-------------------------");
            System.out.println(this.myEdgesOrder);
        }
        ISetSequence addedNodes = SetSequence.fromSet(new HashSet());
        ISetSequence addedEdges = SetSequence.fromSet(new HashSet());
        EmbeddedGraph embeddedGraph = new EmbeddedGraph(graph);
        Face outerFace = new Face(graph);
        Face innerFace = new Face(graph);
        Node first = (Node)ListSequence.fromList(nodeOrder).first();
        Node cur = last = (Node)ListSequence.fromList(nodeOrder).last();
        while (cur != first) {
            SetSequence.fromSet(addedNodes).addElement(cur);
            curEdge = (Edge)ListSequence.fromList((List)MapSequence.fromMap(this.myEdgesOrder).get(cur)).first();
            next = curEdge.getOpposite(cur);
            outerFace.addFirst(new Dart(curEdge, next));
            innerFace.addLast(new Dart(curEdge, cur));
            SetSequence.fromSet(addedEdges).addElement(curEdge);
            cur = next;
        }
        SetSequence.fromSet(addedNodes).addElement(first);
        cur = last;
        while (cur != first) {
            SetSequence.fromSet(addedNodes).addElement(cur);
            curEdge = (Edge)ListSequence.fromList((List)MapSequence.fromMap(this.myEdgesOrder).get(cur)).last();
            next = curEdge.getOpposite(cur);
            outerFace.addLast(new Dart(curEdge, cur));
            innerFace.addFirst(new Dart(curEdge, next));
            SetSequence.fromSet(addedEdges).addElement(curEdge);
            cur = next;
        }
        embeddedGraph.addFace(outerFace);
        embeddedGraph.setOuterFace(outerFace);
        embeddedGraph.addFace(innerFace);
        if (SHOW_LOG > 0) {
            System.out.println(embeddedGraph);
        }
        for (Node node : ListSequence.fromList(nodeOrder).reversedList()) {
            Edge prev = null;
            for (Edge edge : ListSequence.fromList((List)MapSequence.fromMap(this.myEdgesOrder).get(node))) {
                if (SetSequence.fromSet(addedEdges).contains(edge)) {
                    prev = edge;
                    continue;
                }
                IListSequence<Edge> path = ListSequence.fromList(new LinkedList());
                ListSequence.fromList(path).addElement(edge);
                cur = edge.getSource();
                while (!SetSequence.fromSet(addedNodes).contains(cur)) {
                    SetSequence.fromSet(addedNodes).addElement(cur);
                    Edge nextEdge = (Edge)ListSequence.fromList((List)MapSequence.fromMap(this.myEdgesOrder).get(cur)).first();
                    ListSequence.fromList(path).insertElement(0, nextEdge);
                    cur = nextEdge.getSource();
                }
                if (SHOW_LOG > 0) {
                    System.out.println("adding path: " + String.valueOf(path));
                }
                Face containingFace = edge == ListSequence.fromList((List)MapSequence.fromMap(this.myEdgesOrder).get(node)).first() ? embeddedGraph.getFaceToTheLeft((Edge)ListSequence.fromList((List)MapSequence.fromMap(this.myEdgesOrder).get(node)).last()) : embeddedGraph.getFaceToTheRight(prev);
                if (SHOW_LOG > 0) {
                    System.out.println("to face: " + String.valueOf(containingFace));
                }
                embeddedGraph.splitFace(containingFace, path, ((Edge)ListSequence.fromList(path).first()).getSource(), node);
                SetSequence.fromSet(addedEdges).addSequence(ListSequence.fromList(path));
                prev = edge;
                if (SHOW_LOG <= 0) continue;
                System.out.println(embeddedGraph);
            }
        }
        return embeddedGraph;
    }
}

