/*
 * Decompiled with CFR 0.152.
 */
package com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarization;

import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.algorithms.BiconnectedComponent;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.algorithms.ConnectivityComponents;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.algorithms.GraphOrientation;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Edge;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Graph;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.INode;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Node;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarGraph.Dart;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarGraph.EmbeddedGraph;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarGraph.Face;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarization.IEmbeddingFinder;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarization.PQPlanarityTest;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.IMapSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ListSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.MapSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.SetSequence;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class PQPlanarizationFinder
implements IEmbeddingFinder {
    private static int SHOW_LOG = 0;
    private Graph myGraph;
    private Map<Node, Integer> myNumbering;

    @Override
    public EmbeddedGraph find(Graph graph) {
        Map<Node, Integer> components = ConnectivityComponents.getComponents(graph);
        for (Node node : ListSequence.fromList(graph.getNodes())) {
            if ((Integer)MapSequence.fromMap(components).get(node) == 0) continue;
            throw new RuntimeException("graph isn't connected!!!");
        }
        this.myGraph = graph;
        BiconnectedComponent componentsTree = BiconnectedComponent.createTree(graph);
        if (SHOW_LOG > 0) {
            System.out.println(componentsTree.toString(""));
        }
        return this.createEmbedding(componentsTree);
    }

    /*
     * WARNING - void declaration
     */
    private EmbeddedGraph createEmbedding(BiconnectedComponent component) {
        boolean manyNodeComponent;
        Graph componentGraph = new Graph();
        Set<Node> nodes = component.getNodes();
        EmbeddedGraph graphEmbedding = new EmbeddedGraph(this.myGraph);
        boolean bl = manyNodeComponent = SetSequence.fromSet(nodes).count() > 1;
        if (manyNodeComponent) {
            EmbeddedGraph componentEmbedding;
            PQPlanarityTest pqPlanarityTest;
            Set<Edge> removed;
            IMapSequence nodeMap = MapSequence.fromMap(new HashMap());
            IMapSequence invertedNodeMap = MapSequence.fromMap(new HashMap());
            IMapSequence invertedEdgeMap = MapSequence.fromMap(new HashMap());
            for (Node node : SetSequence.fromSet(nodes)) {
                Node componentNode = componentGraph.createNode();
                MapSequence.fromMap(nodeMap).put(node, componentNode);
                MapSequence.fromMap(invertedNodeMap).put(componentNode, node);
            }
            for (Node node : SetSequence.fromSet(component.getNodes())) {
                for (Edge edge : ListSequence.fromList(node.getEdges(Edge.Direction.FRONT))) {
                    Node node2 = edge.getTarget();
                    if (!SetSequence.fromSet(nodes).contains(node2)) continue;
                    Edge newEdge = componentGraph.connect((INode)MapSequence.fromMap(nodeMap).get(node), (INode)MapSequence.fromMap(nodeMap).get(node2));
                    MapSequence.fromMap(invertedEdgeMap).put(newEdge, edge);
                }
            }
            if (SHOW_LOG > 0) {
                System.out.println("COMPONENT!!! " + componentGraph.getNumNodes() + "  : " + ListSequence.fromList(componentGraph.getEdges()).count());
                System.out.println("map: " + String.valueOf(nodeMap));
            }
            if (SetSequence.fromSet(removed = (pqPlanarityTest = new PQPlanarityTest()).removeEdgesToPlanarity(componentGraph, GraphOrientation.orientST(componentGraph))).count() == 0) {
                componentEmbedding = pqPlanarityTest.getEmbedding(componentGraph, GraphOrientation.orientST(componentGraph));
            } else {
                for (Edge edge : SetSequence.fromSet(removed)) {
                    componentGraph.removeEdge(edge);
                }
                BiconnectedComponent biconnectedComponent = BiconnectedComponent.createTree(componentGraph);
                componentEmbedding = this.createEmbedding(biconnectedComponent);
                for (Edge edge : SetSequence.fromSet(removed)) {
                    componentGraph.addEdge(edge);
                }
            }
            for (Face face : ListSequence.fromList(componentEmbedding.getFaces())) {
                Face graphFace = new Face(this.myGraph);
                for (Dart dart : ListSequence.fromList(face.getDarts())) {
                    graphFace.addLast(new Dart((Edge)MapSequence.fromMap(invertedEdgeMap).get(dart.getEdge()), (Node)MapSequence.fromMap(invertedNodeMap).get(dart.getSource())));
                }
                graphEmbedding.addFace(graphFace);
                if (!componentEmbedding.isOuterFace(face)) continue;
                graphEmbedding.setOuterFace(graphFace);
            }
        } else {
            Face fakeFace = new Face(this.myGraph);
            graphEmbedding.addFace(fakeFace);
            graphEmbedding.setOuterFace(fakeFace);
        }
        for (BiconnectedComponent child : ListSequence.fromList(component.getChildren())) {
            void var13_29;
            EmbeddedGraph childEmbedding = this.createEmbedding(child);
            Object connection = component.getConnection(child);
            Edge bridge = null;
            if (connection instanceof Edge) {
                bridge = (Edge)connection;
            }
            Node cutpoint = component.getCutpoint(child);
            Node node = component.getChildCutpoint(child);
            if (ListSequence.fromList(childEmbedding.getFaces()).count() > 1) {
                Face face = childEmbedding.findContainingFace(ListSequence.fromListAndArray(new ArrayList(), node));
            } else {
                Face face = childEmbedding.getOuterFace();
            }
            if (bridge != null) {
                if (ListSequence.fromList(var13_29.getDarts()).count() > 0) {
                    var13_29.makeEndsWith(bridge.getOpposite(cutpoint));
                }
                childEmbedding.addLastDart((Face)var13_29, new Dart(bridge, bridge.getOpposite(cutpoint)));
                childEmbedding.addLastDart((Face)var13_29, new Dart(bridge, cutpoint));
            }
            if (!manyNodeComponent) {
                graphEmbedding = childEmbedding;
                manyNodeComponent = true;
                continue;
            }
            Face face = graphEmbedding.findContainingFace(ListSequence.fromListAndArray(new ArrayList(), cutpoint));
            boolean isOuter = graphEmbedding.isOuterFace(face);
            graphEmbedding.removeFace(face);
            childEmbedding.removeFace((Face)var13_29);
            Face newFace = new Face(this.myGraph);
            for (Dart dart : ListSequence.fromList(face.makeEndsWith(cutpoint))) {
                newFace.addLast(dart);
            }
            for (Dart dart : ListSequence.fromList(var13_29.makeEndsWith(cutpoint))) {
                newFace.addLast(dart);
            }
            graphEmbedding.addFace(newFace);
            if (isOuter) {
                graphEmbedding.setOuterFace(newFace);
            }
            for (Face childFace : ListSequence.fromList(childEmbedding.getFaces())) {
                graphEmbedding.addFace(childFace);
            }
        }
        return graphEmbedding;
    }
}

