/*
 * Decompiled with CFR 0.152.
 */
package com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarization;

import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Node;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarization.PNode;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarization.PQNode;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarization.QNode;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.IListSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ListSequence;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public class PQTree {
    private static int SHOW_LOG = 0;
    private PQNode myRoot = null;
    private Node myNodeToMerge;

    public PQNode getRoot() {
        return this.myRoot;
    }

    public void setRoot(PQNode root) {
        this.myRoot = root;
    }

    public PQNode modifyTree(Node nodeToMerge) {
        this.myNodeToMerge = nodeToMerge;
        String oldTreeRepresentation = this.toString();
        int oldNumFullLeaves = this.findPertinentRoot(this.myRoot).getNumFullLeaves();
        this.makeReducible();
        PQNode pertinentRoot = this.findPertinentRoot(this.myRoot);
        int numFullLeaves = pertinentRoot.getNumFullLeaves();
        if (SHOW_LOG > 0 && oldNumFullLeaves > numFullLeaves) {
            System.out.println("Graph has been made reductible!");
            System.out.println("before:");
            System.out.println(oldTreeRepresentation);
            System.out.println("after:");
            System.out.println(this);
        }
        if (numFullLeaves == 1) {
            pertinentRoot = pertinentRoot.getParent();
            List<PQNode> children = pertinentRoot.getChildren();
            ListIterator<PQNode> childItr = children.listIterator();
            PNode newNode = null;
            while (childItr.hasNext()) {
                PQNode child = childItr.next();
                if (child.getState() != PQNode.State.FULL) continue;
                newNode = new PNode(nodeToMerge, ((PNode)child).getEdge());
                newNode.setParent(pertinentRoot);
                childItr.set(newNode);
            }
            return newNode;
        }
        IListSequence<PQNode> modifiedChildren = ListSequence.fromList(new ArrayList());
        if (pertinentRoot instanceof QNode) {
            PQNode prePertinentRoot = pertinentRoot.getParent();
            for (PQNode child : ListSequence.fromList(prePertinentRoot.getChildren())) {
                if (child == pertinentRoot) {
                    ListSequence.fromList(modifiedChildren).addElement(this.arrange(child, true));
                    continue;
                }
                ListSequence.fromList(modifiedChildren).addElement(this.arrange(child, false));
            }
            for (PQNode child : ListSequence.fromList(modifiedChildren)) {
                child.setParent(prePertinentRoot);
            }
            return prePertinentRoot.processAsPertinentRoot(modifiedChildren, nodeToMerge);
        }
        for (PQNode child : ListSequence.fromList(pertinentRoot.getChildren())) {
            ListSequence.fromList(modifiedChildren).addElement(this.arrange(child, false));
        }
        for (PQNode child : ListSequence.fromList(modifiedChildren)) {
            child.setParent(pertinentRoot);
        }
        return pertinentRoot.processAsPertinentRoot(modifiedChildren, nodeToMerge);
    }

    public PQNode findPertinentRoot(PQNode node) {
        if (node.isLeaf()) {
            if (node.getGraphNode() == this.myNodeToMerge) {
                node.setState(PQNode.State.FULL);
                node.setNumFullLeaves(1);
            } else {
                node.setState(PQNode.State.EMPTY);
                node.setNumFullLeaves(0);
            }
            return node;
        }
        PQNode pertinentRootCandidate = null;
        int numFullChildren = 0;
        int numEmptyChildren = 0;
        int numPartialChildren = 0;
        int numFullLeaves = 0;
        for (PQNode child : ListSequence.fromList(node.getChildren())) {
            PQNode childPertinentRoot = this.findPertinentRoot(child);
            numFullLeaves += child.getNumFullLeaves();
            if (child.getState() == PQNode.State.EMPTY) {
                ++numEmptyChildren;
                continue;
            }
            pertinentRootCandidate = childPertinentRoot;
            if (child.getState() == PQNode.State.FULL) {
                ++numFullChildren;
            }
            if (child.getState() != PQNode.State.PARTIAL) continue;
            ++numPartialChildren;
        }
        node.setNumFullLeaves(numFullLeaves);
        if (numPartialChildren > 0) {
            node.setState(PQNode.State.PARTIAL);
        } else {
            int numChildren = ListSequence.fromList(node.getChildren()).count();
            if (numFullChildren == numChildren) {
                node.setState(PQNode.State.FULL);
            } else if (numEmptyChildren == numChildren) {
                node.setState(PQNode.State.EMPTY);
            } else {
                node.setState(PQNode.State.PARTIAL);
            }
        }
        if (numPartialChildren + numFullChildren == 1) {
            return pertinentRootCandidate;
        }
        return node;
    }

    private PQNode arrange(PQNode node, boolean isRealPertinentRoot) {
        if (node.getNumFullLeaves() == 0) {
            node.setState(PQNode.State.EMPTY);
            return node;
        }
        List<PQNode> children = node.getChildren();
        ListIterator<PQNode> childItr = children.listIterator();
        while (childItr.hasNext()) {
            PQNode child = childItr.next();
            PQNode newChild = this.arrange(child, false);
            childItr.set(newChild);
        }
        return node.makeReduction(isRealPertinentRoot);
    }

    public String toString() {
        return this.getRoot().toString(0);
    }

    public void makeReducible() {
        PQNode pertinentRoot = this.findPertinentRoot(this.myRoot);
        pertinentRoot.computeHValue();
        pertinentRoot.computeAValue();
        if (pertinentRoot.getHValue() < pertinentRoot.getAValue()) {
            pertinentRoot.makeHDeletion();
        } else {
            pertinentRoot.makeADeletion();
        }
    }
}

