/*
 * Decompiled with CFR 0.152.
 */
package com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarization;

import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Node;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarization.EdgesOrder;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarization.PQNode;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ListSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.SetSequence;
import java.util.Iterator;
import java.util.List;

public class QNode
extends PQNode {
    private EdgesOrder myEdgesOrder = new EdgesOrder();
    private int myHValue;
    private PQNode myHChild;
    private boolean myMakeHLeft;
    private int myAValue;
    private PQNode myFirstAChild;
    private PQNode mySecondAChild;
    private boolean myMakeAFromH;

    public PQNode processPartialCandidate(PQNode.State initialState, boolean isPertinentRoot) {
        QNode candidate = this.createCandidate(initialState);
        if (this.checkCandidate(candidate, isPertinentRoot)) {
            candidate.setParent(this.getParent());
            if (((PQNode)ListSequence.fromList(candidate.getChildren()).first()).getState() == PQNode.State.FULL) {
                candidate.reverse();
            }
            candidate.setState(PQNode.State.PARTIAL);
            return candidate;
        }
        return null;
    }

    private QNode createCandidate(PQNode.State initialState) {
        PQNode.State curState = initialState;
        QNode candidate = new QNode();
        candidate.getEdgesOrder().merge(this.getEdgesOrder());
        for (PQNode child : ListSequence.fromList(this.getChildren())) {
            Iterator partialChildIrt;
            if (child.getState() != PQNode.State.PARTIAL) {
                candidate.addLastChild(child);
                curState = child.getState();
                continue;
            }
            if (curState == PQNode.State.EMPTY) {
                candidate.getEdgesOrder().merge(child.getEdgesOrder());
                partialChildIrt = ListSequence.fromList(child.getChildren()).iterator();
            } else {
                child.getEdgesOrder().reverse();
                candidate.getEdgesOrder().merge(child.getEdgesOrder());
                partialChildIrt = ListSequence.fromList(child.getChildren()).reversedList().iterator();
            }
            while (partialChildIrt.hasNext()) {
                candidate.addLastChild((PQNode)partialChildIrt.next());
            }
            curState = ((PQNode)ListSequence.fromList(candidate.getChildren()).last()).getState();
        }
        return candidate;
    }

    private boolean checkCandidate(QNode candidate, boolean isPertinentRoot) {
        boolean startFullSegment = false;
        boolean endFullSegment = false;
        for (PQNode child : ListSequence.fromList(candidate.getChildren())) {
            if (child.getState() == PQNode.State.FULL) {
                if (!startFullSegment) {
                    startFullSegment = true;
                }
                if (!endFullSegment) continue;
                return false;
            }
            if (!startFullSegment) continue;
            endFullSegment = true;
        }
        if (isPertinentRoot) {
            return true;
        }
        return ((PQNode)ListSequence.fromList(candidate.getChildren()).first()).getState() == PQNode.State.FULL || ((PQNode)ListSequence.fromList(candidate.getChildren()).last()).getState() == PQNode.State.FULL;
    }

    @Override
    public PQNode makeReduction(boolean isRealPertinentRoot) {
        if (this.getState() != PQNode.State.PARTIAL) {
            return this;
        }
        PQNode candidate = this.processPartialCandidate(PQNode.State.EMPTY, isRealPertinentRoot);
        if (candidate != null) {
            return candidate;
        }
        candidate = this.processPartialCandidate(PQNode.State.FULL, isRealPertinentRoot);
        if (candidate != null) {
            return candidate;
        }
        return null;
    }

    @Override
    public PQNode processAsPertinentRoot(List<PQNode> children, Node nextGraphNode) {
        return null;
    }

    @Override
    public String getType() {
        return "Q";
    }

    public void reverse() {
        this.myChildren = ListSequence.fromList(this.myChildren).reversedList();
        this.getEdgesOrder().reverse();
    }

    @Override
    public EdgesOrder getEdgesOrder() {
        return this.myEdgesOrder;
    }

    @Override
    public int getAValue() {
        return this.myAValue;
    }

    @Override
    public void computeAValue() {
        int aValue;
        super.computeAValue();
        if (this.getState() != PQNode.State.PARTIAL) {
            this.myAValue = 0;
            return;
        }
        int valueFromA = 0;
        PQNode aChild = null;
        for (PQNode child : ListSequence.fromList(this.getChildren())) {
            int curValue = child.getNumFullLeaves() - child.getAValue();
            if (valueFromA >= curValue) continue;
            valueFromA = curValue;
            aChild = child;
        }
        valueFromA = this.getNumFullLeaves() - valueFromA;
        int valueFromH = 1000000;
        PQNode firstChild = null;
        PQNode lastChild = null;
        PQNode curFirst = null;
        boolean insideHSegment = false;
        int numFullLeavesInSegment = 0;
        for (PQNode child : ListSequence.fromList(this.getChildren())) {
            if (insideHSegment) {
                if (child.getState() == PQNode.State.FULL) {
                    numFullLeavesInSegment += child.getNumFullLeaves();
                    continue;
                }
                int aValue2 = this.getNumFullLeaves() - numFullLeavesInSegment - (curFirst.getNumFullLeaves() - curFirst.getHValue()) - (child.getNumFullLeaves() - child.getHValue());
                if (aValue2 < valueFromH) {
                    firstChild = curFirst;
                    lastChild = child;
                    valueFromH = aValue2;
                }
                numFullLeavesInSegment = 0;
                if (child.getState() == PQNode.State.PARTIAL) {
                    curFirst = child;
                    continue;
                }
                insideHSegment = false;
                continue;
            }
            if (child.getState() == PQNode.State.EMPTY) continue;
            curFirst = child;
            insideHSegment = true;
        }
        PQNode last = (PQNode)ListSequence.fromList(this.getChildren()).last();
        if (insideHSegment && curFirst != last && (aValue = this.getNumFullLeaves() - numFullLeavesInSegment - curFirst.getAValue() - last.getAValue()) < valueFromH) {
            firstChild = curFirst;
            lastChild = last;
            valueFromH = aValue;
        }
        if (valueFromA <= valueFromH) {
            this.myMakeAFromH = false;
            this.myAValue = valueFromA;
            this.myFirstAChild = aChild;
            this.mySecondAChild = null;
        } else {
            this.myMakeAFromH = true;
            this.myAValue = valueFromH;
            this.myFirstAChild = firstChild;
            this.mySecondAChild = lastChild;
        }
        if (this.myAValue > 1000000) {
            this.myAValue = 1000000;
        }
    }

    @Override
    public void makeADeletion() {
        if (this.getState() != PQNode.State.PARTIAL) {
            return;
        }
        if (this.myMakeAFromH) {
            boolean insideHSegment = false;
            Iterator childItr = ListSequence.fromList(this.getChildren()).iterator();
            while (childItr.hasNext()) {
                PQNode child = (PQNode)childItr.next();
                if (child == this.myFirstAChild || child == this.mySecondAChild) {
                    insideHSegment = !insideHSegment;
                    child.makeHDeletion();
                    continue;
                }
                if (insideHSegment || child.makeEmpty() != null) continue;
                childItr.remove();
            }
        } else {
            Iterator childItr = ListSequence.fromList(this.getChildren()).iterator();
            while (childItr.hasNext()) {
                PQNode child = (PQNode)childItr.next();
                if (child == this.myFirstAChild) {
                    child.makeADeletion();
                    continue;
                }
                if (child.makeEmpty() != null) continue;
                childItr.remove();
            }
        }
    }

    @Override
    public int getHValue() {
        return this.myHValue;
    }

    @Override
    public void computeHValue() {
        super.computeHValue();
        if (this.getState() != PQNode.State.PARTIAL) {
            this.myHValue = 0;
            return;
        }
        Iterator<PQNode> childItr = ListSequence.fromList(this.getChildren()).iterator();
        this.findHByIterator(childItr);
        int leftValue = this.myHValue;
        PQNode leftHChild = this.myHChild;
        childItr = ListSequence.fromList(this.getChildren()).reversedList().iterator();
        this.findHByIterator(childItr);
        int rightValue = this.myHValue;
        PQNode rightHChild = this.myHChild;
        if (leftValue < rightValue) {
            this.myHValue = leftValue;
            this.myHChild = leftHChild;
            this.myMakeHLeft = true;
        } else {
            this.myHValue = rightValue;
            this.myHChild = rightHChild;
            this.myMakeHLeft = false;
        }
        if (this.myHValue > 1000000) {
            this.myHValue = 1000000;
        }
    }

    @Override
    public void makeHDeletion() {
        if (this.getState() != PQNode.State.PARTIAL) {
            return;
        }
        boolean isToDelete = !this.myMakeHLeft;
        Iterator childItr = ListSequence.fromList(this.getChildren()).iterator();
        while (childItr.hasNext()) {
            PQNode child = (PQNode)childItr.next();
            if (child == this.myHChild) {
                child.makeHDeletion();
                isToDelete = !isToDelete;
                continue;
            }
            if (!isToDelete || child.makeEmpty() != null) continue;
            childItr.remove();
        }
    }

    private void findHByIterator(Iterator<PQNode> childItr) {
        PQNode firstPartial = null;
        boolean foundPartial = false;
        int w = 0;
        while (childItr.hasNext()) {
            PQNode cur = childItr.next();
            if (!foundPartial) {
                if (cur.getState() == PQNode.State.EMPTY) {
                    foundPartial = true;
                }
                if (cur.getState() == PQNode.State.PARTIAL) {
                    firstPartial = cur;
                    foundPartial = true;
                }
                if (cur.getState() != PQNode.State.FULL) continue;
                firstPartial = cur;
                continue;
            }
            w += cur.getNumFullLeaves();
        }
        if (firstPartial == null) {
            this.myHValue = 1000000;
            this.myHChild = null;
        } else {
            this.myHValue = w + firstPartial.getHValue();
            this.myHChild = firstPartial;
        }
    }

    @Override
    public void collectEdgesOrderInSubtree(EdgesOrder order) {
        order.merge(this.getEdgesOrder());
        for (PQNode child : ListSequence.fromList(this.getChildren())) {
            child.collectEdgesOrderInSubtree(order);
        }
    }

    public Node getLast() {
        Node last = null;
        for (Node node : SetSequence.fromSet(this.getEdgesOrder().getNodes())) {
            if (ListSequence.fromList(this.getEdgesOrder().getOutEdgesOrder(node)).count() != 0) continue;
            last = node;
        }
        return last;
    }

    @Override
    public String getGraphInfo(String prefix) {
        return this.getEdgesOrder().toString(prefix);
    }
}

