/*
 * Decompiled with CFR 0.152.
 */
package com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarization;

import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.algorithms.ShortestPath;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Edge;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Graph;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.GraphModificationEvent;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Node;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarGraph.DualGraph;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarGraph.EmbeddedGraph;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarGraph.Face;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarization.IEmbeddingFinder;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.IListSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ListSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.MapSequence;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ShortestPathEmbeddingFinder
implements IEmbeddingFinder {
    private static int SHOW_LOG = 0;
    private IEmbeddingFinder myInitialFinder;
    private boolean myForbidOuterEdgeCrossing;

    public ShortestPathEmbeddingFinder(IEmbeddingFinder initialFinder) {
        this.myInitialFinder = initialFinder;
        this.myForbidOuterEdgeCrossing = false;
    }

    public void setForbidOuterFaceCrossing(boolean forbidOuterFaceCrossing) {
        this.myForbidOuterEdgeCrossing = forbidOuterFaceCrossing;
    }

    @Override
    public EmbeddedGraph find(Graph graph) {
        if (graph.getNumNodes() < 2) {
            return new EmbeddedGraph(graph);
        }
        EmbeddedGraph embeddedGraph = this.myInitialFinder.find(graph);
        if (SHOW_LOG > 0) {
            System.out.println("initial embedding: ");
            System.out.println(embeddedGraph);
        }
        IListSequence<Edge> toAdd = ListSequence.fromList(graph.getEdges()).where(edge -> embeddedGraph.getAdjacentFaces((Edge)edge) == null).toListSequence();
        if (SHOW_LOG > 0) {
            System.out.println("edges to add: ");
            System.out.println(toAdd);
        }
        for (Edge edge2 : ListSequence.fromList(toAdd)) {
            graph.removeEdge(edge2);
        }
        for (Edge edge2 : ListSequence.fromList(toAdd)) {
            ShortestPathEmbeddingFinder.restoreEdge(embeddedGraph, edge2, this.myForbidOuterEdgeCrossing);
            if (SHOW_LOG <= 0) continue;
            System.out.println("restored " + String.valueOf(edge2));
            System.out.println(embeddedGraph);
        }
        return embeddedGraph;
    }

    public static List<Edge> restoreEdge(EmbeddedGraph embeddedGraph, Edge removedEdge, boolean forbidOuterEdgeCrossing) {
        DualGraph dualGraph = new DualGraph(embeddedGraph);
        IListSequence newNodes = ListSequence.fromList(new ArrayList());
        for (Node node : ListSequence.fromList(removedEdge.getAdjacentNodes())) {
            ListSequence.fromList(newNodes).addElement(dualGraph.addRealNode(node));
        }
        if (forbidOuterEdgeCrossing) {
            Map<Node, Face> facesMap = dualGraph.getFacesMap();
            Face outerFace = embeddedGraph.getOuterFace();
            Node outerNode = ListSequence.fromList(dualGraph.getNodes()).findFirst(it -> MapSequence.fromMap(facesMap).get(it) == outerFace);
            dualGraph.deleteNode(outerNode);
        }
        List<Edge> path = ShortestPath.getPath(dualGraph, (Node)ListSequence.fromList(newNodes).getElement(0), (Node)ListSequence.fromList(newNodes).getElement(1), Edge.Direction.BOTH);
        IListSequence nodePath = ListSequence.fromList(new ArrayList());
        IListSequence facePath = ListSequence.fromList(new ArrayList());
        ListSequence.fromList(nodePath).addElement(ListSequence.fromList(removedEdge.getAdjacentNodes()).getElement(0));
        Node cur = (Node)ListSequence.fromList(newNodes).getElement(0);
        for (Edge edge : ListSequence.fromList(path)) {
            Edge realEdge = (Edge)MapSequence.fromMap(dualGraph.getEdgesMap()).get(edge);
            if (embeddedGraph.getAdjacentFaces(realEdge) != null) {
                ListSequence.fromList(nodePath).addElement(embeddedGraph.splitEdge((Edge)MapSequence.fromMap(dualGraph.getEdgesMap()).get(edge)));
            }
            cur = edge.getOpposite(cur);
            Face curFace = (Face)MapSequence.fromMap(dualGraph.getFacesMap()).get(cur);
            if (curFace == null) continue;
            ListSequence.fromList(facePath).addElement(curFace);
        }
        IListSequence<Edge> newEdges = ListSequence.fromList(new ArrayList(ListSequence.fromList(nodePath).count() - 1));
        ListSequence.fromList(nodePath).addElement(ListSequence.fromList(removedEdge.getAdjacentNodes()).getElement(1));
        if (SHOW_LOG > 0) {
            System.out.println("path: ");
            System.out.println(nodePath);
        }
        for (int i = 0; i < ListSequence.fromList(nodePath).count() - 1; ++i) {
            Node start = (Node)ListSequence.fromList(nodePath).getElement(i);
            Node end = (Node)ListSequence.fromList(nodePath).getElement(i + 1);
            Edge newEdge = embeddedGraph.getGraph().connect(start, end);
            ListSequence.fromList(newEdges).addElement(newEdge);
            IListSequence<Edge> tempPath = ListSequence.fromListAndArray(new ArrayList(), newEdge);
            embeddedGraph.splitFace((Face)ListSequence.fromList(facePath).getElement(i), tempPath, start, end);
        }
        GraphModificationEvent splitEvent = new GraphModificationEvent(GraphModificationEvent.Type.EDGE_SPLITTED, removedEdge, newEdges);
        embeddedGraph.getGraph().getModificationProcessor().fire(splitEvent);
        return newEdges;
    }
}

