/*
 * Decompiled with CFR 0.152.
 */
package com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarization;

import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.algorithms.Dfs;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.algorithms.ShortestPath;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Edge;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Graph;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.INode;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Node;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarGraph.CheckEmbeddedGraph;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarGraph.Dart;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarGraph.DualGraph;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarGraph.EmbeddedGraph;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarGraph.Face;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarization.IEmbeddingFinder;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.IListSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.IMapSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ISequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ISetSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ListSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.MapSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.SetSequence;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TreeEmbeddingFinder
implements IEmbeddingFinder {
    private Map<Edge, List<Edge>> mySplittedEdges;

    @Override
    public EmbeddedGraph find(Graph graph) {
        this.mySplittedEdges = MapSequence.fromMap(new HashMap());
        EmbeddedGraph embeddedGraph = new EmbeddedGraph(graph);
        IListSequence<Edge> removed = ListSequence.fromList(new ArrayList());
        Face outerFace = this.getOuterTreeFace(graph, removed);
        for (Edge edge : ListSequence.fromList(removed)) {
            graph.removeEdge(edge);
        }
        embeddedGraph.addFace(outerFace);
        embeddedGraph.setOuterFace(outerFace);
        for (Edge removedEdge : ListSequence.fromList(removed)) {
            this.restoreEdge(embeddedGraph, removedEdge);
            CheckEmbeddedGraph.checkEmbeddedGraph(embeddedGraph, false);
        }
        this.mergeEdges();
        return embeddedGraph;
    }

    /*
     * WARNING - void declaration
     */
    private void restoreEdge(EmbeddedGraph embeddedGraph, Edge removedEdge) {
        void var10_13;
        MapSequence.fromMap(this.mySplittedEdges).put(removedEdge, ListSequence.fromList(new ArrayList()));
        Graph graph = embeddedGraph.getGraph();
        DualGraph dualGraph = new DualGraph(embeddedGraph);
        IListSequence newNodes = ListSequence.fromList(new ArrayList());
        for (Node node : ListSequence.fromList(removedEdge.getAdjacentNodes())) {
            Node newNode = dualGraph.createDummyNode();
            for (Edge edge : ListSequence.fromList(node.getEdges(Edge.Direction.BOTH))) {
                for (Face face : ListSequence.fromList(embeddedGraph.getAdjacentFaces(edge))) {
                    dualGraph.connect(newNode, (INode)MapSequence.fromMap(dualGraph.getNodesMap()).get(face));
                }
            }
            ListSequence.fromList(newNodes).addElement(newNode);
        }
        List<Edge> path = ShortestPath.getPath(dualGraph, (Node)ListSequence.fromList(newNodes).getElement(0), (Node)ListSequence.fromList(newNodes).getElement(1), Edge.Direction.BOTH);
        IListSequence nodePath = ListSequence.fromList(new ArrayList());
        IListSequence facePath = ListSequence.fromList(new ArrayList());
        ListSequence.fromList(nodePath).addElement(ListSequence.fromList(removedEdge.getAdjacentNodes()).getElement(0));
        Node cur = (Node)ListSequence.fromList(newNodes).getElement(0);
        for (Edge edge : ListSequence.fromList(path)) {
            Edge realEdge = (Edge)MapSequence.fromMap(dualGraph.getEdgesMap()).get(edge);
            if (embeddedGraph.getAdjacentFaces(realEdge) != null) {
                ListSequence.fromList(nodePath).addElement(this.split(embeddedGraph, (Edge)MapSequence.fromMap(dualGraph.getEdgesMap()).get(edge)));
            }
            cur = edge.getOpposite(cur);
            Face curFace = (Face)MapSequence.fromMap(dualGraph.getFacesMap()).get(cur);
            if (curFace == null) continue;
            ListSequence.fromList(facePath).addElement(curFace);
        }
        ListSequence.fromList(nodePath).addElement(ListSequence.fromList(removedEdge.getAdjacentNodes()).getElement(1));
        boolean bl = false;
        while (var10_13 < ListSequence.fromList(nodePath).count() - 1) {
            Edge newEdge = graph.connect((INode)ListSequence.fromList(nodePath).getElement((int)var10_13), (INode)ListSequence.fromList(nodePath).getElement((int)(var10_13 + true)));
            ListSequence.fromList((List)MapSequence.fromMap(this.mySplittedEdges).get(removedEdge)).addElement(newEdge);
            this.splitFace(embeddedGraph, (Face)ListSequence.fromList(facePath).getElement((int)var10_13), newEdge);
            ++var10_13;
        }
    }

    public void splitFace(EmbeddedGraph embeddedGraph, Face face, Edge newEdge) {
        Dart cur;
        List<Node> nodes = newEdge.getAdjacentNodes();
        Graph originalGraph = embeddedGraph.getGraph();
        IListSequence newFaces = ListSequence.fromList(new ArrayList());
        ListSequence.fromList(newFaces).addElement(new Face(originalGraph));
        ListSequence.fromList(newFaces).addElement(new Face(originalGraph));
        Iterator dartItr = ListSequence.fromList(face.getDarts()).iterator();
        do {
            cur = (Dart)dartItr.next();
        } while (!ListSequence.fromList(nodes).contains(cur.getSource()));
        Dart first = cur;
        Node found = cur.getSource();
        Node toFind = ListSequence.fromList(nodes).getElement(0);
        if (toFind == found) {
            toFind = ListSequence.fromList(nodes).getElement(1);
        }
        do {
            ((Face)ListSequence.fromList(newFaces).getElement(0)).addLast(cur);
        } while ((cur = (Dart)dartItr.next()).getSource() != toFind);
        ((Face)ListSequence.fromList(newFaces).getElement(0)).addLast(new Dart(newEdge, cur.getSource()));
        ((Face)ListSequence.fromList(newFaces).getElement(1)).addLast(new Dart(newEdge, first.getSource()));
        ((Face)ListSequence.fromList(newFaces).getElement(1)).addLast(cur);
        while (dartItr.hasNext()) {
            cur = (Dart)dartItr.next();
            ((Face)ListSequence.fromList(newFaces).getElement(1)).addLast(cur);
        }
        dartItr = ListSequence.fromList(face.getDarts()).iterator();
        cur = (Dart)dartItr.next();
        while (cur != first) {
            ((Face)ListSequence.fromList(newFaces).getElement(1)).addLast(cur);
            cur = (Dart)dartItr.next();
        }
        embeddedGraph.removeFace(face);
        for (Face newFace : ListSequence.fromList(newFaces)) {
            embeddedGraph.addFace(newFace);
        }
        if (embeddedGraph.isOuterFace(face)) {
            embeddedGraph.setOuterFace((Face)ListSequence.fromList(newFaces).getElement(1));
        }
    }

    public Node split(EmbeddedGraph embeddedGraph, Edge edge) {
        Graph originalGraph = embeddedGraph.getGraph();
        Node newNode = originalGraph.createDummyNode();
        originalGraph.removeEdge(edge);
        IListSequence newEdges = ListSequence.fromList(new ArrayList());
        ListSequence.fromList(newEdges).addElement(originalGraph.connect(edge.getSource(), newNode));
        ListSequence.fromList(newEdges).addElement(originalGraph.connect(newNode, edge.getTarget()));
        MapSequence.fromMap(this.mySplittedEdges).put(edge, newEdges);
        IListSequence facesToProcess = ListSequence.fromList(new ArrayList());
        ListSequence.fromList(facesToProcess).addSequence(ListSequence.fromList(embeddedGraph.getAdjacentFaces(edge)));
        for (Face face : ListSequence.fromList(facesToProcess)) {
            List<Dart> darts = face.getDarts();
            int pos = 0;
            while (ListSequence.fromList(darts).getElement(pos).getEdge() != edge) {
                ++pos;
            }
            Dart dartToReplace = ListSequence.fromList(darts).getElement(pos);
            for (Edge newEdge : ListSequence.fromList(newEdges)) {
                if (!ListSequence.fromList(newEdge.getAdjacentNodes()).contains(dartToReplace.getSource())) continue;
                embeddedGraph.setDart(face, pos, new Dart(newEdge, dartToReplace.getSource()));
            }
            for (Edge newEdge : ListSequence.fromList(newEdges)) {
                if (!ListSequence.fromList(newEdge.getAdjacentNodes()).contains(dartToReplace.getTarget())) continue;
                embeddedGraph.insertDart(face, pos + 1, new Dart(newEdge, newNode));
            }
        }
        return newNode;
    }

    private Face getOuterTreeFace(Graph graph, List<Edge> removed) {
        MyDfs dfs = new MyDfs(this);
        dfs.doDfs(graph, Edge.Direction.BOTH);
        ListSequence.fromList(removed).clear();
        ListSequence.fromList(removed).addSequence(SetSequence.fromSet(dfs.getBackEdges()));
        return dfs.getOuterFace();
    }

    private void mergeEdges() {
        IMapSequence merged = MapSequence.fromMap(new HashMap());
        ISetSequence dummyEdges = SetSequence.fromSet(new HashSet());
        for (Edge edge : SetSequence.fromSet(MapSequence.fromMap(this.mySplittedEdges).keySet())) {
            SetSequence.fromSet(dummyEdges).addSequence((ISequence)ListSequence.fromList((List)MapSequence.fromMap(this.mySplittedEdges).get(edge)));
        }
        for (Edge edge : SetSequence.fromSet(MapSequence.fromMap(this.mySplittedEdges).keySet())) {
            if (SetSequence.fromSet(dummyEdges).contains(edge)) continue;
            MapSequence.fromMap(merged).put(edge, this.mergeEdges(edge));
        }
        this.mySplittedEdges = merged;
    }

    private List<Edge> mergeEdges(Edge splittedEdge) {
        IListSequence<Edge> newEdgeList = ListSequence.fromList(new ArrayList());
        for (Edge edge : ListSequence.fromList((List)MapSequence.fromMap(this.mySplittedEdges).get(splittedEdge))) {
            if (MapSequence.fromMap(this.mySplittedEdges).containsKey(edge)) {
                ListSequence.fromList(newEdgeList).addSequence(ListSequence.fromList(this.mergeEdges(edge)));
                continue;
            }
            ListSequence.fromList(newEdgeList).addElement(edge);
        }
        return newEdgeList;
    }

    public Map<Edge, List<Edge>> getSplittedEdges() {
        return this.mySplittedEdges;
    }

    private class MyDfs
    extends Dfs {
        private Set<Edge> myBackEdges;
        private Face myOuterFace;

        public MyDfs(TreeEmbeddingFinder treeEmbeddingFinder) {
        }

        @Override
        protected void processEdge(Edge edge, Node source) {
            if ((Integer)MapSequence.fromMap(this.getDfsState()).get(edge.getOpposite(source)) == Dfs.BEFORE) {
                this.myOuterFace.addLast(new Dart(edge, source));
            } else {
                SetSequence.fromSet(this.myBackEdges).addElement(edge);
            }
        }

        @Override
        protected void postprocess(Node node, Edge from) {
            if (from != null) {
                this.myOuterFace.addLast(new Dart(from, node));
            }
        }

        @Override
        public void doDfs(Graph graph, Edge.Direction direction) {
            this.myBackEdges = SetSequence.fromSet(new LinkedHashSet());
            this.myOuterFace = new Face(graph);
            super.doDfs(graph, direction);
        }

        public Set<Edge> getBackEdges() {
            return this.myBackEdges;
        }

        public Face getOuterFace() {
            return this.myOuterFace;
        }
    }
}

