/*
 * Decompiled with CFR 0.152.
 */
package com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.stOrthogonalLayout;

import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.algorithms.WeightedTopologicalNumbering;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Edge;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Graph;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.INode;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Node;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.intGeom2D.Dimension;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.intGeom2D.Rectangle;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarGraph.DualGraph;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarGraph.Face;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.planarGraph.STPlanarGraph;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.util.NodeMap;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.IMapSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ListSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.MapSequence;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ConstraintsSupporter {
    private STPlanarGraph myStPlanarGraph;
    private Graph myModifiedGraph;
    private DualGraph myModifiedDualGraph;
    private Map<Node, Node> myInNode;
    private Map<Node, Node> myOutNode;
    private Map<Node, Edge> myFakeEdges;
    private Map<Node, Edge> myFakeDualEdges;
    private Map<Edge, Edge> myEdgesMap;
    private Map<Node, Integer> myHorNumbering;
    private Map<Node, Integer> myVerNumbering;
    private int myMinEdgeXDistance = 10;
    private int myMinEdgeYDistance = 10;

    public Map<Object, Rectangle> getRepresentation(STPlanarGraph stPlanarGraph, Map<Node, Dimension> nodeConstraints, Map<Edge, Dimension> edgeConstraints) {
        this.myStPlanarGraph = stPlanarGraph;
        Graph graph = this.myStPlanarGraph.getGraph();
        this.myModifiedGraph = this.splitNodes(graph);
        this.myModifiedDualGraph = this.modifyDualGraph(stPlanarGraph);
        IMapSequence<Edge, Integer> edgeWeights = MapSequence.fromMap(new HashMap());
        for (Node node : ListSequence.fromList(graph.getNodes())) {
            MapSequence.fromMap(edgeWeights).put((Edge)MapSequence.fromMap(this.myFakeEdges).get(node), ((Dimension)MapSequence.fromMap(nodeConstraints).get((Object)node)).height);
        }
        for (Iterator edge : ListSequence.fromList(graph.getEdges())) {
            MapSequence.fromMap(edgeWeights).put((Edge)MapSequence.fromMap(this.myEdgesMap).get(edge), ((Dimension)MapSequence.fromMap(edgeConstraints).get((Object)edge)).height);
        }
        IMapSequence<Edge, Integer> dualEdgeWeights = MapSequence.fromMap(new HashMap());
        for (Node node : ListSequence.fromList(graph.getNodes())) {
            MapSequence.fromMap(dualEdgeWeights).put((Edge)MapSequence.fromMap(this.myFakeDualEdges).get(node), ((Dimension)MapSequence.fromMap(nodeConstraints).get((Object)node)).width);
        }
        for (Edge edge : ListSequence.fromList(this.myModifiedDualGraph.getEdges())) {
            Edge realEdge = (Edge)MapSequence.fromMap(this.myModifiedDualGraph.getEdgesMap()).get(edge);
            Dimension dimension = (Dimension)MapSequence.fromMap(edgeConstraints).get(realEdge);
            if (dimension == null) continue;
            MapSequence.fromMap(dualEdgeWeights).put(edge, dimension.width);
        }
        this.myVerNumbering = WeightedTopologicalNumbering.number(this.myModifiedGraph, edgeWeights);
        this.myHorNumbering = WeightedTopologicalNumbering.number(this.myModifiedDualGraph, dualEdgeWeights);
        IMapSequence<Object, Rectangle> representation = MapSequence.fromMap(new HashMap());
        for (Node node : ListSequence.fromList(graph.getNodes())) {
            MapSequence.fromMap(representation).put(node, this.getRectangle(node, (Edge)MapSequence.fromMap(this.myFakeEdges).get(node)));
        }
        for (Edge edge : ListSequence.fromList(graph.getEdges())) {
            MapSequence.fromMap(representation).put(edge, this.getRectangle(edge, (Edge)MapSequence.fromMap(this.myEdgesMap).get(edge)));
        }
        return representation;
    }

    private Rectangle getRectangle(Object graphObject, Edge fakeEdge) {
        Face leftFace = this.myStPlanarGraph.getLeftFace(graphObject);
        int minX = (Integer)MapSequence.fromMap(this.myHorNumbering).get(MapSequence.fromMap(this.myModifiedDualGraph.getNodesMap()).get(leftFace));
        int maxX = this.getMaxX(graphObject);
        int minY = (Integer)MapSequence.fromMap(this.myVerNumbering).get(fakeEdge.getSource());
        int maxY = (Integer)MapSequence.fromMap(this.myVerNumbering).get(fakeEdge.getTarget());
        return new Rectangle(minX, minY, maxX - minX, maxY - minY);
    }

    private int getMaxX(Object graphObject) {
        Face rightFace = this.myStPlanarGraph.getRightFace(graphObject);
        int maxX = (Integer)MapSequence.fromMap(this.myHorNumbering).get(MapSequence.fromMap(this.myModifiedDualGraph.getNodesMap()).get(rightFace));
        Face outerFace = this.myStPlanarGraph.getEmbeddedGraph().getOuterFace();
        Node dualTarget = this.myModifiedDualGraph.getNode(this.myModifiedDualGraph.getNumNodes() - 1);
        if (rightFace == outerFace) {
            maxX = (Integer)MapSequence.fromMap(this.myHorNumbering).get(dualTarget);
        }
        return maxX;
    }

    private DualGraph modifyDualGraph(STPlanarGraph stPlanarGraph) {
        this.myFakeDualEdges = MapSequence.fromMap(new HashMap());
        DualGraph dualGraph = stPlanarGraph.getModifiedDualGraph();
        Face outerFace = stPlanarGraph.getEmbeddedGraph().getOuterFace();
        Node dualSource = (Node)MapSequence.fromMap(dualGraph.getNodesMap()).get(outerFace);
        Node dualTarget = dualGraph.getNode(dualGraph.getNumNodes() - 1);
        for (Node node : ListSequence.fromList(stPlanarGraph.getGraph().getNodes())) {
            Face leftFace = stPlanarGraph.getLeftFace(node);
            Node dualLeft = leftFace == outerFace ? dualSource : (Node)MapSequence.fromMap(dualGraph.getNodesMap()).get(leftFace);
            Face rightFace = stPlanarGraph.getRightFace(node);
            Node dualRight = rightFace == outerFace ? dualTarget : (Node)MapSequence.fromMap(dualGraph.getNodesMap()).get(rightFace);
            MapSequence.fromMap(this.myFakeDualEdges).put(node, dualGraph.addEdge(dualLeft, dualRight, (Edge)MapSequence.fromMap(this.myFakeEdges).get(node)));
        }
        return dualGraph;
    }

    private Graph splitNodes(Graph graph) {
        this.myInNode = new NodeMap<Node>(graph);
        this.myOutNode = new NodeMap<Node>(graph);
        this.myFakeEdges = new NodeMap<Edge>(graph);
        this.myEdgesMap = MapSequence.fromMap(new HashMap());
        Graph modifiedGraph = new Graph();
        for (Node node : ListSequence.fromList(graph.getNodes())) {
            MapSequence.fromMap(this.myInNode).put(node, modifiedGraph.createNode());
            MapSequence.fromMap(this.myOutNode).put(node, modifiedGraph.createNode());
            MapSequence.fromMap(this.myFakeEdges).put(node, modifiedGraph.connect((INode)MapSequence.fromMap(this.myInNode).get(node), (INode)MapSequence.fromMap(this.myOutNode).get(node)));
        }
        for (Edge edge : ListSequence.fromList(graph.getEdges())) {
            MapSequence.fromMap(this.myEdgesMap).put(edge, modifiedGraph.connect((INode)MapSequence.fromMap(this.myOutNode).get(edge.getSource()), (INode)MapSequence.fromMap(this.myInNode).get(edge.getTarget())));
        }
        return modifiedGraph;
    }

    public void setMinEdgeDistance(int x, int y) {
        this.myMinEdgeXDistance = x;
        this.myMinEdgeYDistance = y;
    }
}

