/*
 * Decompiled with CFR 0.152.
 */
package com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.stOrthogonalLayout;

import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Edge;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.IEdge;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.INode;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graph.Node;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.graphLayout.GraphLayout;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.intGeom2D.GeomUtil;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.intGeom2D.Point;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.intGeom2D.Rectangle;
import com.vertabelo.autolayout_tool.repackaged.mps.graphLayout.intGeom2D.Util1D;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.IListSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ISequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.ListSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.MapSequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.Sequence;
import com.vertabelo.autolayout_tool.repackaged.mps.internal.collections.runtime.SetSequence;
import java.util.ArrayList;
import java.util.List;

public class LayoutOptimizer {
    private GraphLayout myLayout;

    private LayoutOptimizer(GraphLayout layout) {
        this.myLayout = layout;
    }

    private void optimize() {
        boolean foundOptimize = true;
        while (foundOptimize) {
            foundOptimize = false;
            this.myLayout.refineEdgeLayout();
            block1: for (IEdge edge : SetSequence.fromSet(MapSequence.fromMap(this.myLayout.getEdgeLayout()).keySet())) {
                Edge myEdge = (Edge)edge;
                Iterable path = this.myLayout.getEdgeLayout(edge);
                for (int i = 0; i < ListSequence.fromList(path).count() - 3; ++i) {
                    IListSequence<Point> chain = ListSequence.fromList(new ArrayList());
                    ListSequence.fromList(chain).addElement((Point)ListSequence.fromList(path).getElement(i));
                    ListSequence.fromList(chain).addElement((Point)ListSequence.fromList(path).getElement(i + 1));
                    ListSequence.fromList(chain).addElement((Point)ListSequence.fromList(path).getElement(i + 2));
                    ListSequence.fromList(chain).addElement((Point)ListSequence.fromList(path).getElement(i + 3));
                    List<Point> newChain = this.tryChain(chain, myEdge);
                    if (newChain == null) continue;
                    foundOptimize = true;
                    IListSequence<Point> temp = ListSequence.fromList(new ArrayList());
                    ListSequence.fromList(temp).addSequence((ISequence)ListSequence.fromList(path).subListSequence(0, i));
                    ListSequence.fromList(temp).addSequence(ListSequence.fromList(newChain));
                    ListSequence.fromList(temp).addSequence((ISequence)ListSequence.fromList(path).subListSequence(i + 4, ListSequence.fromList(path).count()));
                    this.myLayout.setLayoutFor(edge, temp);
                    continue block1;
                }
            }
        }
    }

    private List<Point> tryChain(List<Point> chain, Edge edge) {
        boolean verMid = ListSequence.fromList(chain).getElement((int)1).x == ListSequence.fromList(chain).getElement((int)2).x;
        boolean zLike = verMid ? Util1D.insideOpenSegment(ListSequence.fromList(chain).getElement((int)0).x, ListSequence.fromList(chain).getElement((int)3).x, ListSequence.fromList(chain).getElement((int)1).x) : Util1D.insideOpenSegment(ListSequence.fromList(chain).getElement((int)0).y, ListSequence.fromList(chain).getElement((int)3).y, ListSequence.fromList(chain).getElement((int)1).y);
        if (zLike) {
            if (this.testRect(GeomUtil.getRectangle(ListSequence.fromList(chain).getElement(0), ListSequence.fromList(chain).getElement(2)), edge)) {
                return this.getChain(ListSequence.fromList(chain).getElement(0), ListSequence.fromList(chain).getElement(2), ListSequence.fromList(chain).getElement(3));
            }
            if (this.testRect(GeomUtil.getRectangle(ListSequence.fromList(chain).getElement(1), ListSequence.fromList(chain).getElement(3)), edge)) {
                return ListSequence.fromList(this.getChain(ListSequence.fromList(chain).getElement(3), ListSequence.fromList(chain).getElement(1), ListSequence.fromList(chain).getElement(0))).reversedList();
            }
        } else {
            boolean firstSmaller;
            Rectangle first = GeomUtil.getRectangle(ListSequence.fromList(chain).getElement(0), ListSequence.fromList(chain).getElement(2));
            Rectangle second = GeomUtil.getRectangle(ListSequence.fromList(chain).getElement(1), ListSequence.fromList(chain).getElement(3));
            boolean bl = firstSmaller = first.height <= second.height && first.width <= second.width;
            if (firstSmaller) {
                if (this.testRect(first, edge)) {
                    return this.getChain(ListSequence.fromList(chain).getElement(0), ListSequence.fromList(chain).getElement(2), ListSequence.fromList(chain).getElement(3));
                }
            } else if (this.testRect(second, edge)) {
                return ListSequence.fromList(this.getChain(ListSequence.fromList(chain).getElement(3), ListSequence.fromList(chain).getElement(1), ListSequence.fromList(chain).getElement(0))).reversedList();
            }
        }
        return null;
    }

    public List<Point> getChain(Point begin, Point mid, Point end) {
        IListSequence<Point> chain = ListSequence.fromList(new ArrayList());
        ListSequence.fromList(chain).addElement(begin);
        if (mid.x == end.x) {
            ListSequence.fromList(chain).addElement(new Point(mid.x, begin.y));
        } else {
            ListSequence.fromList(chain).addElement(new Point(begin.x, mid.y));
        }
        ListSequence.fromList(chain).addElement(end);
        return chain;
    }

    private boolean testRect(Rectangle rect, Edge edge) {
        for (INode node : SetSequence.fromSet(MapSequence.fromMap(this.myLayout.getNodeLayout()).keySet())) {
            Node myNode = (Node)node;
            if (ListSequence.fromList(edge.getAdjacentNodes()).contains(myNode)) continue;
            Rectangle nodeRect = this.myLayout.getNodeLayout(node);
            if (this.isInsideAndNotACorner(nodeRect.x, nodeRect.y, rect)) {
                return false;
            }
            if (this.isInsideAndNotACorner(nodeRect.x, nodeRect.y + nodeRect.height, rect)) {
                return false;
            }
            if (this.isInsideAndNotACorner(nodeRect.x + nodeRect.width, nodeRect.y, rect)) {
                return false;
            }
            if (!this.isInsideAndNotACorner(nodeRect.x + nodeRect.width, nodeRect.y + nodeRect.height, rect)) continue;
            return false;
        }
        for (List path : Sequence.fromIterable(MapSequence.fromMap(this.myLayout.getEdgeLayout()).values())) {
            for (Point p : ListSequence.fromList(path)) {
                if (!this.isInsideAndNotACorner(p.x, p.y, rect)) continue;
                return false;
            }
        }
        for (Rectangle labelRect : Sequence.fromIterable(MapSequence.fromMap(this.myLayout.getLabelLayout()).values())) {
            if (!Util1D.intersects(labelRect.x, labelRect.x + labelRect.width, rect.x, rect.x + rect.width) || !Util1D.intersects(labelRect.y, labelRect.y + labelRect.height, rect.y, rect.y + rect.height)) continue;
            return false;
        }
        return true;
    }

    private boolean isInsideAndNotACorner(int x, int y, Rectangle rect) {
        boolean insideX = Util1D.insideClosedSegment(rect.x, rect.x + rect.width, x);
        boolean insideY = Util1D.insideClosedSegment(rect.y, rect.y + rect.height, y);
        if (insideX && insideY) {
            boolean notX = x != rect.x && x != rect.x + rect.width;
            boolean notY = y != rect.y && y != rect.y + rect.height;
            return notX || notY;
        }
        return false;
    }

    public static void optimizeEdges(GraphLayout layout) {
        new LayoutOptimizer(layout).optimize();
    }
}

